/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrent;

import com.googlecode.concurrent.CompletionExecutor;
import com.googlecode.concurrent.Executor;
import com.googlecode.concurrent.ExecutorServiceManager$;
import com.googlecode.concurrent.Scheduling;
import com.googlecode.concurrent.Shutdown;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;

public final class ExecutorServiceManager$ {
    public static ExecutorServiceManager$ MODULE$;

    static {
        new ExecutorServiceManager$();
    }

    public Executor wrap(ExecutorService executor) {
        return new Shutdown(executor){
            private final ExecutorService executorService;

            public void shutdown() {
                Shutdown.shutdown$(this);
            }

            public List<Runnable> shutdownNow() {
                return Shutdown.shutdownNow$(this);
            }

            public void awaitTermination(long timeout, TimeUnit unit) {
                Shutdown.awaitTermination$(this, timeout, unit);
            }

            public void awaitTermination(DateTime timeoutWhen) {
                Shutdown.awaitTermination$(this, timeoutWhen);
            }

            public void shutdownAndAwaitTermination(int waitTimeInSeconds) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, waitTimeInSeconds);
            }

            public void shutdownAndAwaitTermination(DateTime timeoutWhen) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, timeoutWhen);
            }

            public ExecutorService executorService() {
                return this.executorService;
            }
            {
                Shutdown.$init$(this);
                this.executorService = executor$1;
            }
        };
    }

    public Executor newSingleThreadExecutor() {
        return new Shutdown(){
            private final ExecutorService executorService;

            public void shutdown() {
                Shutdown.shutdown$(this);
            }

            public List<Runnable> shutdownNow() {
                return Shutdown.shutdownNow$(this);
            }

            public void awaitTermination(long timeout, TimeUnit unit) {
                Shutdown.awaitTermination$(this, timeout, unit);
            }

            public void awaitTermination(DateTime timeoutWhen) {
                Shutdown.awaitTermination$(this, timeoutWhen);
            }

            public void shutdownAndAwaitTermination(int waitTimeInSeconds) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, waitTimeInSeconds);
            }

            public void shutdownAndAwaitTermination(DateTime timeoutWhen) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, timeoutWhen);
            }

            public ExecutorService executorService() {
                return this.executorService;
            }
            {
                Shutdown.$init$(this);
                this.executorService = Executors.newSingleThreadExecutor();
            }
        };
    }

    public Executor newCachedThreadPool(int corePoolSize, int maximumPoolSize, int keepAliveTimeInSeconds, BlockingQueue<Runnable> workQueue) {
        return new Shutdown(corePoolSize, maximumPoolSize, keepAliveTimeInSeconds, workQueue){
            private final ThreadPoolExecutor executorService;

            public void shutdown() {
                Shutdown.shutdown$(this);
            }

            public List<Runnable> shutdownNow() {
                return Shutdown.shutdownNow$(this);
            }

            public void awaitTermination(long timeout, TimeUnit unit) {
                Shutdown.awaitTermination$(this, timeout, unit);
            }

            public void awaitTermination(DateTime timeoutWhen) {
                Shutdown.awaitTermination$(this, timeoutWhen);
            }

            public void shutdownAndAwaitTermination(int waitTimeInSeconds) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, waitTimeInSeconds);
            }

            public void shutdownAndAwaitTermination(DateTime timeoutWhen) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, timeoutWhen);
            }

            public ThreadPoolExecutor executorService() {
                return this.executorService;
            }
            {
                Shutdown.$init$(this);
                this.executorService = new ThreadPoolExecutor(corePoolSize$1, maximumPoolSize$1, keepAliveTimeInSeconds$1, TimeUnit.SECONDS, workQueue$1);
            }
        };
    }

    public int newCachedThreadPool$default$3() {
        return 60;
    }

    public BlockingQueue<Runnable> newCachedThreadPool$default$4() {
        return new SynchronousQueue<Runnable>();
    }

    public <V> CompletionExecutor<V> newCachedThreadPoolCompletionService(int corePoolSize, int maximumPoolSize, int keepAliveTimeInSeconds, BlockingQueue<Runnable> workQueue) {
        return new CompletionExecutor(new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTimeInSeconds, TimeUnit.SECONDS, workQueue));
    }

    public <V> int newCachedThreadPoolCompletionService$default$3() {
        return 60;
    }

    public <V> BlockingQueue<Runnable> newCachedThreadPoolCompletionService$default$4() {
        return new SynchronousQueue<Runnable>();
    }

    public Executor newScheduledThreadPool(int corePoolSize, Function1<Throwable, BoxedUnit> errorLogger) {
        return new Shutdown(corePoolSize, errorLogger){
            private final ScheduledThreadPoolExecutor executorService;
            private final Function1<Throwable, BoxedUnit> onError;

            public <R> ScheduledFuture<R> schedule(long delay, TimeUnit unit, Function0<R> f) {
                return Scheduling.schedule$(this, delay, unit, f);
            }

            public <R> Function1<Function0<R>, ScheduledFuture<R>> schedule(DateTime runAt) {
                return Scheduling.schedule$(this, runAt);
            }

            public <R> void runPeriodically(DateTime firstRun, Function1<Option<R>, Option<DateTime>> process, Function0<R> f) {
                Scheduling.runPeriodically$((Scheduling)this, firstRun, process, f);
            }

            public <R> void runPeriodically(DateTime firstRun, Function0<Option<DateTime>> whenToReRun, Function0<R> f) {
                Scheduling.runPeriodically$((Scheduling)this, firstRun, whenToReRun, f);
            }

            public void shutdown() {
                Shutdown.shutdown$(this);
            }

            public List<Runnable> shutdownNow() {
                return Shutdown.shutdownNow$(this);
            }

            public void awaitTermination(long timeout, TimeUnit unit) {
                Shutdown.awaitTermination$(this, timeout, unit);
            }

            public void awaitTermination(DateTime timeoutWhen) {
                Shutdown.awaitTermination$(this, timeoutWhen);
            }

            public void shutdownAndAwaitTermination(int waitTimeInSeconds) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, waitTimeInSeconds);
            }

            public void shutdownAndAwaitTermination(DateTime timeoutWhen) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, timeoutWhen);
            }

            public ScheduledThreadPoolExecutor executorService() {
                return this.executorService;
            }

            public Function1<Throwable, BoxedUnit> onError() {
                return this.onError;
            }
            {
                Shutdown.$init$(this);
                Scheduling.$init$(this);
                this.executorService = new ScheduledThreadPoolExecutor(corePoolSize$2);
                this.onError = errorLogger$1;
            }
        };
    }

    public Executor newScheduledThreadPool(int corePoolSize) {
        return new Shutdown(corePoolSize){
            private final ScheduledThreadPoolExecutor executorService;
            private final Function1<Throwable, BoxedUnit> onError;

            public <R> ScheduledFuture<R> schedule(long delay, TimeUnit unit, Function0<R> f) {
                return Scheduling.schedule$(this, delay, unit, f);
            }

            public <R> Function1<Function0<R>, ScheduledFuture<R>> schedule(DateTime runAt) {
                return Scheduling.schedule$(this, runAt);
            }

            public <R> void runPeriodically(DateTime firstRun, Function1<Option<R>, Option<DateTime>> process, Function0<R> f) {
                Scheduling.runPeriodically$((Scheduling)this, firstRun, process, f);
            }

            public <R> void runPeriodically(DateTime firstRun, Function0<Option<DateTime>> whenToReRun, Function0<R> f) {
                Scheduling.runPeriodically$((Scheduling)this, firstRun, whenToReRun, f);
            }

            public void shutdown() {
                Shutdown.shutdown$(this);
            }

            public List<Runnable> shutdownNow() {
                return Shutdown.shutdownNow$(this);
            }

            public void awaitTermination(long timeout, TimeUnit unit) {
                Shutdown.awaitTermination$(this, timeout, unit);
            }

            public void awaitTermination(DateTime timeoutWhen) {
                Shutdown.awaitTermination$(this, timeoutWhen);
            }

            public void shutdownAndAwaitTermination(int waitTimeInSeconds) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, waitTimeInSeconds);
            }

            public void shutdownAndAwaitTermination(DateTime timeoutWhen) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, timeoutWhen);
            }

            public ScheduledThreadPoolExecutor executorService() {
                return this.executorService;
            }

            public Function1<Throwable, BoxedUnit> onError() {
                return this.onError;
            }

            public static final /* synthetic */ void $anonfun$onError$1(Throwable t) {
                t.printStackTrace();
            }
            {
                Shutdown.$init$(this);
                Scheduling.$init$(this);
                this.executorService = new ScheduledThreadPoolExecutor(corePoolSize$3);
                this.onError = (Function1 & Serializable & scala.Serializable)t -> {
                    anon.2.$anonfun$onError$1(t);
                    return BoxedUnit.UNIT;
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onError$1$adapted(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public Executor newFixedThreadPool(int nThreads) {
        return new Shutdown(nThreads){
            private final ExecutorService executorService;

            public void shutdown() {
                Shutdown.shutdown$(this);
            }

            public List<Runnable> shutdownNow() {
                return Shutdown.shutdownNow$(this);
            }

            public void awaitTermination(long timeout, TimeUnit unit) {
                Shutdown.awaitTermination$(this, timeout, unit);
            }

            public void awaitTermination(DateTime timeoutWhen) {
                Shutdown.awaitTermination$(this, timeoutWhen);
            }

            public void shutdownAndAwaitTermination(int waitTimeInSeconds) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, waitTimeInSeconds);
            }

            public void shutdownAndAwaitTermination(DateTime timeoutWhen) {
                Shutdown.shutdownAndAwaitTermination$((Shutdown)this, timeoutWhen);
            }

            public ExecutorService executorService() {
                return this.executorService;
            }
            {
                Shutdown.$init$(this);
                this.executorService = Executors.newFixedThreadPool(nThreads$1);
            }
        };
    }

    public <V> CompletionExecutor<V> newFixedThreadPoolCompletionService(int nThreads) {
        return new CompletionExecutor(Executors.newFixedThreadPool(nThreads));
    }

    public <V> Seq<V> lifecycle(int nThreads, int times, Function1<Object, V> f) {
        Seq seq;
        Executor pool = this.newFixedThreadPool(nThreads);
        try {
            IndexedSeq seq2 = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), times).map((Function1 & Serializable & scala.Serializable)i -> pool.submit((Function0 & Serializable & scala.Serializable)() -> f$1.apply((Object)BoxesRunTime.boxToInteger((int)i))), IndexedSeq$.MODULE$.canBuildFrom());
            seq = (Seq)seq2.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(), IndexedSeq$.MODULE$.canBuildFrom());
        }
        finally {
            ((Shutdown)((Object)pool)).shutdown();
        }
        return seq;
    }

    public <T, V> Traversable<V> lifecycle(int nThreads, Traversable<T> params, Function1<T, V> f) {
        Traversable traversable;
        Executor pool = this.newFixedThreadPool(nThreads);
        try {
            Traversable results = (Traversable)params.map((Function1 & Serializable & scala.Serializable)param -> pool.submit((Function0 & Serializable & scala.Serializable)() -> f.apply(param)), Traversable$.MODULE$.canBuildFrom());
            traversable = (Traversable)results.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(), Traversable$.MODULE$.canBuildFrom());
        }
        finally {
            ((Shutdown)((Object)pool)).shutdown();
        }
        return traversable;
    }

    private ExecutorServiceManager$() {
        MODULE$ = this;
    }
}

