/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;
import org.tritonus.core.TAudioConfig;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    private static final AudioFormat.Encoding[] EMPTY_ENCODING_ARRAY = new AudioFormat.Encoding[0];
    private static final AudioFileFormat.Type[] EMPTY_TYPE_ARRAY = new AudioFileFormat.Type[0];
    private static final Mixer.Info[] EMPTY_MIXER_INFO_ARRAY = new Mixer.Info[0];
    private static final Line.Info[] EMPTY_LINE_INFO_ARRAY = new Line.Info[0];

    public static Mixer.Info[] getMixerInfo() {
        GetMixerInfoMixerProviderAction action = new GetMixerInfoMixerProviderAction();
        AudioSystem.doMixerProviderIteration(action);
        Mixer.Info[] infos = action.getMixerInfos();
        return infos;
    }

    public static Mixer getMixer(Mixer.Info info) {
        if (info == null) {
            info = TAudioConfig.getDefaultMixerInfo();
        }
        GetMixerMixerProviderAction action = new GetMixerMixerProviderAction(info);
        AudioSystem.doMixerProviderIteration(action);
        Mixer mixer = action.getMixer();
        if (mixer != null) {
            return mixer;
        }
        throw new IllegalArgumentException("no mixer found for " + info);
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        GetSourceLineInfoMixerAction action = new GetSourceLineInfoMixerAction(info);
        AudioSystem.doMixerIteration(action);
        return action.getInfos();
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        GetTargetLineInfoMixerAction action = new GetTargetLineInfoMixerAction(info);
        AudioSystem.doMixerIteration(action);
        return action.getInfos();
    }

    public static boolean isLineSupported(Line.Info info) {
        IsLineSupportedMixerAction action = new IsLineSupportedMixerAction(info);
        AudioSystem.doMixerIteration(action);
        return action.isSupported();
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        GetLineMixerAction action = new GetLineMixerAction(info);
        AudioSystem.doMixerIteration(action);
        Line line = action.getLine();
        if (line != null) {
            return line;
        }
        if (action.isLineTypeSupported()) {
            throw new LineUnavailableException("currently no line available due to resource restrictions");
        }
        throw new IllegalArgumentException("no mixer supporting this type of line: " + info);
    }

    private static void doEncodingActionWorkaround(boolean bigEndian, AudioFormat.Encoding encoding, GetTargetEncodingsFormatConversionProviderAction action) {
        AudioFormat format = new AudioFormat(encoding, -1.0f, -1, -1, -1, -1.0f, bigEndian);
        action.setSourceDescription(format);
        AudioSystem.doFormatConversionProviderIteration(action);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding sourceEncoding) {
        GetTargetEncodingsFormatConversionProviderAction action = new GetTargetEncodingsFormatConversionProviderAction();
        AudioSystem.doEncodingActionWorkaround(false, sourceEncoding, action);
        AudioSystem.doEncodingActionWorkaround(true, sourceEncoding, action);
        return action.getEncodings();
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        return AudioSystem.getTargetEncodings((Object)sourceFormat);
    }

    private static AudioFormat.Encoding[] getTargetEncodings(Object sourceDescription) {
        GetTargetEncodingsFormatConversionProviderAction action = new GetTargetEncodingsFormatConversionProviderAction(sourceDescription);
        AudioSystem.doFormatConversionProviderIteration(action);
        return action.getEncodings();
    }

    public static boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        IsConversionSupportedFormatConversionProviderAction action = new IsConversionSupportedFormatConversionProviderAction(sourceFormat, targetEncoding);
        AudioSystem.doFormatConversionProviderIteration(action);
        return action.isSupported();
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        return AudioSystem.getAudioInputStreamImpl(targetEncoding, sourceStream);
    }

    private static AudioInputStream getAudioInputStreamImpl(Object targetDescription, AudioInputStream sourceStream) {
        GetAudioInputStreamFormatConversionProviderAction action = new GetAudioInputStreamFormatConversionProviderAction(sourceStream, targetDescription);
        AudioSystem.doFormatConversionProviderIteration(action);
        AudioInputStream audioInputStream = action.getAudioInputStream();
        if (audioInputStream != null) {
            return audioInputStream;
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        return null;
    }

    public static boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        IsConversionSupportedFormatConversionProviderAction action = new IsConversionSupportedFormatConversionProviderAction(sourceFormat, targetFormat);
        AudioSystem.doFormatConversionProviderIteration(action);
        return action.isSupported();
    }

    public static AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        return AudioSystem.getAudioInputStreamImpl(targetFormat, sourceStream);
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioFileFormatImpl(inputStream);
    }

    public static AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioFileFormatImpl(url);
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioFileFormatImpl(file);
    }

    private static AudioFileFormat getAudioFileFormatImpl(Object source) throws UnsupportedAudioFileException, IOException {
        GetAudioFileFormatAudioFileReaderAction action = new GetAudioFileFormatAudioFileReaderAction(source);
        AudioSystem.doAudioFileReaderIteration(action);
        AudioFileFormat audioFileFormat = action.getAudioFileFormat();
        if (audioFileFormat != null) {
            return audioFileFormat;
        }
        throw new UnsupportedAudioFileException("format not supported");
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioInputStreamImpl(inputStream);
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioInputStreamImpl(url);
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return AudioSystem.getAudioInputStreamImpl(file);
    }

    private static AudioInputStream getAudioInputStreamImpl(Object source) throws UnsupportedAudioFileException, IOException {
        GetAudioInputStreamAudioFileReaderAction action = new GetAudioInputStreamAudioFileReaderAction(source);
        AudioSystem.doAudioFileReaderIteration(action);
        AudioInputStream audioInputStream = action.getAudioInputStream();
        if (audioInputStream != null) {
            return audioInputStream;
        }
        throw new UnsupportedAudioFileException("format not supported");
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        HashSet<AudioFileFormat.Type> supportedTypes = new HashSet<AudioFileFormat.Type>();
        Iterator<AudioFileWriter> audioFileWriters = TAudioConfig.getAudioFileWriters();
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.getAudioFileTypes()");
        }
        while (audioFileWriters.hasNext()) {
            AudioFileWriter audioFileProvider = audioFileWriters.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("trying AudioFileWriter: " + audioFileProvider);
            }
            AudioFileFormat.Type[] aSupportedTypes = audioFileProvider.getAudioFileTypes();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("this AudioFileWriter supports the following Types:");
            }
            for (int i = 0; i < aSupportedTypes.length; ++i) {
                if (TDebug.TraceAudioSystem) {
                    TDebug.out(aSupportedTypes[i].toString());
                }
                supportedTypes.add(aSupportedTypes[i]);
            }
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out("< returning " + supportedTypes.size() + " types.");
        }
        return supportedTypes.toArray(EMPTY_TYPE_ARRAY);
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type fileType) {
        return AudioSystem.isFileTypeSupported(fileType, null);
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        HashSet<AudioFileFormat.Type> supportedTypes = new HashSet<AudioFileFormat.Type>();
        Iterator<AudioFileWriter> audioFileWriters = TAudioConfig.getAudioFileWriters();
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.getAudioFileTypes()");
        }
        while (audioFileWriters.hasNext()) {
            AudioFileWriter audioFileProvider = audioFileWriters.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("trying AudioFileWriter: " + audioFileProvider);
            }
            AudioFileFormat.Type[] aSupportedTypes = audioFileProvider.getAudioFileTypes(audioInputStream);
            if (TDebug.TraceAudioSystem) {
                TDebug.out("this AudioFileWriter supports the following Types:");
            }
            for (int i = 0; i < aSupportedTypes.length; ++i) {
                if (TDebug.TraceAudioSystem) {
                    TDebug.out(aSupportedTypes[i].toString());
                }
                supportedTypes.add(aSupportedTypes[i]);
            }
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out("< returning " + supportedTypes.size() + " types.");
        }
        return supportedTypes.toArray(EMPTY_TYPE_ARRAY);
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type fileType, AudioInputStream audioInputStream) {
        IsFileTypeSupportedAudioFileWriterAction action;
        block2: {
            action = new IsFileTypeSupportedAudioFileWriterAction(fileType, audioInputStream);
            try {
                AudioSystem.doAudioFileWriterIteration(action);
            }
            catch (IOException e) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(e);
            }
        }
        return action.isSupported();
    }

    public static int write(AudioInputStream inputStream, AudioFileFormat.Type fileType, OutputStream outputStream) throws IOException {
        return AudioSystem.writeImpl(inputStream, fileType, outputStream);
    }

    public static int write(AudioInputStream inputStream, AudioFileFormat.Type fileType, File file) throws IOException {
        return AudioSystem.writeImpl(inputStream, fileType, file);
    }

    private static int writeImpl(AudioInputStream audioInputStream, AudioFileFormat.Type fileType, Object destination) throws IOException {
        WriteAudioFileWriterAction action = new WriteAudioFileWriterAction(audioInputStream, fileType, destination);
        AudioSystem.doAudioFileWriterIteration(action);
        int nWritten = action.getWritten();
        if (nWritten == -1) {
            throw new IllegalArgumentException("format not  supported");
        }
        return nWritten;
    }

    private static void doMixerProviderIteration(MixerProviderAction action) {
        Iterator<MixerProvider> mixerProviders = TAudioConfig.getMixerProviders();
        boolean bCompleted = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doMixerProviderIteration()");
        }
        while (mixerProviders.hasNext() && !bCompleted) {
            MixerProvider mixerProvider = mixerProviders.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("handling MixerProvider: " + mixerProvider);
            }
            bCompleted = action.handleMixerProvider(mixerProvider);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out("< completed=" + bCompleted);
        }
    }

    private static void doMixerIteration(MixerAction action) {
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        boolean bCompleted = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doMixerIteration()");
        }
        for (int nMixer = 0; nMixer < mixerInfos.length && !bCompleted; ++nMixer) {
            Mixer mixer = AudioSystem.getMixer(mixerInfos[nMixer]);
            if (TDebug.TraceAudioSystem) {
                TDebug.out("handling Mixer: " + mixer);
            }
            bCompleted = action.handleMixer(mixer);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out("< completed=" + bCompleted);
        }
    }

    private static void doFormatConversionProviderIteration(FormatConversionProviderAction action) {
        Iterator<FormatConversionProvider> formatConversionProviders = TAudioConfig.getFormatConversionProviders();
        boolean bCompleted = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doFormatConversionProviderIteration()");
        }
        while (formatConversionProviders.hasNext() && !bCompleted) {
            FormatConversionProvider formatConversionProvider = formatConversionProviders.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("handling FormatConversionProvider: " + formatConversionProvider);
            }
            bCompleted = action.handleFormatConversionProvider(formatConversionProvider);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out("< completed=" + bCompleted);
        }
    }

    private static void doAudioFileReaderIteration(AudioFileReaderAction action) throws IOException {
        Iterator<AudioFileReader> audioFileReaders = TAudioConfig.getAudioFileReaders();
        boolean bCompleted = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doAudioFileReaderIteration()");
        }
        while (audioFileReaders.hasNext() && !bCompleted) {
            AudioFileReader audioFileReader = audioFileReaders.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("handling AudioFileReader: " + audioFileReader);
            }
            bCompleted = action.handleAudioFileReader(audioFileReader);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out("< completed=" + bCompleted);
        }
    }

    private static void doAudioFileWriterIteration(AudioFileWriterAction action) throws IOException {
        Iterator<AudioFileWriter> audioFileWriters = TAudioConfig.getAudioFileWriters();
        boolean bCompleted = false;
        if (TDebug.TraceAudioSystem) {
            TDebug.out(">AudioSystem.doAudioFileWriterIteration()");
        }
        while (audioFileWriters.hasNext() && !bCompleted) {
            AudioFileWriter audioFileWriter = audioFileWriters.next();
            if (TDebug.TraceAudioSystem) {
                TDebug.out("handling AudioFileWriter: " + audioFileWriter);
            }
            bCompleted = action.handleAudioFileWriter(audioFileWriter);
        }
        if (TDebug.TraceAudioSystem) {
            TDebug.out("< completed=" + bCompleted);
        }
    }

    private static interface AudioFileWriterAction {
        public boolean handleAudioFileWriter(AudioFileWriter var1) throws IOException;
    }

    private static interface AudioFileReaderAction {
        public boolean handleAudioFileReader(AudioFileReader var1) throws IOException;
    }

    private static interface FormatConversionProviderAction {
        public boolean handleFormatConversionProvider(FormatConversionProvider var1);
    }

    private static interface MixerAction {
        public boolean handleMixer(Mixer var1);
    }

    private static interface MixerProviderAction {
        public boolean handleMixerProvider(MixerProvider var1);
    }

    private static class WriteAudioFileWriterAction
    implements AudioFileWriterAction {
        private AudioInputStream m_audioInputStream;
        private AudioFileFormat.Type m_fileType;
        private Object m_destination;
        private int m_nWritten;

        public WriteAudioFileWriterAction(AudioInputStream audioInputStream, AudioFileFormat.Type fileType, Object destination) {
            this.m_audioInputStream = audioInputStream;
            this.m_fileType = fileType;
            this.m_destination = destination;
            this.m_nWritten = -1;
        }

        public boolean handleAudioFileWriter(AudioFileWriter audioFileWriter) throws IOException {
            int nWritten = -1;
            if (TDebug.TraceAudioSystem) {
                TDebug.out(">AudioSystem.handleAudioFileWriter(" + audioFileWriter.getClass().getName() + ") checking for type " + this.m_fileType);
            }
            if (!audioFileWriter.isFileTypeSupported(this.m_fileType)) {
                if (TDebug.TraceAudioSystem) {
                    TDebug.out("< is not capable of handling this file type");
                }
                return false;
            }
            try {
                if (this.m_destination instanceof OutputStream) {
                    nWritten = audioFileWriter.write(this.m_audioInputStream, this.m_fileType, (OutputStream)this.m_destination);
                } else if (this.m_destination instanceof File) {
                    nWritten = audioFileWriter.write(this.m_audioInputStream, this.m_fileType, (File)this.m_destination);
                }
                this.m_nWritten = nWritten;
                if (TDebug.TraceAudioSystem) {
                    TDebug.out("< wrote " + nWritten + " bytes");
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                if (TDebug.TraceAudioSystem || TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                if (TDebug.TraceAudioSystem) {
                    TDebug.out("< does not support this file type.");
                }
                return false;
            }
        }

        public int getWritten() {
            return this.m_nWritten;
        }
    }

    private static class IsFileTypeSupportedAudioFileWriterAction
    implements AudioFileWriterAction {
        private AudioFileFormat.Type m_fileType;
        private AudioInputStream m_audioInputStream;
        private boolean m_bSupported;

        public IsFileTypeSupportedAudioFileWriterAction(AudioFileFormat.Type fileType, AudioInputStream audioInputStream) {
            this.m_fileType = fileType;
            this.m_audioInputStream = audioInputStream;
            this.m_bSupported = false;
        }

        public boolean handleAudioFileWriter(AudioFileWriter mixer) {
            boolean bSupported = false;
            bSupported = this.m_audioInputStream == null ? mixer.isFileTypeSupported(this.m_fileType) : mixer.isFileTypeSupported(this.m_fileType, this.m_audioInputStream);
            this.m_bSupported |= bSupported;
            return bSupported;
        }

        public boolean isSupported() {
            return this.m_bSupported;
        }
    }

    private static class GetAudioInputStreamAudioFileReaderAction
    implements AudioFileReaderAction {
        private Object m_source = null;
        private AudioInputStream m_audioInputStream = null;

        public GetAudioInputStreamAudioFileReaderAction(Object source) {
            this.m_source = source;
        }

        public boolean handleAudioFileReader(AudioFileReader audioFileReader) throws IOException {
            block8: {
                AudioInputStream audioInputStream = null;
                try {
                    if (this.m_source instanceof InputStream) {
                        audioInputStream = audioFileReader.getAudioInputStream((InputStream)this.m_source);
                    } else if (this.m_source instanceof File) {
                        audioInputStream = audioFileReader.getAudioInputStream((File)this.m_source);
                    } else if (this.m_source instanceof URL) {
                        audioInputStream = audioFileReader.getAudioInputStream((URL)this.m_source);
                    }
                    if (this.m_audioInputStream == null) {
                        this.m_audioInputStream = audioInputStream;
                        return true;
                    }
                }
                catch (UnsupportedAudioFileException e) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block8;
                    TDebug.out(e);
                }
            }
            return false;
        }

        public AudioInputStream getAudioInputStream() {
            return this.m_audioInputStream;
        }
    }

    private static class GetAudioFileFormatAudioFileReaderAction
    implements AudioFileReaderAction {
        private Object m_source = null;
        private AudioFileFormat m_audioFileFormat = null;

        public GetAudioFileFormatAudioFileReaderAction(Object source) {
            this.m_source = source;
        }

        public boolean handleAudioFileReader(AudioFileReader audioFileReader) throws IOException {
            block8: {
                AudioFileFormat audioFileFormat = null;
                try {
                    if (this.m_source instanceof InputStream) {
                        audioFileFormat = audioFileReader.getAudioFileFormat((InputStream)this.m_source);
                    } else if (this.m_source instanceof File) {
                        audioFileFormat = audioFileReader.getAudioFileFormat((File)this.m_source);
                    } else if (this.m_source instanceof URL) {
                        audioFileFormat = audioFileReader.getAudioFileFormat((URL)this.m_source);
                    }
                    if (this.m_audioFileFormat == null) {
                        this.m_audioFileFormat = audioFileFormat;
                        return true;
                    }
                }
                catch (UnsupportedAudioFileException e) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block8;
                    TDebug.out(e);
                }
            }
            return false;
        }

        public AudioFileFormat getAudioFileFormat() {
            return this.m_audioFileFormat;
        }
    }

    private static class GetAudioInputStreamFormatConversionProviderAction
    implements FormatConversionProviderAction {
        private AudioInputStream m_sourceAudioInputStream;
        private Object m_targetDescription;
        private AudioInputStream m_targetAudioInputStream;

        public GetAudioInputStreamFormatConversionProviderAction(AudioInputStream audioInputStream, Object targetDescription) {
            this.m_sourceAudioInputStream = audioInputStream;
            this.m_targetDescription = targetDescription;
            this.m_targetAudioInputStream = null;
        }

        public boolean handleFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
            AudioInputStream audioInputStream = null;
            try {
                if (this.m_targetDescription instanceof AudioFormat.Encoding) {
                    audioInputStream = formatConversionProvider.getAudioInputStream((AudioFormat.Encoding)this.m_targetDescription, this.m_sourceAudioInputStream);
                } else if (this.m_targetDescription instanceof AudioFormat) {
                    audioInputStream = formatConversionProvider.getAudioInputStream((AudioFormat)this.m_targetDescription, this.m_sourceAudioInputStream);
                }
                this.m_targetAudioInputStream = audioInputStream;
                return true;
            }
            catch (IllegalArgumentException e) {
                if (TDebug.TraceAudioSystem || TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                return false;
            }
        }

        public AudioInputStream getAudioInputStream() {
            return this.m_targetAudioInputStream;
        }
    }

    private static class IsConversionSupportedFormatConversionProviderAction
    implements FormatConversionProviderAction {
        private AudioFormat m_sourceFormat;
        private Object m_targetDescription;
        private boolean m_bSupported;

        public IsConversionSupportedFormatConversionProviderAction(AudioFormat sourceFormat, Object targetDescription) {
            this.m_sourceFormat = sourceFormat;
            this.m_targetDescription = targetDescription;
            this.m_bSupported = false;
        }

        public boolean handleFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
            boolean bSupported = false;
            if (this.m_targetDescription instanceof AudioFormat.Encoding) {
                bSupported = formatConversionProvider.isConversionSupported((AudioFormat.Encoding)this.m_targetDescription, this.m_sourceFormat);
            } else if (this.m_targetDescription instanceof AudioFormat) {
                bSupported = formatConversionProvider.isConversionSupported((AudioFormat)this.m_targetDescription, this.m_sourceFormat);
            }
            this.m_bSupported |= bSupported;
            return bSupported;
        }

        public boolean isSupported() {
            return this.m_bSupported;
        }
    }

    private static class GetTargetEncodingsFormatConversionProviderAction
    implements FormatConversionProviderAction {
        private Object m_sourceDescription;
        private Collection<AudioFormat.Encoding> m_targetEncodings;

        public GetTargetEncodingsFormatConversionProviderAction() {
            this(null);
        }

        public GetTargetEncodingsFormatConversionProviderAction(Object sourceDescription) {
            this.m_sourceDescription = sourceDescription;
            this.m_targetEncodings = new ArraySet<AudioFormat.Encoding>();
        }

        public boolean handleFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
            AudioFormat.Encoding[] encodings = EMPTY_ENCODING_ARRAY;
            if (!(this.m_sourceDescription instanceof AudioFormat.Encoding) && this.m_sourceDescription instanceof AudioFormat) {
                encodings = formatConversionProvider.getTargetEncodings((AudioFormat)this.m_sourceDescription);
            }
            this.m_targetEncodings.addAll(Arrays.asList(encodings));
            return false;
        }

        public AudioFormat.Encoding[] getEncodings() {
            return this.m_targetEncodings.toArray(EMPTY_ENCODING_ARRAY);
        }

        public void setSourceDescription(Object sourceDescription) {
            this.m_sourceDescription = sourceDescription;
        }
    }

    private static class GetLineMixerAction
    implements MixerAction {
        private Line.Info m_info = null;
        private Line m_line = null;
        private boolean m_bLineTypeSupported = false;

        public GetLineMixerAction(Line.Info info) {
            this.m_info = info;
        }

        public boolean handleMixer(Mixer mixer) {
            block5: {
                try {
                    Line line = mixer.getLine(this.m_info);
                    if (this.m_line == null) {
                        this.m_line = line;
                        return true;
                    }
                }
                catch (LineUnavailableException e) {
                    this.m_bLineTypeSupported = true;
                    if (TDebug.TraceAudioSystem || TDebug.TraceAllExceptions) {
                        TDebug.out(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block5;
                    TDebug.out(e);
                }
            }
            return false;
        }

        public Line getLine() {
            return this.m_line;
        }

        public boolean isLineTypeSupported() {
            return this.m_bLineTypeSupported;
        }
    }

    private static class IsLineSupportedMixerAction
    implements MixerAction {
        private Line.Info m_info = null;
        private boolean m_bSupported = false;

        public IsLineSupportedMixerAction(Line.Info info) {
            this.m_info = info;
        }

        public boolean handleMixer(Mixer mixer) {
            boolean bSupported = mixer.isLineSupported(this.m_info);
            this.m_bSupported |= bSupported;
            return bSupported;
        }

        public boolean isSupported() {
            return this.m_bSupported;
        }
    }

    private static class GetTargetLineInfoMixerAction
    implements MixerAction {
        private Line.Info m_info = null;
        private Set<Line.Info> m_infos;

        public GetTargetLineInfoMixerAction(Line.Info info) {
            this.m_info = info;
            this.m_infos = new ArraySet<Line.Info>();
        }

        public boolean handleMixer(Mixer mixer) {
            Line.Info[] infos = mixer.getTargetLineInfo(this.m_info);
            this.m_infos.addAll(Arrays.asList(infos));
            return false;
        }

        public Line.Info[] getInfos() {
            return this.m_infos.toArray(EMPTY_LINE_INFO_ARRAY);
        }
    }

    private static class GetSourceLineInfoMixerAction
    implements MixerAction {
        private Line.Info m_info = null;
        private Set<Line.Info> m_infos;

        public GetSourceLineInfoMixerAction(Line.Info info) {
            this.m_info = info;
            this.m_infos = new ArraySet<Line.Info>();
        }

        public boolean handleMixer(Mixer mixer) {
            Line.Info[] infos = mixer.getSourceLineInfo(this.m_info);
            this.m_infos.addAll(Arrays.asList(infos));
            return false;
        }

        public Line.Info[] getInfos() {
            return this.m_infos.toArray(EMPTY_LINE_INFO_ARRAY);
        }
    }

    private static class GetMixerMixerProviderAction
    implements MixerProviderAction {
        private Mixer.Info m_info = null;
        private Mixer m_mixer = null;

        public GetMixerMixerProviderAction(Mixer.Info info) {
            this.m_info = info;
        }

        public boolean handleMixerProvider(MixerProvider mixerProvider) {
            block3: {
                try {
                    Mixer mixer = mixerProvider.getMixer(this.m_info);
                    if (this.m_mixer == null) {
                        this.m_mixer = mixer;
                        return true;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!TDebug.TraceAudioSystem && !TDebug.TraceAllExceptions) break block3;
                    TDebug.out(e);
                }
            }
            return false;
        }

        public Mixer getMixer() {
            return this.m_mixer;
        }
    }

    private static class GetMixerInfoMixerProviderAction
    implements MixerProviderAction {
        private Collection<Mixer.Info> m_mixerInfos = new ArrayList<Mixer.Info>();

        public boolean handleMixerProvider(MixerProvider mixerProvider) {
            Mixer.Info[] aMixerInfos = mixerProvider.getMixerInfo();
            if (aMixerInfos != null) {
                if (aMixerInfos.length > 0) {
                    if (TDebug.TraceAudioSystem) {
                        TDebug.out("AudioSystem.getMixerInfo(): MixerProvider returns array:");
                        for (int i = 0; i < aMixerInfos.length; ++i) {
                            TDebug.out("" + aMixerInfos[i]);
                        }
                    }
                } else if (TDebug.TraceAudioSystem) {
                    TDebug.out("AudioSystem.getMixerInfo(): MixerProvider returns empty array.");
                }
                this.m_mixerInfos.addAll(Arrays.asList(aMixerInfos));
            } else if (TDebug.TraceAudioSystem) {
                TDebug.out("AudioSystem.getMixerInfo(): MixerProvider returns null.");
            }
            return false;
        }

        public Mixer.Info[] getMixerInfos() {
            return this.m_mixerInfos.toArray(EMPTY_MIXER_INFO_ARRAY);
        }
    }
}

