/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private static final String BASE_NAME = "META-INF/services/";
    private static final boolean REVERSE_ORDER = true;

    public static Iterator providers(Class cls) {
        if (TDebug.TraceService) {
            TDebug.out("Service.providers(): begin");
        }
        String strFullName = BASE_NAME + cls.getName();
        if (TDebug.TraceService) {
            TDebug.out("Service.providers(): full name: " + strFullName);
        }
        List<Object> instancesList = Service.createInstancesList(strFullName);
        Iterator<Object> iterator = instancesList.iterator();
        if (TDebug.TraceService) {
            TDebug.out("Service.providers(): end");
        }
        return iterator;
    }

    private static List<Object> createInstancesList(String strFullName) {
        if (TDebug.TraceService) {
            TDebug.out("Service.createInstancesList(): begin");
        }
        ArrayList<Object> providers = new ArrayList<Object>();
        Iterator<String> classNames = Service.createClassNames(strFullName);
        if (classNames != null) {
            while (classNames.hasNext()) {
                String strClassName = classNames.next();
                if (TDebug.TraceService) {
                    TDebug.out("Service.createInstancesList(): Class name: " + strClassName);
                }
                try {
                    ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                    Class<?> cls = Class.forName(strClassName, true, systemClassLoader);
                    if (TDebug.TraceService) {
                        TDebug.out("Service.createInstancesList(): now creating instance of " + cls);
                    }
                    Object instance = cls.newInstance();
                    providers.add(0, instance);
                }
                catch (ClassNotFoundException e) {
                    if (!TDebug.TraceService && !TDebug.TraceAllExceptions) continue;
                    TDebug.out(e);
                }
                catch (InstantiationException e) {
                    if (!TDebug.TraceService && !TDebug.TraceAllExceptions) continue;
                    TDebug.out(e);
                }
                catch (IllegalAccessException e) {
                    if (!TDebug.TraceService && !TDebug.TraceAllExceptions) continue;
                    TDebug.out(e);
                }
                catch (Throwable e) {
                    if (!TDebug.TraceService && !TDebug.TraceAllExceptions) continue;
                    TDebug.out(e);
                }
            }
        }
        if (TDebug.TraceService) {
            TDebug.out("Service.createInstancesList(): end");
        }
        return providers;
    }

    private static Iterator<String> createClassNames(String strFullName) {
        Enumeration<URL> configs;
        ArraySet<String> providers;
        block15: {
            if (TDebug.TraceService) {
                TDebug.out("Service.createClassNames(): begin");
            }
            providers = new ArraySet<String>();
            configs = null;
            try {
                configs = ClassLoader.getSystemResources(strFullName);
            }
            catch (IOException e) {
                if (!TDebug.TraceService && !TDebug.TraceAllExceptions) break block15;
                TDebug.out(e);
            }
        }
        if (configs != null) {
            while (configs.hasMoreElements()) {
                InputStream input;
                block16: {
                    URL configFileUrl = configs.nextElement();
                    if (TDebug.TraceService) {
                        TDebug.out("Service.createClassNames(): config: " + configFileUrl);
                    }
                    input = null;
                    try {
                        input = configFileUrl.openStream();
                    }
                    catch (IOException e) {
                        if (!TDebug.TraceService && !TDebug.TraceAllExceptions) break block16;
                        TDebug.out(e);
                    }
                }
                if (input == null) continue;
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                try {
                    String strLine = reader.readLine();
                    while (strLine != null) {
                        int nPos = (strLine = strLine.trim()).indexOf(35);
                        if (nPos >= 0) {
                            strLine = strLine.substring(0, nPos);
                        }
                        if (strLine.length() > 0) {
                            providers.add(strLine);
                            if (TDebug.TraceService) {
                                TDebug.out("Service.createClassNames(): adding class name: " + strLine);
                            }
                        }
                        strLine = reader.readLine();
                    }
                }
                catch (IOException e) {
                    if (!TDebug.TraceService && !TDebug.TraceAllExceptions) continue;
                    TDebug.out(e);
                }
            }
        }
        Iterator<String> iterator = providers.iterator();
        if (TDebug.TraceService) {
            TDebug.out("Service.createClassNames(): end");
        }
        return iterator;
    }
}

