/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import org.tritonus.share.midi.MidiUtils;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private static final byte[] DEFAULT_MESSAGE = new byte[]{-1, 47, 0};

    public MetaMessage() {
        super(null);
    }

    protected MetaMessage(byte[] abData) {
        super(abData);
    }

    public void setMessage(int nType, byte[] abData, int nDataLength) throws InvalidMidiDataException {
        if (nType > 127) {
            throw new InvalidMidiDataException("type must not exceed 127");
        }
        int nCompleteLength = 2 + nDataLength;
        byte[] abCompleteData = new byte[nCompleteLength];
        abCompleteData[0] = -1;
        abCompleteData[1] = (byte)nType;
        System.arraycopy(abData, 0, abCompleteData, 2, nDataLength);
        super.setMessage(abCompleteData, nCompleteLength);
    }

    public int getType() {
        int nType = MidiUtils.getUnsignedInteger(this.getMessage()[1]);
        return nType;
    }

    public byte[] getData() {
        int nDataLength = this.getLength() - 2;
        byte[] abData = new byte[nDataLength];
        System.arraycopy(this.getMessage(), 2, abData, 0, nDataLength);
        return abData;
    }

    public Object clone() {
        byte[] abData = this.getMessage();
        MetaMessage message = new MetaMessage(abData);
        return message;
    }
}

