/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.instrumentation.InstrumentedClassLoader;
import com.google.testing.threadtester.MethodCaller;
import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.TestInstrumenter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseThreadedTestRunner {
    private static final String RUN_TESTS = "runTests";
    private static final String SET_DEBUG = "setDebug";
    private static final String SET_TIMEOUT = "setTimeout";
    private boolean debug = false;
    private long timeout = 1000L;

    public void setDebug(boolean newDebug) {
        this.debug = newDebug;
    }

    public void setTimeout(long newTimeout) {
        this.timeout = newTimeout;
    }

    public boolean inThreadedTest() {
        ClassLoader cl = this.getClass().getClassLoader();
        return cl.getClass().getName().equals(InstrumentedClassLoader.class.getName());
    }

    public void runTests(Class<?> test, Class<?> ... targets) {
        ArrayList<String> targetNames = new ArrayList<String>(targets.length);
        for (Class<?> target : targets) {
            targetNames.add(target.getName());
        }
        this.runTests(test.getName(), targetNames);
    }

    public final void runTests(Class<?> tester, List<Class<?>> targets) {
        ArrayList<String> targetNames = new ArrayList<String>(targets.size());
        for (Class<?> target : targets) {
            targetNames.add(target.getName());
        }
        this.runTests(tester.getName(), targetNames);
    }

    private void runTests(String mainName, List<String> targets) {
        TestInstrumenter instrumenter = new TestInstrumenter(targets);
        InstrumentedClassLoader loader = new InstrumentedClassLoader(instrumenter);
        this.setOptions(loader);
        String wrapperName = this.getWrapperName();
        Class<?> wrapperClass = loader.getExpectedClass(wrapperName);
        Class<?> testClass = loader.getExpectedClass(mainName);
        Object wrapper = MethodCaller.newInstance(wrapperClass);
        Method runTests = MethodCaller.getDeclaredMethod(wrapperClass, RUN_TESTS, Class.class, List.class);
        MethodCaller.invoke(runTests, wrapper, testClass, targets);
    }

    private void setOptions(InstrumentedClassLoader loader) {
        if (this.debug || this.timeout != 1000L) {
            Class<?> optionsClass = loader.getExpectedClass(Options.class.getName());
            Method setDebug = MethodCaller.getDeclaredMethod(optionsClass, SET_DEBUG, Boolean.TYPE);
            Method setTimeout = MethodCaller.getDeclaredMethod(optionsClass, SET_TIMEOUT, Long.TYPE);
            setDebug.setAccessible(true);
            setTimeout.setAccessible(true);
            MethodCaller.invoke(setDebug, null, this.debug);
            MethodCaller.invoke(setTimeout, null, this.timeout);
        }
    }

    protected abstract String getWrapperName();
}

