/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.AbstractBreakpoint;
import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.ObjectInstrumentationImpl;

abstract class InstrumentedCodeBreakpoint
extends AbstractBreakpoint {
    private volatile ObjectInstrumentationImpl<?> owner = null;

    InstrumentedCodeBreakpoint(Thread thread) {
        super(thread);
    }

    boolean matches(CodePosition otherPosition) {
        if (this.enabled && this.doesMatch(otherPosition)) {
            ++this.numHits;
            return this.numHits >= this.limit;
        }
        return false;
    }

    protected abstract boolean doesMatch(CodePosition var1);

    protected abstract String getPositionDescription();

    void atBreakpoint(ObjectInstrumentationImpl<?> breakpointOwner) {
        this.hitBreakpoint();
    }

    void setOwner(ObjectInstrumentationImpl<?> owner) {
        this.owner = owner;
    }

    ObjectInstrumentationImpl<?> getOwner() {
        return this.owner;
    }

    @Override
    public String toString() {
        return "Breakpoint(" + this.getId() + ") @ " + this.getPositionDescription();
    }
}

