/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.InstrumentedCodePosition;

class LineCodePosition
extends InstrumentedCodePosition {
    private final int lineNumber;

    LineCodePosition(int lineNumber) {
        if (lineNumber < 0) {
            throw new IllegalArgumentException("Invalid line number " + lineNumber);
        }
        this.lineNumber = lineNumber;
    }

    @Override
    boolean matches(CodePosition p) {
        if (p instanceof LineCodePosition) {
            LineCodePosition position = (LineCodePosition)p;
            return this.lineNumber == position.lineNumber || this.lineNumber == 0 || position.lineNumber == 0;
        }
        return false;
    }

    public String toString() {
        return "at line " + this.lineNumber;
    }
}

