/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.Breakpoint;
import com.google.testing.threadtester.ClassInstrumentation;
import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.Instrumentation;
import com.google.testing.threadtester.ObjectInstrumentation;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class MethodRecorder<T> {
    private final ObjectInstrumentation<T> instrumentedObject;
    private final ClassInstrumentation instrumentedClass;
    private T controlObject;
    private volatile Method lastControlMethod;
    private volatile Method lastTargetMethod;
    private Objenesis objenesis = new ObjenesisStd();
    private volatile Position position = Position.UNDEFINED;

    private Object create(Class<?> clss, Interceptor interceptor) {
        Enhancer e = new Enhancer();
        e.setSuperclass(clss);
        e.setCallbackType(interceptor.getClass());
        Class controlClass = e.createClass();
        Enhancer.registerCallbacks((Class)controlClass, (Callback[])new Callback[]{interceptor});
        Factory result = (Factory)this.objenesis.newInstance(controlClass);
        result.getCallback(0);
        Enhancer.registerCallbacks((Class)controlClass, null);
        return result;
    }

    public MethodRecorder(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Main object cannot be null");
        }
        this.instrumentedObject = Instrumentation.getObjectInstrumentation(object);
        this.instrumentedClass = Instrumentation.getClassInstrumentationForObject(object);
        this.initialize(object.getClass());
    }

    public MethodRecorder(Class<T> clss) {
        if (clss == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        this.instrumentedObject = null;
        this.instrumentedClass = Instrumentation.getClassInstrumentation(clss);
        this.initialize(clss);
    }

    private void initialize(Class<T> clss) {
        Interceptor interceptor = new Interceptor(){

            @Override
            void intercepted(Method method) {
                MethodRecorder.this.lastControlMethod = method;
            }
        };
        this.controlObject = this.create(clss, interceptor);
    }

    public T getControl() {
        return this.controlObject;
    }

    public <T> T createTarget(Class<T> clss) {
        if (clss == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        Interceptor interceptor = new Interceptor(){

            @Override
            void intercepted(Method method) {
                MethodRecorder.this.lastTargetMethod = method;
            }
        };
        return (T)this.create(clss, interceptor);
    }

    ObjectInstrumentation<T> getInstrumentedObject() {
        return this.instrumentedObject;
    }

    ClassInstrumentation getInstrumentedClass() {
        return this.instrumentedClass;
    }

    public MethodRecorder<T> in(Object result) {
        if (this.lastControlMethod == null) {
            throw new IllegalStateException("Must call a control method first");
        }
        this.lastTargetMethod = null;
        this.position = Position.WITHIN;
        return this;
    }

    public MethodRecorder<T> inLastMethod() {
        return this.in(null);
    }

    public MethodRecorder<T> atStartOf(Object result) {
        if (this.lastControlMethod == null) {
            throw new IllegalStateException("Must call a control method first");
        }
        this.position = Position.START;
        return this;
    }

    public MethodRecorder<T> atStartOfLastMethod() {
        return this.atStartOf(null);
    }

    public MethodRecorder<T> atEndOf(Object result) {
        if (this.lastControlMethod == null) {
            throw new IllegalStateException("Must call a control method first");
        }
        this.position = Position.END;
        return this;
    }

    public MethodRecorder<T> atEndOfLastMethod() {
        return this.atEndOf(null);
    }

    public MethodRecorder<T> beforeCalling(Object result) {
        if (this.position != Position.WITHIN) {
            throw new IllegalStateException("Must call a control method first");
        }
        if (this.lastTargetMethod == null) {
            throw new IllegalStateException("Must call a target method first");
        }
        this.position = Position.BEFORE_TARGET;
        return this;
    }

    public MethodRecorder<T> beforeCallingLastMethod() {
        return this.beforeCalling(null);
    }

    public MethodRecorder<T> afterCalling(Object result) {
        if (this.position != Position.WITHIN) {
            throw new IllegalStateException("Must call a control method first");
        }
        if (this.lastTargetMethod == null) {
            throw new IllegalStateException("Must call a target method first");
        }
        this.position = Position.AFTER_TARGET;
        return this;
    }

    public MethodRecorder<T> afterCallingLastMethod() {
        return this.afterCalling(null);
    }

    public CodePosition position() {
        if (this.position == Position.UNDEFINED) {
            throw new IllegalStateException("No method has been called");
        }
        return this.getPosition();
    }

    CodePosition getPositionIfAny() {
        if (this.position == Position.UNDEFINED) {
            return null;
        }
        return this.getPosition();
    }

    private CodePosition getPosition() {
        switch (this.position) {
            case START: 
            case END: {
                if (this.lastTargetMethod == null) break;
                throw new IllegalStateException("Cannot combine start/end with target object method");
            }
            case WITHIN: {
                throw new IllegalStateException("Must specify a target object method");
            }
        }
        try {
            switch (this.position) {
                case START: {
                    CodePosition codePosition = this.instrumentedClass.atMethodStart(this.lastControlMethod);
                    return codePosition;
                }
                case END: {
                    CodePosition codePosition = this.instrumentedClass.atMethodEnd(this.lastControlMethod);
                    return codePosition;
                }
                case BEFORE_TARGET: {
                    CodePosition codePosition = this.instrumentedClass.beforeCall(this.lastControlMethod, this.lastTargetMethod);
                    return codePosition;
                }
                case AFTER_TARGET: {
                    CodePosition codePosition = this.instrumentedClass.afterCall(this.lastControlMethod, this.lastTargetMethod);
                    return codePosition;
                }
            }
            throw new IllegalStateException("Unknown state " + (Object)((Object)this.position));
        }
        finally {
            this.position = Position.UNDEFINED;
            this.lastControlMethod = null;
            this.lastTargetMethod = null;
        }
    }

    public Breakpoint breakpoint(Thread thread) {
        if (this.instrumentedObject == null) {
            throw new IllegalStateException("Cannot get breakpoint unless recorder was created with an object");
        }
        return this.instrumentedObject.createBreakpoint(this.position(), thread);
    }

    private abstract class Interceptor
    implements MethodInterceptor {
        private Interceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            this.intercepted(method);
            return null;
        }

        abstract void intercepted(Method var1);
    }

    private static enum Position {
        START,
        END,
        WITHIN,
        BEFORE_TARGET,
        AFTER_TARGET,
        UNDEFINED;

    }
}

