/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.InstrumentedCodeBreakpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class MultiPositionBreakpoint
extends InstrumentedCodeBreakpoint {
    private List<CodePosition> positions;
    private List<CodePosition> matchers = new ArrayList<CodePosition>();

    MultiPositionBreakpoint(Thread thread, Collection<CodePosition> positions) {
        super(thread);
        for (CodePosition position : positions) {
            if (position != null) continue;
            throw new IllegalArgumentException("Cannot add null position");
        }
        this.positions = new ArrayList<CodePosition>(positions);
    }

    MultiPositionBreakpoint(Thread thread, CodePosition pos1, CodePosition pos2) {
        super(thread);
        if (pos1 == null || pos2 == null) {
            throw new IllegalArgumentException("Cannot add null position");
        }
        this.positions = new ArrayList<CodePosition>(2);
        Collections.addAll(this.positions, pos1, pos2);
    }

    @Override
    protected synchronized boolean doesMatch(CodePosition otherPosition) {
        this.matchers.clear();
        for (CodePosition position : this.positions) {
            if (!position.matches(otherPosition)) continue;
            this.matchers.add(position);
        }
        return this.matchers.size() > 0;
    }

    synchronized List<CodePosition> getMatchers() {
        return new ArrayList<CodePosition>(this.matchers);
    }

    @Override
    protected String getPositionDescription() {
        String result = new String();
        for (CodePosition position : this.positions) {
            result = result + position;
            result = result + " ";
        }
        return result;
    }
}

