/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.AnyPositionBreakpoint;
import com.google.testing.threadtester.Breakpoint;
import com.google.testing.threadtester.CallLogger;
import com.google.testing.threadtester.CallLoggerFactory;
import com.google.testing.threadtester.ClassInstrumentation;
import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.InstrumentedCodeBreakpoint;
import com.google.testing.threadtester.InstrumentedCodePosition;
import com.google.testing.threadtester.LineCodePosition;
import com.google.testing.threadtester.LineInstrumentation;
import com.google.testing.threadtester.MethodInstrumentation;
import com.google.testing.threadtester.MultiPositionBreakpoint;
import com.google.testing.threadtester.ObjectInstrumentation;
import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.SteppedRunResult;
import com.google.testing.threadtester.Stepper;
import com.google.testing.threadtester.StepperImpl;
import com.google.testing.threadtester.TestThread;
import com.google.testing.threadtester.TestTimeoutException;
import com.google.testing.threadtester.ThreadMonitor;
import com.google.testing.threadtester.ThrowingRunnable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

class ObjectInstrumentationImpl<T>
implements CallLogger,
ObjectInstrumentation<T> {
    private T baseObject;
    private ClassInstrumentation instrumentedClass;
    private static final WeakHashMap<Thread, ThreadInfo> threadMap = new WeakHashMap();

    public static <T> ObjectInstrumentationImpl<T> getObject(T baseObject) {
        return CallLoggerFactory.getFactory().getObjectInstrumentation(baseObject);
    }

    ObjectInstrumentationImpl(T baseObject) {
        this.baseObject = baseObject;
        CallLoggerFactory factory = CallLoggerFactory.getFactory();
        this.instrumentedClass = factory.getClassInstrumentation(baseObject.getClass());
    }

    @Override
    public T getUnderlyingObject() {
        return this.baseObject;
    }

    @Override
    public Breakpoint createBreakpoint(CodePosition position, Thread thread) {
        return this.createBreakpointImpl(position, thread);
    }

    private InstrumentedCodeBreakpoint createBreakpointImpl(CodePosition position, Thread thread) {
        InstrumentedCodePosition codePos = (InstrumentedCodePosition)position;
        InstrumentedCodeBreakpoint breakPoint = codePos.createBreakpoint(thread);
        this.addBreakpoint(thread, breakPoint);
        return breakPoint;
    }

    void registerBreakpoint(InstrumentedCodeBreakpoint breakPoint) {
        this.addBreakpoint(breakPoint.getThread(), breakPoint);
    }

    private ThreadInfo getThreadInfoTolerant(Thread thread) {
        ThreadInfo info = threadMap.get(thread);
        if (info == null) {
            info = new ThreadInfo();
            threadMap.put(thread, info);
        }
        return info;
    }

    private ThreadInfo getThreadInfo(Thread thread) {
        ThreadInfo info = threadMap.get(thread);
        if (info == null) {
            throw new IllegalStateException("Unknown thread " + thread);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBreakpoint(Thread thread, InstrumentedCodeBreakpoint breakPoint) {
        WeakHashMap<Thread, ThreadInfo> weakHashMap = threadMap;
        synchronized (weakHashMap) {
            ThreadInfo info = this.getThreadInfoTolerant(thread);
            info.breakPoints.add(breakPoint);
            breakPoint.setOwner(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentLineNumber(Thread thread, int lineNumber) {
        WeakHashMap<Thread, ThreadInfo> weakHashMap = threadMap;
        synchronized (weakHashMap) {
            this.getThreadInfo((Thread)thread).currentLine = lineNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndClearCurrentLineNumber(Thread thread) {
        WeakHashMap<Thread, ThreadInfo> weakHashMap = threadMap;
        synchronized (weakHashMap) {
            ThreadInfo info = this.getThreadInfo(thread);
            int result = info.currentLine;
            info.currentLine = -1;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCallDepth(Thread thread) {
        WeakHashMap<Thread, ThreadInfo> weakHashMap = threadMap;
        synchronized (weakHashMap) {
            return this.getThreadInfo((Thread)thread).callDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementCallDepth(Thread thread) {
        WeakHashMap<Thread, ThreadInfo> weakHashMap = threadMap;
        synchronized (weakHashMap) {
            ++this.getThreadInfoTolerant((Thread)thread).callDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementCallDepth(Thread thread) {
        WeakHashMap<Thread, ThreadInfo> weakHashMap = threadMap;
        synchronized (weakHashMap) {
            --this.getThreadInfo((Thread)thread).callDepth;
        }
    }

    @Override
    public Stepper step(Breakpoint bp) {
        if (!bp.isBlocked()) {
            throw new IllegalStateException("Cannot step unless waiting at breakpoint");
        }
        boolean hasNext = this.getCallDepth(bp.getThread()) > 0;
        return new StepperImpl(this, bp, hasNext);
    }

    void stepFromStepper(StepperImpl stepper) throws TestTimeoutException {
        Breakpoint toStepFrom = stepper.getCurrentBreakpoint();
        Thread thread = toStepFrom.getThread();
        if (this.getCallDepth(thread) == 0) {
            throw new IllegalStateException("Cannot step when call depth is 0");
        }
        AnyPositionBreakpoint next = new AnyPositionBreakpoint(thread);
        this.registerBreakpoint(next);
        toStepFrom.resume(next);
        stepper.setCurrentBreakpoint(next);
        stepper.setHasNext(this.getCallDepth(thread) > 0);
    }

    SteppedRunResult interleave(ThrowingRunnable main, MethodInstrumentation mainMethod, int lineCount, ThrowingRunnable secondary, boolean secondaryCanBlock, CodePosition startPosition, int startCount) {
        int targetLine;
        List<LineInstrumentation> lines = mainMethod.getLines();
        int currLine = lines.get(0).getLineNumber();
        if (lineCount < 0) {
            if (startPosition == null) {
                throw new IllegalArgumentException("Must specify startPosition if lineCount < 0");
            }
            targetLine = -1;
        } else {
            if (lineCount < 0 || lineCount >= lines.size()) {
                throw new IllegalArgumentException("Invalid lineCount " + lineCount);
            }
            if (startPosition == null && startCount != 0) {
                throw new IllegalArgumentException("Cannot specify startCount without startPosition");
            }
            targetLine = lines.get(lineCount).getLineNumber();
        }
        Options.debugPrint("interleave to line %d from %s %d\n", targetLine, startPosition, startCount);
        String name = mainMethod.toString();
        TestThread mainThread = new TestThread(main, "Main Test Thread " + name);
        TestThread secondThread = new TestThread(secondary, "Second Test Thread " + name);
        boolean atEndOfMethod = false;
        Throwable mainException = null;
        try {
            if (startPosition == null) {
                startPosition = this.instrumentedClass.atMethodStart(mainMethod.getUnderlyingMethod());
            }
            InstrumentedCodeBreakpoint startBreakpoint = this.createBreakpointImpl(startPosition, mainThread);
            Options.debugPrint("Using start breakpoint %s\n", startBreakpoint);
            InstrumentedCodeBreakpoint continueBreakpoint = startBreakpoint;
            startBreakpoint.setLimit(startCount == 0 ? 1 : startCount);
            Stepper stepper = null;
            mainThread.start();
            startBreakpoint.await();
            currLine = this.getAndClearCurrentLineNumber(mainThread);
            Options.debugPrint("Reached start point at line %d\n", currLine);
            boolean atEnd = false;
            if (currLine < targetLine) {
                LineCodePosition targetLinePos = new LineCodePosition(targetLine);
                CodePosition endPosition = this.instrumentedClass.atMethodEnd(mainMethod.getUnderlyingMethod());
                MultiPositionBreakpoint targetBreakpoint = new MultiPositionBreakpoint(mainThread, targetLinePos, endPosition);
                this.addBreakpoint(mainThread, targetBreakpoint);
                continueBreakpoint = targetBreakpoint;
                startBreakpoint.resume(targetBreakpoint);
                atEnd = targetBreakpoint.getMatchers().contains(endPosition);
            }
            currLine = this.getAndClearCurrentLineNumber(mainThread);
            Options.debugPrint("Reached line %d, atEnd %s\n", currLine, atEnd);
            Options.debugPrint("Starting second thread\n");
            secondThread.start();
            boolean secondFinished = new ThreadMonitor(secondThread, mainThread).waitForThread();
            Options.debugPrint("secondFinished = %s\n", secondFinished);
            if (!secondFinished && !secondaryCanBlock) {
                throw new TestTimeoutException("Second thread blocked", secondThread);
            }
            if (!secondFinished) {
                if (stepper == null) {
                    stepper = this.step(continueBreakpoint);
                }
                while (stepper.hasNext() && !secondFinished) {
                    Options.debugPrint("  stepping - secondFinished = %s\n", secondFinished);
                    secondFinished = new ThreadMonitor(secondThread, mainThread).waitForThread();
                    stepper.step();
                }
            }
            if (stepper == null) {
                continueBreakpoint.resume();
            } else {
                stepper.resume();
            }
            mainThread.finish();
            if (!secondFinished) {
                secondFinished = new ThreadMonitor(secondThread, mainThread).waitForThread();
            }
            if (!secondFinished) {
                throw new TestTimeoutException("Main thread has finished but second thread has not", secondThread);
            }
        }
        catch (TestTimeoutException e) {
            if (e.getThread() == mainThread) {
                Throwable threadException = mainThread.getException();
                if (threadException == null) {
                    threadException = e;
                }
                return new SteppedRunResult(threadException, null, currLine);
            }
            Throwable threadException = secondThread.getException();
            if (threadException == null) {
                threadException = e;
            }
            return new SteppedRunResult(null, threadException, currLine);
        }
        catch (InterruptedException e) {
            mainException = e;
        }
        if (mainException == null) {
            mainException = mainThread.getException();
        }
        return new SteppedRunResult(mainException, secondThread.getException(), currLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBreakpoint(Thread thread, CodePosition position) {
        ArrayList<InstrumentedCodeBreakpoint> hitPoints = new ArrayList<InstrumentedCodeBreakpoint>();
        WeakHashMap<Thread, ThreadInfo> weakHashMap = threadMap;
        synchronized (weakHashMap) {
            ThreadInfo info = this.getThreadInfo(thread);
            Iterator<InstrumentedCodeBreakpoint> it = info.breakPoints.iterator();
            while (it.hasNext()) {
                InstrumentedCodeBreakpoint breakPoint = it.next();
                if (!breakPoint.matches(position)) continue;
                it.remove();
                hitPoints.add(breakPoint);
            }
        }
        for (InstrumentedCodeBreakpoint hitPoint : hitPoints) {
            hitPoint.atBreakpoint(this);
        }
    }

    @Override
    public void atLine(int line) {
        Options.debugPrint("atLine %d in %s\n", line, Thread.currentThread());
        this.setCurrentLineNumber(Thread.currentThread(), line);
        LineCodePosition position = new LineCodePosition(line);
        this.checkBreakpoint(Thread.currentThread(), position);
    }

    @Override
    public void start(Method method) {
        Options.debugPrint("start %s in %s\n", method.toGenericString(), Thread.currentThread());
        this.incrementCallDepth(Thread.currentThread());
        CodePosition position = this.instrumentedClass.atMethodStart(method);
        this.checkBreakpoint(Thread.currentThread(), position);
    }

    @Override
    public void end(Method method) {
        Options.debugPrint("end %s in %s\n", method.getName(), Thread.currentThread());
        this.decrementCallDepth(Thread.currentThread());
        CodePosition position = this.instrumentedClass.atMethodEnd(method);
        this.checkBreakpoint(Thread.currentThread(), position);
    }

    @Override
    public void beginCall(Method source, int line, Method target) {
        Options.debugPrint("  begin call %s->%s in %s\n", source.getName(), target.getName(), Thread.currentThread());
        CodePosition position = this.instrumentedClass.beforeCall(source, target);
        this.checkBreakpoint(Thread.currentThread(), position);
    }

    @Override
    public void endCall(Method source, int line, Method target) {
        Options.debugPrint("  end call %s->%s in %s\n", source.getName(), target.getName(), Thread.currentThread());
        CodePosition position = this.instrumentedClass.afterCall(source, target);
        this.checkBreakpoint(Thread.currentThread(), position);
    }

    private static class ThreadInfo {
        int callDepth;
        int currentLine = -1;
        Set<InstrumentedCodeBreakpoint> breakPoints = new HashSet<InstrumentedCodeBreakpoint>();

        private ThreadInfo() {
        }
    }
}

