/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.TestTimeoutException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadMonitor {
    private static final long JOIN_TIME = 50L;
    private static final long MIN_NUM_TRIES = 5L;
    private final long numTries;
    private Thread toWait;
    private Thread other;
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    public ThreadMonitor(Thread toWait, Thread other) {
        this.toWait = toWait;
        this.other = other;
        this.numTries = Math.max(Options.timeout() / 50L, 5L);
    }

    public static long getBlockerId(Thread thread) {
        long blocker = -1L;
        Thread.State state = thread.getState();
        if (state == Thread.State.BLOCKED) {
            long lockOwner;
            Options.debugPrint("Thread %s (%d) is %s,\n", new Object[]{thread, thread.getId(), state});
            ThreadInfo info = threadBean.getThreadInfo(thread.getId());
            if (info != null && (lockOwner = info.getLockOwnerId()) != -1L && lockOwner != thread.getId()) {
                blocker = lockOwner;
            }
        }
        return blocker;
    }

    private boolean isBlocked(Thread thread) {
        boolean blocked = false;
        Thread.State state = thread.getState();
        if (state == Thread.State.BLOCKED || state == Thread.State.WAITING) {
            ThreadInfo info;
            blocked = true;
            Options.debugPrint("Thread %s (%d) is %s, other = %s\n", new Object[]{thread, thread.getId(), state, this.other.getState()});
            if (state == Thread.State.BLOCKED && (info = threadBean.getThreadInfo(thread.getId())) != null) {
                long lockOwner = info.getLockOwnerId();
                if (lockOwner == -1L || lockOwner == thread.getId()) {
                    blocked = false;
                } else if (lockOwner != this.other.getId()) {
                    System.out.printf("WARNING - %s blocked on %s\n", thread, info.getLockName());
                }
            }
        }
        return blocked;
    }

    public boolean waitForThread() throws InterruptedException, TestTimeoutException {
        if (this.toWait.getState() == Thread.State.NEW) {
            throw new IllegalThreadStateException("Cannot wait for non-started thread.");
        }
        if (this.other.isAlive() && this.isBlocked(this.toWait)) {
            return false;
        }
        int tries = 0;
        while ((long)tries < this.numTries) {
            this.toWait.join(50L);
            if (!this.toWait.isAlive()) {
                return true;
            }
            Thread.State state = this.toWait.getState();
            if (this.isBlocked(this.toWait)) {
                return false;
            }
            ++tries;
        }
        throw new TestTimeoutException("Thread will not finish", this.toWait);
    }

    static {
        threadBean.setThreadContentionMonitoringEnabled(true);
    }
}

