/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.BaseTestWrapper;
import com.google.testing.threadtester.MethodCaller;
import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.ThreadedAfter;
import com.google.testing.threadtester.ThreadedBefore;
import com.google.testing.threadtester.ThreadedTest;
import java.lang.reflect.Method;
import java.util.List;

public class ThreadedTestWrapper
implements BaseTestWrapper {
    @Override
    public void runTests(Class<?> testClass, List<String> instrumentedClasses) {
        Method[] methods;
        Object testObject = MethodCaller.newInstance(testClass);
        Method beforeMethod = null;
        Method afterMethod = null;
        String name = testClass.getSimpleName();
        for (Method method : methods = testClass.getMethods()) {
            if (method.getAnnotation(ThreadedBefore.class) != null) {
                if (beforeMethod != null) {
                    throw new IllegalArgumentException("Method " + method + " and " + beforeMethod + " have the same annotation");
                }
                beforeMethod = method;
            }
            if (method.getAnnotation(ThreadedAfter.class) == null) continue;
            if (afterMethod != null) {
                throw new IllegalArgumentException("Method " + method + " and " + beforeMethod + " have the same annotation");
            }
            afterMethod = method;
        }
        boolean foundMatch = false;
        for (Method method : methods) {
            ThreadedTest annotation = method.getAnnotation(ThreadedTest.class);
            if (annotation == null) continue;
            foundMatch = true;
            Class<? extends Throwable> expectedThrown = annotation.expected();
            if (expectedThrown == ThreadedTest.NoException.class) {
                expectedThrown = null;
            }
            if (beforeMethod != null) {
                Options.debugPrint("\nInvoking \"before\" method %s.%s\n", name, beforeMethod.getName());
                MethodCaller.invoke(beforeMethod, testObject, new Object[0]);
            }
            Options.debugPrint("\nInvoking test method %s.%s\n", name, method.getName());
            MethodCaller.invokeAndThrow(method, testObject, expectedThrown, new Object[0]);
            if (afterMethod == null) continue;
            Options.debugPrint("\nInvoking \"after\" method %s.%s\n", name, afterMethod.getName());
            MethodCaller.invoke(afterMethod, testObject, new Object[0]);
        }
        if (!foundMatch) {
            throw new IllegalArgumentException("No @ThreadedTest annotations in " + testClass);
        }
    }
}

