/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester.utils;

import com.google.testing.threadtester.AbstractBreakpoint;
import com.google.testing.threadtester.ReusableBreakpoint;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class BlockingProxy<T>
extends AbstractBreakpoint
implements ReusableBreakpoint,
InvocationHandler {
    private T original;
    private T proxy;
    private String methodName;
    private Method targetMethod;
    private boolean before;

    public T getProxy() {
        return this.proxy;
    }

    private BlockingProxy(T original, String methodName, boolean before) {
        this.original = original;
        this.methodName = methodName;
        this.targetMethod = null;
        this.before = before;
    }

    private BlockingProxy(T original, Method method, boolean before) {
        this.original = original;
        this.methodName = null;
        this.targetMethod = method;
        this.before = before;
    }

    @Override
    public Object invoke(Object proxy, Method invoked, Object[] args) throws Throwable {
        boolean block = this.targetMethod != null ? this.targetMethod.equals(invoked) : this.methodName.equals(invoked.getName());
        if (block && this.before) {
            this.doBlock();
        }
        Object result = invoked.invoke(this.original, args);
        if (block && !this.before) {
            this.doBlock();
        }
        return result;
    }

    private void doBlock() {
        if (this.thread == null || this.thread.equals(Thread.currentThread())) {
            this.hitBreakpoint();
        }
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void setThread(Thread thread) {
        this.setThreadImpl(thread);
    }

    public static <T> BlockingProxy<T> create(Class<T> clss, T original, String methodName, boolean before) {
        BlockingProxy<T> blockingProxy = new BlockingProxy<T>(original, methodName, before);
        blockingProxy.proxy = Proxy.newProxyInstance(clss.getClassLoader(), new Class[]{clss}, blockingProxy);
        return blockingProxy;
    }

    public static <T> BlockingProxy<T> create(Class<T> clss, T original, Method method, boolean before) {
        BlockingProxy<T> blockingProxy = new BlockingProxy<T>(original, method, before);
        blockingProxy.proxy = Proxy.newProxyInstance(clss.getClassLoader(), new Class[]{clss}, blockingProxy);
        return blockingProxy;
    }
}

