/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.instrumentation;

import com.google.testing.instrumentation.Instrumenter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public final class InstrumentedClassLoader
extends ClassLoader {
    private static final int BUF_SIZE = 4096;
    private final Instrumenter instrumenter;
    private static final List<String> excludedClassPrefixes = Arrays.asList("java.", "javax.", "sun.", "net.sf.cglib", "junit.", "org.junit.", "org.objenesis.", "org.easymock.", "org.w3c.dom", "org.jdom");

    public InstrumentedClassLoader(Instrumenter instrumenter) {
        super(InstrumentedClassLoader.class.getClassLoader());
        if (instrumenter == null) {
            throw new IllegalArgumentException("instrumenter cannot be null");
        }
        this.instrumenter = instrumenter;
    }

    private boolean shouldLoad(String className) {
        for (String excluded : excludedClassPrefixes) {
            if (!className.startsWith(excluded)) continue;
            return false;
        }
        return true;
    }

    public Class<?> getExpectedClass(String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find " + e);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            if (this.shouldLoad(name)) {
                result = this.findClass(name);
            } else {
                return super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            String pkgname;
            int dotpos = className.lastIndexOf(46);
            if (dotpos != -1 && this.getPackage(pkgname = className.substring(0, dotpos)) == null) {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            String resourceName = className.replace('.', '/') + ".class";
            InputStream input = InstrumentedClassLoader.getSystemResourceAsStream(resourceName);
            byte[] classData = this.instrumenter.instrument(className, this.loadClassData(input));
            Class<?> result = this.defineClass(className, classData, 0, classData.length, null);
            return result;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Cannot load " + className, e);
        }
    }

    private byte[] loadClassData(InputStream input) throws IOException {
        int readCount;
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((readCount = input.read(buffer, 0, 4096)) >= 0) {
            output.write(buffer, 0, readCount);
        }
        return output.toByteArray();
    }
}

