/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.Breakpoint;
import com.google.testing.threadtester.BreakpointHandler;
import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.TestTimeoutException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractBreakpoint
implements Breakpoint {
    private static AtomicInteger atomicId = new AtomicInteger(1);
    private final int id = atomicId.getAndIncrement();
    private volatile BreakpointHandler handler;
    private volatile CountDownLatch stopLatch;
    private volatile CountDownLatch restartLatch;
    protected volatile boolean enabled;
    protected volatile int limit;
    protected volatile int numHits;
    protected volatile boolean blocked;
    protected volatile Thread thread;

    protected AbstractBreakpoint(Thread thread) {
        this();
        if (thread == null) {
            throw new IllegalArgumentException("thread cannot be null");
        }
        this.thread = thread;
    }

    protected AbstractBreakpoint() {
        this.initialize();
    }

    private final void initialize() {
        this.enabled = true;
        this.stopLatch = new CountDownLatch(1);
        this.restartLatch = new CountDownLatch(1);
        this.numHits = 0;
        this.limit = 1;
    }

    protected void reset() {
        if (this.stopLatch.getCount() == 0L && this.restartLatch.getCount() > 0L) {
            throw new IllegalStateException("Cannot reset until resume is called");
        }
        this.initialize();
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    protected void setThreadImpl(Thread newThread) {
        this.reset();
        this.thread = newThread;
    }

    @Override
    public void setHandler(BreakpointHandler handler) {
        this.handler = handler;
    }

    public int getHits() {
        return this.numHits;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count " + count);
        }
        if (this.blocked) {
            throw new IllegalStateException("Cannot set limit when breakpoint is already blocked");
        }
        this.limit = count;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void await() throws TestTimeoutException {
        Options.debugPrint("Breakpoint.await %s\n", this);
        try {
            if (!this.stopLatch.await(Options.timeout(), TimeUnit.MILLISECONDS)) {
                throw new TestTimeoutException("Did not reach " + this, this.getThread());
            }
        }
        catch (InterruptedException e) {
            throw new IllegalThreadStateException("Interrupted");
        }
    }

    @Override
    public void resume(Breakpoint nextBreak) throws TestTimeoutException {
        if (nextBreak == null) {
            throw new NullPointerException("nextBreak cannot be null");
        }
        this.doResume(nextBreak);
        nextBreak.await();
    }

    @Override
    public void resume() {
        this.doResume(null);
    }

    private void doResume(Breakpoint next) {
        Options.debugPrint("Breakpoint.resume %s\n", this);
        if (!this.blocked) {
            throw new IllegalStateException("Cannot resume when not blocked");
        }
        this.restartLatch.countDown();
    }

    protected final void finishWaiting() {
        this.stopLatch.countDown();
    }

    protected void hitBreakpoint() {
        Options.debugPrint("Breakpoint.at %s, enabled %s\n", this, this.enabled);
        if (!this.enabled) {
            return;
        }
        boolean handled = false;
        if (this.handler != null) {
            handled = this.handler.handleBreakpoint(this);
        }
        if (!handled) {
            this.blocked = true;
            this.stopLatch.countDown();
            try {
                this.restartLatch.await();
            }
            catch (InterruptedException e) {
                throw new IllegalThreadStateException("Interrupted");
            }
        }
    }

    protected int getId() {
        return this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.id + ")";
    }
}

