/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.BaseTestWrapper;
import com.google.testing.threadtester.CallChecker;
import com.google.testing.threadtester.CallLoggerFactory;
import com.google.testing.threadtester.InterleavedRunner;
import com.google.testing.threadtester.MainRunnable;
import com.google.testing.threadtester.MethodCaller;
import com.google.testing.threadtester.ObjectCreationListener;
import com.google.testing.threadtester.ObjectInstrumentationImpl;
import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.RunResult;
import com.google.testing.threadtester.SecondaryRunnableImpl;
import com.google.testing.threadtester.ThreadedAfter;
import com.google.testing.threadtester.ThreadedAfterAll;
import com.google.testing.threadtester.ThreadedBefore;
import com.google.testing.threadtester.ThreadedBeforeAll;
import com.google.testing.threadtester.ThreadedMain;
import com.google.testing.threadtester.ThreadedSecondary;
import com.google.testing.threadtester.ThreadedVerification;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnnotatedTestWrapper
implements BaseTestWrapper {
    private <T extends Annotation> T getUniqueAnnotation(Class<T> annotationClass, Method method, Annotation ... others) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Cannot apply " + annotation + " to static method");
            }
            for (Annotation other : others) {
                if (other == null) continue;
                throw new IllegalArgumentException("Cannot combine " + annotation + " with " + other + " on method " + method);
            }
        }
        return annotation;
    }

    private void addUniqueMethod(Map<String, Method> map, String name, Method method, Annotation annotation) {
        if (map.containsKey(name)) {
            throw new IllegalArgumentException("Cannot have multiple " + annotation + " annotations with name " + name);
        }
        map.put(name, method);
    }

    TestCases getTestCases(Class<?> testClass, List<Class<?>> instrumentedClasses) {
        Method[] methods;
        HashMap<String, Method> mainMethods = new HashMap<String, Method>();
        HashMap<String, Method> secondaryMethods = new HashMap<String, Method>();
        HashMap<String, Method> verifyMethods = new HashMap<String, Method>();
        Method beforeMethod = null;
        Method beforeAllMethod = null;
        Method afterMethod = null;
        Method afterAllMethod = null;
        Map<Method, Method> methodMap = new CallChecker().getCallers(testClass, instrumentedClasses);
        for (Method method : methods = testClass.getMethods()) {
            ThreadedAfterAll afterAll;
            ThreadedBeforeAll beforeAll;
            ThreadedAfter after;
            ThreadedBefore before;
            ThreadedVerification verification;
            ThreadedSecondary secondary;
            ThreadedMain main = this.getUniqueAnnotation(ThreadedMain.class, method, new Annotation[0]);
            if (main != null) {
                this.addUniqueMethod(mainMethods, main.name(), method, main);
            }
            if ((secondary = this.getUniqueAnnotation(ThreadedSecondary.class, method, main)) != null) {
                this.addUniqueMethod(secondaryMethods, secondary.name(), method, secondary);
            }
            if ((verification = this.getUniqueAnnotation(ThreadedVerification.class, method, main, secondary)) != null) {
                this.addUniqueMethod(verifyMethods, verification.name(), method, verification);
            }
            if ((before = this.getUniqueAnnotation(ThreadedBefore.class, method, main, secondary, verification)) != null) {
                if (beforeMethod != null) {
                    throw new IllegalArgumentException("Only one " + before + " annotation allowed");
                }
                beforeMethod = method;
            }
            if ((after = this.getUniqueAnnotation(ThreadedAfter.class, method, main, secondary, verification, before)) != null) {
                if (afterMethod != null) {
                    throw new IllegalArgumentException("Only one " + after + " annotation allowed");
                }
                afterMethod = method;
            }
            if ((beforeAll = method.getAnnotation(ThreadedBeforeAll.class)) != null) {
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalArgumentException("ThreadedBeforeAll only allowed on static methods");
                }
                beforeAllMethod = method;
            }
            if ((afterAll = method.getAnnotation(ThreadedAfterAll.class)) == null) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("ThreadedAfterAll only allowed on static methods");
            }
            afterAllMethod = method;
        }
        if (mainMethods.size() == 0) {
            throw new IllegalArgumentException("No methods tagged with @ThreadedMain");
        }
        if (beforeMethod == null) {
            throw new IllegalArgumentException("No method tagged with @ThreadedBefore");
        }
        TestCases testCases = new TestCases(mainMethods.size(), beforeAllMethod, afterAllMethod);
        Iterator i$ = mainMethods.keySet().iterator();
        while (i$.hasNext()) {
            String name = (String)i$.next();
            Method secondaryMethod = (Method)secondaryMethods.get(name);
            if (secondaryMethod == null) {
                throw new IllegalArgumentException("No secondary method for test \"" + name + "\"");
            }
            secondaryMethods.remove(name);
            Method targetMethod = methodMap.get(mainMethods.get(name));
            if (targetMethod == null) {
                throw new IllegalArgumentException("Method @ThreadedMain(\"" + name + "\") does not call a method in an instrumented class");
            }
            testCases.add(new TestCase(name, beforeMethod, (Method)mainMethods.get(name), secondaryMethod, (Method)verifyMethods.get(name), afterMethod, targetMethod));
        }
        if (secondaryMethods.size() > 0 && (i$ = secondaryMethods.keySet().iterator()).hasNext()) {
            String name = (String)i$.next();
            throw new IllegalArgumentException("Secondary method for test case \"" + name + "\" has no main method");
        }
        return testCases;
    }

    @Override
    public void runTests(Class<?> testClass, List<String> instrumentedClassNames) throws Exception {
        Object mainObject = null;
        ArrayList instrumentedClasses = new ArrayList(instrumentedClassNames.size());
        for (String name : instrumentedClassNames) {
            instrumentedClasses.add(Class.forName(name));
        }
        TestCases testCases = this.getTestCases(testClass, instrumentedClasses);
        if (testCases.beforeAllMethod != null) {
            MethodCaller.invoke(testCases.beforeAllMethod, null, new Object[0]);
        }
        this.runTestCases(testClass, testCases);
        if (testCases.afterAllMethod != null) {
            MethodCaller.invoke(testCases.afterAllMethod, null, new Object[0]);
        }
    }

    private void runTestCases(Class<?> testClass, List<TestCase> testCases) {
        Options.debugPrint("Running tests for class %s\n", testClass);
        for (TestCase testCase : testCases) {
            Options.debugPrint("  test case %s has %s, %s, %s\n", testCase.name, testCase.main.getName(), testCase.secondary.getName(), testCase.verification == null ? "null" : testCase.verification.getName());
            MainTestCaseRunner main = new MainTestCaseRunner(testClass, testCase);
            SecondaryTestCaseRunner secondary = new SecondaryTestCaseRunner();
            RunResult result = InterleavedRunner.interleave(main, secondary);
            result.throwExceptionsIfAny();
        }
    }

    private class SecondaryTestCaseRunner
    extends SecondaryRunnableImpl<Object, MainTestCaseRunner> {
        TestCase testCase;
        Object testRunner;

        private SecondaryTestCaseRunner() {
        }

        @Override
        public void initialize(MainTestCaseRunner main) {
            this.testCase = main.testCase;
            this.testRunner = main.testRunner;
        }

        @Override
        public void run() {
            MethodCaller.invoke(this.testCase.secondary, this.testRunner, new Object[0]);
        }
    }

    private class MainTestCaseRunner
    implements MainRunnable<Object>,
    ObjectCreationListener {
        private final TestCase testCase;
        private final Class<?> testRunnerClass;
        private volatile Object testRunner;
        volatile Object targetObject;
        volatile Thread executionThread;

        MainTestCaseRunner(Class<?> testClass, TestCase testCase) {
            this.testRunnerClass = testClass;
            this.testCase = testCase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialize() {
            this.testRunner = MethodCaller.newInstance(this.testRunnerClass);
            CallLoggerFactory factory = CallLoggerFactory.getFactory();
            try {
                this.executionThread = Thread.currentThread();
                this.targetObject = null;
                factory.addObjectCreationListener(this);
                MethodCaller.invoke(this.testCase.before, this.testRunner, new Object[0]);
            }
            finally {
                factory.removeObjectCreationListener(this);
            }
            if (this.targetObject == null) {
                throw new IllegalStateException("Neither @ThreadedBefore nor @ThreadedPrepare created a new test object of class " + this.getClassUnderTest().getName());
            }
        }

        @Override
        public void newObject(ObjectInstrumentationImpl<?> newObject, Thread thread) {
            if (thread.equals(this.executionThread) && this.getClassUnderTest().isAssignableFrom(newObject.getUnderlyingObject().getClass())) {
                if (this.targetObject == null) {
                    this.targetObject = newObject.getUnderlyingObject();
                } else {
                    throw new IllegalStateException("Creating second instance of " + this.targetObject.getClass().getName() + ". Only one instance can be created");
                }
            }
        }

        @Override
        public Object getMainObject() {
            return this.targetObject;
        }

        @Override
        public Class<Object> getClassUnderTest() {
            return this.getMethod().getDeclaringClass();
        }

        @Override
        public Method getMethod() {
            return this.testCase.target;
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public void terminate() {
            if (this.testCase.verification != null) {
                MethodCaller.invoke(this.testCase.verification, this.testRunner, new Object[0]);
            }
            if (this.testCase.after != null) {
                MethodCaller.invoke(this.testCase.after, this.testRunner, new Object[0]);
            }
        }

        @Override
        public void run() {
            MethodCaller.invoke(this.testCase.main, this.testRunner, new Object[0]);
        }
    }

    class TestCases
    extends ArrayList<TestCase> {
        final Method beforeAllMethod;
        final Method afterAllMethod;

        TestCases(int size, Method beforeAllMethod, Method afterAllMethod) {
            super(size);
            this.beforeAllMethod = beforeAllMethod;
            this.afterAllMethod = afterAllMethod;
        }
    }

    class TestCase {
        final String name;
        final Method before;
        final Method main;
        final Method secondary;
        final Method verification;
        final Method after;
        final Method target;

        TestCase(String name, Method before, Method main, Method secondary, Method verification, Method after, Method target) {
            this.name = name;
            this.before = before;
            this.main = main;
            this.secondary = secondary;
            this.verification = verification;
            this.after = after;
            this.target = target;
        }
    }
}

