/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.MethodCaller;
import com.google.testing.threadtester.TestInstrumenter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

class CallChecker {
    CallChecker() {
    }

    Map<Method, Method> getCallers(Class<?> caller, Class<?> ... targets) {
        ArrayList target_list = new ArrayList();
        Collections.addAll(target_list, targets);
        return this.getCallers(caller, target_list);
    }

    Map<Method, Method> getCallers(Class<?> caller, List<Class<?>> targets) {
        HashSet<String> targetNames = new HashSet<String>();
        for (Class<?> target : targets) {
            targetNames.add(target.getName());
        }
        HashMap<Method, Method> result = new HashMap<Method, Method>();
        HashSet<Method> methodsToProcess = new HashSet<Method>();
        for (Method m : caller.getMethods()) {
            methodsToProcess.add(m);
        }
        this.getCallers(caller, targetNames, methodsToProcess, result);
        return result;
    }

    private void getCallers(final Class<?> caller, final Set<String> targetNames, final Set<Method> methodsToProcess, final Map<Method, Method> result) {
        CtClass cl = null;
        try {
            cl = ClassPool.getDefault().get(caller.getName());
            cl.instrument(new ExprEditor(){

                public void edit(MethodCall called) {
                    try {
                        Method callingMethod;
                        if (targetNames.contains(called.getClassName()) && (callingMethod = CallChecker.this.getMethod(caller.getName(), called.where())) != null && !result.containsKey(callingMethod) && methodsToProcess.contains(callingMethod)) {
                            Method calledMethod = CallChecker.this.getMethod(called.getClassName(), (CtBehavior)called.getMethod());
                            if (calledMethod == null) {
                                String targetName;
                                Iterator i$ = targetNames.iterator();
                                while (i$.hasNext() && ((targetName = (String)i$.next()).equals(called.getClassName()) || (calledMethod = CallChecker.this.getMethod(targetName, (CtBehavior)called.getMethod())) == null)) {
                                }
                            }
                            result.put(callingMethod, calledMethod);
                        }
                    }
                    catch (NotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (cl != null) {
                cl.detach();
            }
        }
        Class<?> superclass = caller.getSuperclass();
        if (superclass != Object.class) {
            this.getCallers(superclass, targetNames, methodsToProcess, result);
        }
    }

    private Method getMethod(String className, CtBehavior behavior) {
        Class<?> definingClass = MethodCaller.getClass(className);
        try {
            CtClass[] ctParams = behavior.getParameterTypes();
            Class[] params = new Class[ctParams.length];
            for (int i = 0; i < ctParams.length; ++i) {
                params[i] = TestInstrumenter.getClass(ctParams[i]);
            }
            return definingClass.getDeclaredMethod(behavior.getName(), params);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

