/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.InstrumentedCodePosition;
import java.lang.reflect.Method;

abstract class CallCodePosition
extends InstrumentedCodePosition {
    protected final Method method;
    protected final Method calledMethod;
    protected final String calledMethodName;

    CallCodePosition(Method method, String calledMethodName) {
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        if (calledMethodName == null) {
            throw new IllegalArgumentException("calledMethodName cannot be null");
        }
        this.method = method;
        this.calledMethodName = calledMethodName;
        this.calledMethod = null;
    }

    CallCodePosition(Method method, Method calledMethod) {
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        if (calledMethod == null) {
            throw new IllegalArgumentException("calledMethod cannot be null");
        }
        this.method = method;
        this.calledMethod = calledMethod;
        this.calledMethodName = null;
    }

    @Override
    boolean matches(CodePosition p) {
        if (p != null && this.getClass().isAssignableFrom(p.getClass())) {
            CallCodePosition position = (CallCodePosition)p;
            if (this.method.equals(position.method)) {
                if (this.calledMethod != null) {
                    return this.calledMethod.equals(position.calledMethod) || this.calledMethod.getName().equals(position.calledMethodName);
                }
                return this.calledMethodName.equals(position.calledMethodName) || position.calledMethod != null && this.calledMethodName.equals(position.calledMethod.getName());
            }
        }
        return false;
    }

    protected String getCalledMethodName() {
        return this.calledMethodName != null ? this.calledMethodName : this.calledMethod.getName();
    }
}

