/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.CallLogger;
import com.google.testing.threadtester.ClassInstrumentation;
import com.google.testing.threadtester.ClassInstrumentationImpl;
import com.google.testing.threadtester.ObjectCreationListener;
import com.google.testing.threadtester.ObjectInstrumentationImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class CallLoggerFactory {
    private static CallLoggerFactory factory;
    private IdentityHashMap<Object, ObjectInstrumentationImpl<?>> instrumentedMap = new IdentityHashMap();
    private Map<Class<?>, ClassInstrumentationImpl> classMap = new HashMap();
    private Collection<ObjectCreationListener> listeners = new CopyOnWriteArrayList<ObjectCreationListener>();

    private CallLoggerFactory() {
    }

    public static synchronized CallLoggerFactory getFactory() {
        if (factory == null) {
            factory = new CallLoggerFactory();
        }
        return factory;
    }

    synchronized void addObjectCreationListener(ObjectCreationListener listener) {
        this.listeners.add(listener);
    }

    synchronized void removeObjectCreationListener(ObjectCreationListener listener) {
        this.listeners.remove(listener);
    }

    ClassInstrumentation getClassInstrumentation(Class<?> clss) {
        ClassInstrumentationImpl result = this.getClassInstrumentationTolerant(clss);
        if (result == null) {
            throw new IllegalArgumentException("Class " + clss.getSimpleName() + " is not instrumented");
        }
        return result;
    }

    private synchronized ClassInstrumentationImpl getClassInstrumentationTolerant(Class<?> clss) {
        ClassInstrumentationImpl result = this.classMap.get(clss);
        if (result == null) {
            try {
                ClassInstrumentationImpl instrumentedSuperclass = null;
                Class<?> superclass = clss.getSuperclass();
                if (superclass != null) {
                    instrumentedSuperclass = this.getClassInstrumentationTolerant(superclass);
                }
                Method method = clss.getMethod("__getInstrumentation", new Class[0]);
                method.setAccessible(true);
                List methods = (List)method.invoke(null, new Object[0]);
                result = new ClassInstrumentationImpl(clss, instrumentedSuperclass, methods);
                this.classMap.put(clss, result);
            }
            catch (NoSuchMethodException nsme) {
                return null;
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("Cannot call instrumented method in " + clss, iae);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalArgumentException("Cannot call instrumented method in " + clss, ite);
            }
        }
        return result;
    }

    Map<String, List<Integer>> getLineNumbers(Object instrumented) {
        try {
            Method method = instrumented.getClass().getMethod("__getInstrumentation", new Class[0]);
            Map result = (Map)method.invoke(null, new Object[0]);
            if (result == null) {
                throw new IllegalArgumentException("No line number data for " + instrumented);
            }
            return result;
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("No instrumented method in " + instrumented);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Cannot call instrumented method in " + instrumented);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("Cannot call instrumented method in " + instrumented);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstrumentationImpl getObjectInstrumentation(Object obj) {
        ObjectInstrumentationImpl<?> result;
        IdentityHashMap<Object, ObjectInstrumentationImpl<?>> identityHashMap = this.instrumentedMap;
        synchronized (identityHashMap) {
            result = this.instrumentedMap.get(obj);
        }
        if (result == null) {
            throw new IllegalArgumentException("No instrumented object for " + obj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallLogger getLogger(Object obj) {
        ObjectInstrumentationImpl<Object> instrumented;
        boolean created = false;
        IdentityHashMap<Object, ObjectInstrumentationImpl<?>> identityHashMap = this.instrumentedMap;
        synchronized (identityHashMap) {
            instrumented = this.instrumentedMap.get(obj);
            if (instrumented == null) {
                instrumented = new ObjectInstrumentationImpl<Object>(obj);
                this.instrumentedMap.put(obj, instrumented);
                created = true;
            }
        }
        if (created) {
            for (ObjectCreationListener listener : this.listeners) {
                listener.newObject(instrumented, Thread.currentThread());
            }
        }
        return instrumented;
    }

    public static CallLogger createLoggerForNewObject(Object obj) {
        return CallLoggerFactory.getFactory().getLogger(obj);
    }
}

