/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.AfterCallCodePosition;
import com.google.testing.threadtester.BeforeCallCodePosition;
import com.google.testing.threadtester.ClassInstrumentation;
import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.MethodEndCodePosition;
import com.google.testing.threadtester.MethodInstrumentation;
import com.google.testing.threadtester.MethodInstrumentationImpl;
import com.google.testing.threadtester.MethodStartCodePosition;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassInstrumentationImpl
implements ClassInstrumentation {
    private final Class<?> instrumentedClass;
    private final ClassInstrumentationImpl superclass;
    private Map<Method, MethodInstrumentation> methodMap = new HashMap<Method, MethodInstrumentation>();
    private Map<String, Method> namedMethods = new HashMap<String, Method>();
    private Set<String> overloadedMethods = new HashSet<String>();

    ClassInstrumentationImpl(Class<?> clss, ClassInstrumentationImpl superclass, List<MethodInstrumentationImpl> instrumentedMethods) {
        if (clss == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        this.instrumentedClass = clss;
        this.superclass = superclass;
        for (MethodInstrumentationImpl instrumentedMethod : instrumentedMethods) {
            String name = instrumentedMethod.getName();
            if (name.equals("<init>")) continue;
            Method method = instrumentedMethod.getUnderlyingMethod();
            this.methodMap.put(method, instrumentedMethod);
            if (this.namedMethods.containsKey(name)) {
                this.overloadedMethods.add(name);
                continue;
            }
            this.namedMethods.put(name, method);
        }
    }

    @Override
    public Collection<MethodInstrumentation> getMethods() {
        return Collections.unmodifiableCollection(this.methodMap.values());
    }

    @Override
    public MethodInstrumentation getMethod(String methodName) {
        return this.getMethod(this.getMethodFromName(methodName));
    }

    @Override
    public MethodInstrumentation getMethod(Method method) {
        MethodInstrumentation result = this.methodMap.get(method);
        if (result == null) {
            if (this.superclass != null) {
                return this.superclass.getMethod(method);
            }
            throw new IllegalArgumentException("Cannot find method " + method);
        }
        return result;
    }

    private Method getMethodFromName(String name) {
        if (this.overloadedMethods.contains(name)) {
            throw new IllegalArgumentException("name " + name + " is not unique");
        }
        Method result = this.namedMethods.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Cannot find " + name);
        }
        return result;
    }

    private Method checkMethod(Method method) {
        if (this.methodMap.containsKey(method)) {
            return method;
        }
        if (this.superclass != null) {
            return this.superclass.checkMethod(method);
        }
        throw new IllegalArgumentException("Cannot find method " + method);
    }

    @Override
    public CodePosition atMethodStart(Method method) {
        return new MethodStartCodePosition(this.checkMethod(method));
    }

    @Override
    public CodePosition atMethodEnd(Method method) {
        return new MethodEndCodePosition(this.checkMethod(method));
    }

    @Override
    public CodePosition atMethodStart(String methodName) {
        return new MethodStartCodePosition(this.getMethodFromName(methodName));
    }

    @Override
    public CodePosition atMethodEnd(String methodName) {
        return new MethodEndCodePosition(this.getMethodFromName(methodName));
    }

    @Override
    public CodePosition beforeCall(String methodName, String calledMethodName) {
        return new BeforeCallCodePosition(this.getMethodFromName(methodName), calledMethodName);
    }

    @Override
    public CodePosition beforeCall(Method method, Method calledMethod) {
        return new BeforeCallCodePosition(this.checkMethod(method), calledMethod);
    }

    @Override
    public CodePosition afterCall(String methodName, String calledMethodName) {
        return new AfterCallCodePosition(this.getMethodFromName(methodName), calledMethodName);
    }

    @Override
    public CodePosition afterCall(Method method, Method calledMethod) {
        return new AfterCallCodePosition(this.checkMethod(method), calledMethod);
    }

    @Override
    public CodePosition beforeSync(String methodName, Object syncTarget) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public CodePosition afterSync(String methodName, Object syncTarget) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public CodePosition beforeSync(Method method, Object syncTarget) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public CodePosition afterSync(Method method, Object syncTarget) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return "Instrumented Class for " + this.instrumentedClass.getName();
    }
}

