/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.CallLoggerFactory;
import com.google.testing.threadtester.ClassInstrumentation;
import com.google.testing.threadtester.ObjectInstrumentation;
import com.google.testing.threadtester.ObjectInstrumentationImpl;

public class Instrumentation<T> {
    private Instrumentation() {
    }

    public static <T> ObjectInstrumentation<T> getObjectInstrumentation(T underlyingObject) {
        return ObjectInstrumentationImpl.getObject(underlyingObject);
    }

    public static <T> ClassInstrumentation getClassInstrumentation(Class<T> clss) {
        return CallLoggerFactory.getFactory().getClassInstrumentation(clss);
    }

    public static <T> ClassInstrumentation getNamedClassInstrumentation(String classname) {
        try {
            Class<?> clss = Class.forName(classname);
            return Instrumentation.getClassInstrumentation(clss);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find class " + classname);
        }
    }

    public static <T> ClassInstrumentation getClassInstrumentationForObject(T underlyingObject) {
        return Instrumentation.getClassInstrumentation(underlyingObject.getClass());
    }
}

