/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.Breakpoint;
import com.google.testing.threadtester.CallLoggerFactory;
import com.google.testing.threadtester.ClassInstrumentation;
import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.MainRunnable;
import com.google.testing.threadtester.MainRunnableImpl;
import com.google.testing.threadtester.MethodInstrumentation;
import com.google.testing.threadtester.ObjectInstrumentationImpl;
import com.google.testing.threadtester.ReusableBreakpoint;
import com.google.testing.threadtester.RunResult;
import com.google.testing.threadtester.SecondaryRunnable;
import com.google.testing.threadtester.SecondaryRunnableImpl;
import com.google.testing.threadtester.SteppedRunResult;
import com.google.testing.threadtester.TestThread;
import com.google.testing.threadtester.TestTimeoutException;
import com.google.testing.threadtester.ThreadMonitor;
import java.util.ArrayList;
import java.util.List;

public class InterleavedRunner {
    private InterleavedRunner() {
    }

    public static <M extends MainRunnable<T>, T> RunResult interleave(M main, SecondaryRunnable<T, M> secondary) {
        return InterleavedRunner.doInterleave(main, secondary, null, 0);
    }

    public static <M extends MainRunnable<T>, T> RunResult interleaveAfter(M main, SecondaryRunnable<T, M> secondary, CodePosition position, int posCount) {
        return InterleavedRunner.doInterleave(main, secondary, position, posCount);
    }

    private static MethodInstrumentation getMainMethod(ClassInstrumentation clss, MainRunnable<?> main) {
        try {
            if (main.getMethod() != null) {
                return clss.getMethod(main.getMethod());
            }
            if (main.getMethodName() != null) {
                return clss.getMethod(main.getMethodName());
            }
            throw new IllegalArgumentException("No main method defined");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid main method defined", e);
        }
    }

    private static <M extends MainRunnable<T>, T> RunResult doInterleave(M main, SecondaryRunnable<T, M> secondary, CodePosition startPosition, int posCount) {
        CallLoggerFactory logger = CallLoggerFactory.getFactory();
        ClassInstrumentation instrClss = logger.getClassInstrumentation(main.getClassUnderTest());
        MethodInstrumentation method = InterleavedRunner.getMainMethod(instrClss, main);
        int numLines = method.getNumLines();
        for (int i = 0; i < numLines; ++i) {
            Throwable mainException = null;
            Throwable secondaryException = null;
            try {
                main.initialize();
            }
            catch (Throwable e) {
                return new RunResult(e, null);
            }
            try {
                secondary.initialize(main);
            }
            catch (Throwable e) {
                return new RunResult(null, e);
            }
            ObjectInstrumentationImpl<T> instr = ObjectInstrumentationImpl.getObject(main.getMainObject());
            SteppedRunResult result = instr.interleave(main, method, i, secondary, secondary.canBlock(), startPosition, posCount);
            if (result.hadException()) {
                return result;
            }
            try {
                main.terminate();
            }
            catch (Throwable e) {
                mainException = e;
            }
            try {
                secondary.terminate();
            }
            catch (Throwable e) {
                secondaryException = e;
            }
            if (mainException == null && secondaryException == null) continue;
            return new RunResult(mainException, secondaryException);
        }
        return new RunResult();
    }

    public static <M extends MainRunnable<T>, T> RunResult interleave(M main, SecondaryRunnable<T, M> secondary, List<CodePosition> positions) {
        ArrayList<WrappedBreakpoint> wrappers = new ArrayList<WrappedBreakpoint>(positions.size());
        for (CodePosition position : positions) {
            wrappers.add(new PositionWrapper(position));
        }
        return InterleavedRunner.interleaveAtWrappedBreakpoints(main, secondary, wrappers);
    }

    public static RunResult interleaveAtBreakpoint(final Runnable mainRunnable, final Runnable secondaryRunnable, ReusableBreakpoint breakpoint) {
        MainRunnableImpl<Object> main = new MainRunnableImpl<Object>(){

            @Override
            public void run() {
                mainRunnable.run();
            }
        };
        SecondaryRunnableImpl<Object, MainRunnableImpl<Object>> secondary = new SecondaryRunnableImpl<Object, MainRunnableImpl<Object>>(){

            @Override
            public void run() {
                secondaryRunnable.run();
            }
        };
        ArrayList<ReusableBreakpoint> breakpoints = new ArrayList<ReusableBreakpoint>();
        breakpoints.add(breakpoint);
        return InterleavedRunner.interleaveAtReusableBreakpoints(main, secondary, breakpoints);
    }

    public static <M extends MainRunnable<T>, T> RunResult interleaveAtBreakpoint(M main, SecondaryRunnable<T, M> secondary, ReusableBreakpoint breakpoint) {
        ArrayList<ReusableBreakpoint> breakpoints = new ArrayList<ReusableBreakpoint>();
        breakpoints.add(breakpoint);
        return InterleavedRunner.interleaveAtReusableBreakpoints(main, secondary, breakpoints);
    }

    public static <M extends MainRunnable<T>, T> RunResult interleaveAtReusableBreakpoints(M main, SecondaryRunnable<T, M> secondary, List<ReusableBreakpoint> breakpoints) {
        ArrayList<WrappedBreakpoint> wrappers = new ArrayList<WrappedBreakpoint>(breakpoints.size());
        for (ReusableBreakpoint breakpoint : breakpoints) {
            wrappers.add(new ReusableWrapper(breakpoint));
        }
        return InterleavedRunner.interleaveAtWrappedBreakpoints(main, secondary, wrappers);
    }

    private static <M extends MainRunnable<T>, T> RunResult interleaveAtWrappedBreakpoints(M main, SecondaryRunnable<T, M> secondary, List<WrappedBreakpoint> wrappers) {
        try {
            for (int i = 0; i < wrappers.size(); ++i) {
                boolean secondFinished;
                InterleavedRunner.disableWrappers(wrappers, i);
                WrappedBreakpoint wrapper = wrappers.get(i);
                Exception mainException = null;
                Exception secondaryException = null;
                try {
                    main.initialize();
                }
                catch (Throwable e) {
                    return new RunResult(e, null);
                }
                try {
                    secondary.initialize(main);
                }
                catch (Throwable e) {
                    return new RunResult(null, e);
                }
                TestThread mainThread = new TestThread(main, "Main Test Thread");
                TestThread secondThread = new TestThread(secondary, "Second Test Thread");
                Breakpoint breakpoint = wrapper.reset(main, mainThread);
                mainThread.start();
                try {
                    breakpoint.await();
                }
                catch (TestTimeoutException e) {
                    return new RunResult(e, null);
                }
                secondThread.start();
                try {
                    secondFinished = new ThreadMonitor(secondThread, mainThread).waitForThread();
                }
                catch (InterruptedException e) {
                    return new RunResult(null, e);
                }
                catch (TestTimeoutException e) {
                    return new RunResult(null, e);
                }
                if (!secondFinished && !secondary.canBlock()) {
                    return new RunResult(null, new IllegalThreadStateException("Second thread blocked at " + breakpoint));
                }
                breakpoint.resume();
                try {
                    mainThread.finish();
                }
                catch (IllegalThreadStateException e) {
                    return new RunResult(e, null);
                }
                catch (TestTimeoutException e) {
                    return new RunResult(e, null);
                }
                if (!secondFinished) {
                    try {
                        secondThread.finish();
                    }
                    catch (IllegalThreadStateException e) {
                        return new RunResult(null, e);
                    }
                    catch (TestTimeoutException e) {
                        return new RunResult(null, e);
                    }
                }
                if (mainThread.getException() != null || secondThread.getException() != null) {
                    return new RunResult(mainThread.getException(), secondThread.getException());
                }
                try {
                    main.terminate();
                }
                catch (Throwable e) {
                    mainException = new Exception("Error at breakpoint " + i, e);
                }
                try {
                    secondary.terminate();
                }
                catch (Throwable e) {
                    secondaryException = new Exception("Error at breakpoint " + i, e);
                }
                if (mainException == null && secondaryException == null) continue;
                return new RunResult(mainException, secondaryException);
            }
            return new RunResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Runner interrupted", e);
        }
    }

    private static void disableWrappers(List<WrappedBreakpoint> wrappers, int notDisabled) {
        for (int i = 0; i < wrappers.size(); ++i) {
            WrappedBreakpoint wrapper = wrappers.get(i);
            if (i == notDisabled) {
                wrapper.enable();
                continue;
            }
            wrapper.disable();
        }
    }

    private static class PositionWrapper
    extends WrappedBreakpoint {
        private CodePosition position;

        PositionWrapper(CodePosition position) {
            this.position = position;
        }

        @Override
        public Breakpoint reset(MainRunnable<?> main, Thread t) {
            ObjectInstrumentationImpl<?> instr = ObjectInstrumentationImpl.getObject(main.getMainObject());
            return instr.createBreakpoint(this.position, t);
        }
    }

    private static class ReusableWrapper
    extends WrappedBreakpoint {
        private ReusableBreakpoint breakpoint;

        ReusableWrapper(ReusableBreakpoint breakpoint) {
            this.breakpoint = breakpoint;
        }

        @Override
        public Breakpoint reset(MainRunnable<?> main, Thread t) {
            this.breakpoint.setThread(t);
            return this.breakpoint;
        }

        @Override
        public void enable() {
            this.breakpoint.enable();
        }

        @Override
        public void disable() {
            this.breakpoint.disable();
        }
    }

    private static abstract class WrappedBreakpoint {
        private WrappedBreakpoint() {
        }

        abstract Breakpoint reset(MainRunnable<?> var1, Thread var2);

        void disable() {
        }

        void enable() {
        }
    }
}

