/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.Options;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class MethodCaller {
    private MethodCaller() {
    }

    static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            Options.debugPrintStackTrace(e);
            throw new RuntimeException(e);
        }
    }

    static <T> T newInstance(Class<T> clss) {
        try {
            return clss.newInstance();
        }
        catch (IllegalAccessException e) {
            Options.debugPrintStackTrace(e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            Options.debugPrintStackTrace(e);
            throw new RuntimeException(e);
        }
    }

    static Method getDeclaredMethod(Class<?> clss, String name, Class<?> ... args) {
        try {
            return clss.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            Options.debugPrintStackTrace(e);
            throw new RuntimeException(e);
        }
    }

    static Object invoke(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException t) {
            Options.debugPrintStackTrace(t);
            throw new RuntimeException(t);
        }
        catch (IllegalAccessException e) {
            Options.debugPrintStackTrace(e);
            throw new RuntimeException(e);
        }
    }

    static Object invokeAndThrow(Method method, Object target, Class<? extends Throwable> expectedException, Object ... args) {
        boolean caught = false;
        Object result = null;
        try {
            result = method.invoke(target, args);
        }
        catch (InvocationTargetException t) {
            if (expectedException == null) {
                Options.debugPrintStackTrace(t);
                throw new RuntimeException(t);
            }
            if (!expectedException.isAssignableFrom(t.getCause().getClass())) {
                Options.debugPrintStackTrace(t);
                throw new RuntimeException("Caught " + t + ", not " + expectedException, t);
            }
            caught = true;
        }
        catch (IllegalAccessException e) {
            Options.debugPrintStackTrace(e);
            throw new RuntimeException(e);
        }
        if (!caught && expectedException != null) {
            throw new RuntimeException("Failed to catch " + expectedException);
        }
        return result;
    }
}

