/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

public class RunResult {
    private final Throwable mainException;
    private final Throwable secondaryException;

    public RunResult() {
        this(null, null);
    }

    public RunResult(Throwable main, Throwable secondary) {
        this.mainException = main;
        this.secondaryException = secondary;
    }

    public boolean hadException() {
        return this.mainException != null || this.secondaryException != null;
    }

    public void throwExceptionsIfAny() throws RuntimeException {
        if (this.mainException != null) {
            this.propagate(this.mainException);
        }
        if (this.secondaryException != null) {
            this.propagate(this.secondaryException);
        }
    }

    private void propagate(Throwable exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        throw new RuntimeException(exception);
    }

    public Throwable getMainException() {
        return this.mainException;
    }

    public Throwable getSecondaryException() {
        return this.secondaryException;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " main=" + this.mainException + ", second=" + this.secondaryException;
    }
}

