/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.AnyPositionBreakpoint;
import com.google.testing.threadtester.Breakpoint;
import com.google.testing.threadtester.BreakpointHandler;
import com.google.testing.threadtester.CodePosition;
import com.google.testing.threadtester.MethodRecorder;
import com.google.testing.threadtester.ObjectInstrumentation;
import com.google.testing.threadtester.ObjectInstrumentationImpl;
import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.ScriptedTask;
import com.google.testing.threadtester.Scripter;
import com.google.testing.threadtester.Stepper;
import com.google.testing.threadtester.TestThread;
import com.google.testing.threadtester.TestTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class Script<T> {
    private final T mainObject;
    private final MethodRecorder<T> recorder;
    private List<ScriptedTask<T>> tasks = new ArrayList<ScriptedTask<T>>();
    private List<ScriptTarget<T>> futureTargets = new ArrayList<ScriptTarget<T>>();
    private volatile Scripter<T> scripter = null;
    private volatile TestThread thread;
    private List<Breakpoint> breakPoints;
    private volatile int breakPointIndex;
    private volatile CountDownLatch blockingLatch = new CountDownLatch(1);
    private volatile Stepper stepper;

    public Script(T object) {
        this.mainObject = object;
        this.recorder = new MethodRecorder<T>(object);
    }

    public Script(Script<T> other) {
        this(other.mainObject);
    }

    public T object() {
        return this.recorder.getControl();
    }

    public <T> T createTarget(Class<T> clss) {
        return this.recorder.createTarget(clss);
    }

    public void addTask(ScriptedTask<T> task) {
        if (this.running()) {
            throw new IllegalStateException("Cannot add more tasks when running");
        }
        this.tasks.add(task);
    }

    void prepare(Scripter<T> theScripter, TestThread theThread) {
        this.scripter = theScripter;
        ObjectInstrumentation<T> instrumented = this.getInstrumentedObject();
        this.breakPoints = new ArrayList<Breakpoint>(this.futureTargets.size());
        for (ScriptTarget<T> target : this.futureTargets) {
            Breakpoint breakPoint = instrumented.createBreakpoint(target.codePosition, theThread);
            breakPoint.setHandler(new ReleasingHandler(target.script));
            this.breakPoints.add(breakPoint);
        }
        this.thread = theThread;
    }

    private boolean running() {
        return this.thread != null;
    }

    void runTasks() throws Exception {
        Options.debugPrint("Starting %s\n", this);
        this.block();
        try {
            for (ScriptedTask<T> task : this.tasks) {
                Options.debugPrint("%s starting task %s\n", this, task);
                task.setOwner(this);
                task.execute();
                Options.debugPrint("%s finished task %s\n", this, task);
            }
        }
        catch (Exception e) {
            try {
                Options.debugPrintStackTrace(e);
                throw e;
            }
            catch (Throwable throwable) {
                Options.debugPrint("Finished %s\n", this);
                this.scripter.onFinished(this);
                throw throwable;
            }
        }
        Options.debugPrint("Finished %s\n", this);
        this.scripter.onFinished(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTo(Script<T> other) {
        if (this == other) {
            throw new IllegalArgumentException("Cannot release control to the same script");
        }
        if (!this.running()) {
            this.futureTargets.add(new ScriptTarget<T>(this.recorder.position(), other));
        } else {
            CodePosition cp = this.recorder.getPositionIfAny();
            if (cp == null) {
                this.doRelease(other);
            } else {
                Breakpoint breakPoint = this.getInstrumentedObject().createBreakpoint(cp, this.thread);
                breakPoint.setHandler(new ReleasingHandler(other));
                List<Breakpoint> list = this.breakPoints;
                synchronized (list) {
                    this.breakPoints.add(breakPoint);
                }
            }
        }
    }

    private void doRelease(Script<T> other) {
        if (this.thread != Thread.currentThread()) {
            throw new IllegalStateException("Can only release from the script's own thread");
        }
        this.blockingLatch = new CountDownLatch(1);
        this.scripter.release(this, other);
        this.block();
    }

    private ObjectInstrumentation<T> getInstrumentedObject() {
        return this.recorder.getInstrumentedObject();
    }

    TestThread getThread() {
        return this.thread;
    }

    private void block() {
        try {
            this.blockingLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    Stepper startStepping() throws TestTimeoutException {
        AnyPositionBreakpoint breakpoint = new AnyPositionBreakpoint(this.getThread());
        ObjectInstrumentationImpl instrumented = (ObjectInstrumentationImpl)this.getInstrumentedObject();
        instrumented.registerBreakpoint(breakpoint);
        this.resume();
        breakpoint.await();
        this.stepper = instrumented.step(breakpoint);
        return this.stepper;
    }

    boolean canStep() {
        return this.stepper != null && this.stepper.hasNext();
    }

    void step() throws TestTimeoutException {
        this.stepper.step();
    }

    void finishStepping() throws TestTimeoutException {
        if (this.stepper != null) {
            this.stepper.resume();
            this.stepper = null;
        }
    }

    void resume() {
        this.blockingLatch.countDown();
    }

    public String toString() {
        if (this.thread == null) {
            return "Script " + this.mainObject.getClass().getName() + " (not started)";
        }
        return this.thread.getName() + " - scripting " + this.mainObject.getClass().getName();
    }

    public Script<T> afterCalling(Object result) {
        this.recorder.afterCalling(result);
        return this;
    }

    public Script<T> afterCallingLastMethod() {
        this.recorder.afterCallingLastMethod();
        return this;
    }

    public Script<T> atEndOf(Object result) {
        this.recorder.atEndOf(result);
        return this;
    }

    public Script<T> atEndOfLastMethod() {
        this.recorder.atEndOfLastMethod();
        return this;
    }

    public Script<T> atStartOf(Object result) {
        this.recorder.atStartOf(result);
        return this;
    }

    public Script<T> atStartOfLastMethod() {
        this.recorder.atStartOfLastMethod();
        return this;
    }

    public Script<T> beforeCalling(Object result) {
        this.recorder.beforeCalling(result);
        return this;
    }

    public Script<T> beforeCallingLastMethod() {
        this.recorder.beforeCallingLastMethod();
        return this;
    }

    public Script<T> inLastMethod() {
        this.recorder.inLastMethod();
        return this;
    }

    public Script<T> in(Object result) {
        this.recorder.in(result);
        return this;
    }

    private class ReleasingHandler
    implements BreakpointHandler {
        private Script<T> other;

        ReleasingHandler(Script<T> script2) {
            this.other = script2;
        }

        @Override
        public boolean handleBreakpoint(Breakpoint breakPoint) {
            Script.this.doRelease(this.other);
            return true;
        }
    }

    static class ScriptTarget<T> {
        final CodePosition codePosition;
        final Script<T> script;

        ScriptTarget(CodePosition codePosition, Script<T> targetScript) {
            this.codePosition = codePosition;
            this.script = targetScript;
        }
    }
}

