/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.Script;
import com.google.testing.threadtester.TestThread;
import com.google.testing.threadtester.TestTimeoutException;
import com.google.testing.threadtester.ThreadMonitor;
import com.google.testing.threadtester.ThrowingRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Scripter<T> {
    private List<Script<T>> scripts = new ArrayList<Script<T>>();
    private List<TestThread> threads;
    private volatile boolean started;
    private volatile boolean finished;
    private LinkedBlockingQueue<ReleaseEvent<T>> releaseQueue = new LinkedBlockingQueue();

    public Scripter(Script<T> main, Script<T> secondary) {
        if (main == null) {
            throw new IllegalArgumentException("Main script cannot be null");
        }
        if (secondary == null) {
            throw new IllegalArgumentException("Secondary script cannot be null");
        }
        this.scripts.add(main);
        this.scripts.add(secondary);
    }

    public Scripter(Script<T> main, Collection<Script<T>> secondaries) {
        if (main == null) {
            throw new IllegalArgumentException("Main thread cannot be null");
        }
        if (secondaries.size() == 0) {
            throw new IllegalArgumentException("Must specify secondary script(s)");
        }
        for (Script<T> secondary : secondaries) {
            if (secondary != null) continue;
            throw new IllegalArgumentException("Secondary scripts cannot be null");
        }
        this.scripts.add(main);
        this.scripts.addAll(secondaries);
    }

    public void execute() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Can only execute once");
        }
        this.started = true;
        this.threads = new ArrayList<TestThread>(this.scripts.size());
        for (int i = 0; i < this.scripts.size(); ++i) {
            final Script<T> script = this.scripts.get(i);
            ThrowingRunnable runnable = new ThrowingRunnable(){

                @Override
                public void run() throws Exception {
                    script.runTasks();
                }
            };
            TestThread thread = new TestThread(runnable, "Script " + (i + 1));
            this.threads.add(thread);
            script.prepare(this, thread);
            thread.start();
        }
        Options.debugPrint("Scripter: Starting main thread\n");
        Script<T> main = this.scripts.get(0);
        main.resume();
        this.monitorReleases(new ReleaseEvent<T>(null, main));
        Options.debugPrint("Scripter: Done all steps\n");
        for (Script<T> script : this.scripts) {
            script.resume();
        }
        for (Script<T> script : this.scripts) {
            TestThread scriptThread = script.getThread();
            scriptThread.finish();
        }
        for (TestThread thread : this.threads) {
            thread.throwExceptionsIfAny();
        }
    }

    private void monitorReleases(ReleaseEvent<T> event) throws InterruptedException, TestTimeoutException {
        do {
            event = this.monitorReleaseEvent(event);
            Options.debugPrint("Scripter: Got release from %s to %s\n", event.fromScript, event.toScript);
        } while (event.toScript != null);
    }

    /*
     * Unable to fully structure code
     */
    private ReleaseEvent<T> monitorReleaseEvent(ReleaseEvent<T> event) throws InterruptedException, TestTimeoutException {
        stepping = false;
        block0: while (true) {
            Options.debugPrint("Scripter: Waiting for next release\n");
            nextEvent = this.releaseQueue.poll(10L, TimeUnit.MILLISECONDS);
            if (nextEvent != null) {
                Options.debugPrint("Scripter: Found a release (%d), stepping = %s, to = %s, from = %s\n", new Object[]{nextEvent.count, stepping, nextEvent.toScript, event.fromScript});
                if (stepping) {
                    if (nextEvent.toScript != event.fromScript) {
                        Options.debugPrint("Scripter: to = %s, from = %s\n", new Object[]{nextEvent.toScript, event.fromScript});
                        throw new IllegalStateException("Got release to " + nextEvent.toScript + " while stepping through " + event.fromScript);
                    }
                    event.fromScript.finishStepping();
                }
                return nextEvent;
            }
            if (!this.isBlockedOnOther(event.fromScript, event.toScript)) continue;
            Options.debugPrint("Scripter: Thread is blocked by script that released us...\n");
            unblocked = false;
            event.fromScript.startStepping();
            while (true) {
                if (this.releaseQueue.peek() == null && this.isBlockedOnOther(event.fromScript, event.toScript)) ** break;
                continue block0;
                if (!event.fromScript.canStep()) {
                    throw new IllegalStateException("Failed to unblock script " + event.fromScript);
                }
                Options.debugPrint("Scripter: Stepping...\n");
                event.fromScript.step();
                stepping = true;
                Options.debugPrint("Scripter: Stepped...\n");
            }
            break;
        }
    }

    private boolean isBlockedOnOther(Script<T> fromScript, Script<T> toScript) {
        long blocker = ThreadMonitor.getBlockerId(toScript.getThread());
        Options.debugPrint("Scripter: toScript " + toScript + " is blocked by %d\n", blocker);
        if (blocker == -1L) {
            return false;
        }
        if (blocker == Thread.currentThread().getId()) {
            Options.debugPrint("Scripter: Thread is blocked by us...\n");
            return false;
        }
        if (fromScript == null) {
            throw new IllegalStateException("First script is blocked by " + blocker);
        }
        if (blocker == fromScript.getThread().getId()) {
            return true;
        }
        throw new IllegalStateException("Script " + toScript + " is blocked by " + blocker);
    }

    void release(Script<T> fromScript, Script<T> toScript) {
        Options.debugPrint("****************************\n");
        Options.debugPrint("Releasing from %s to %s\n", fromScript, toScript);
        if (!this.scripts.contains(toScript)) {
            throw new IllegalArgumentException("Release to unknown " + toScript);
        }
        if (this.finished) {
            throw new IllegalStateException("Cannot release after a thread has finished");
        }
        toScript.resume();
        try {
            ReleaseEvent<T> evt = new ReleaseEvent<T>(fromScript, toScript);
            Options.debugPrint("Scripter: adding event %d to queue\n", evt.count);
            this.releaseQueue.put(evt);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void onFinished(Script<T> finishedScript) {
        System.out.printf("Finishing %s\n", finishedScript);
        try {
            this.releaseQueue.put(new ReleaseEvent(null, null));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ReleaseEvent<T> {
        static AtomicInteger scount = new AtomicInteger(0);
        final int count;
        final Script<T> fromScript;
        final Script<T> toScript;

        ReleaseEvent(Script<T> fromScript, Script<T> toScript) {
            this.fromScript = fromScript;
            this.toScript = toScript;
            this.count = scount.incrementAndGet();
        }
    }
}

