/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.instrumentation.Instrumenter;
import com.google.testing.threadtester.CallLogger;
import com.google.testing.threadtester.CallLoggerFactory;
import com.google.testing.threadtester.LineInstrumentation;
import com.google.testing.threadtester.MethodInstrumentationImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.MethodInfo;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

public class TestInstrumenter
implements Instrumenter,
ClassFileTransformer {
    private static final boolean DEBUG = false;
    static final String GET_INSTRUMENTATION = "__getInstrumentation";
    protected static final String GET_METHOD = "__getMethod";
    protected static final String METHOD_TABLE = "__methodTable";
    protected static final String LOGGER = "__testLogger";
    private String getMethodName;
    private String methodTableName;
    private String loggerName;
    private static final String SYNC_PREFIX = "__synchronized_";
    private static final String INSTRUMENTED_METHOD = MethodInstrumentationImpl.class.getName();
    private static final String INSTRUMENTED_LINE = LineInstrumentation.class.getName();
    static String FACTORY_CLASS = CallLoggerFactory.class.getName();
    private static final String GET_LOGGER = "createLoggerForNewObject";
    private static final String LOGGER_CLASS = CallLogger.class.getName();
    private static final String AT_LINE = "atLine";
    private static final String START_METHOD = "start";
    private static final String END_METHOD = "end";
    private static final String BEGIN_CALL = "beginCall";
    private static final String END_CALL = "endCall";
    private Set<String> instrumentedClasses;
    private static final Map<String, Class<?>> primitives = new HashMap();
    private static final Map<String, String> primitiveArrayTypes;

    public TestInstrumenter(List<String> classes) {
        this.instrumentedClasses = new HashSet<String>(classes);
    }

    public static void premain(String agentArgument, Instrumentation instrumentation) {
        if (agentArgument != null) {
            String[] args = agentArgument.split(",");
            instrumentation.addTransformer(new TestInstrumenter(args));
        } else {
            System.err.printf("No classes defined oncommand line\n", new Object[0]);
        }
    }

    private TestInstrumenter(String[] classes) {
        this.instrumentedClasses = new HashSet<String>();
        for (String clss : classes) {
            StringBuffer className = new StringBuffer(clss);
            for (int i = 0; i < className.length(); ++i) {
                if (className.charAt(i) != '.') continue;
                className.setCharAt(i, '/');
            }
            TestInstrumenter.debugPrint("TestInstrumenter - instrumenting %s\n", className.toString());
            this.instrumentedClasses.add(className.toString());
        }
    }

    public byte[] transform(ClassLoader loader, String className, Class clss, ProtectionDomain domain, byte[] bytes) {
        return this.instrument(className, bytes);
    }

    @Override
    public byte[] instrument(String className, byte[] bytes) {
        if (this.instrumentedClasses.contains(className)) {
            TestInstrumenter.debugPrint("Transforming %s\n", className);
            try {
                return this.processClass(className, bytes);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Cannot instrument class", e);
            }
        }
        return bytes;
    }

    private byte[] processClass(String name, byte[] bytes) throws CannotCompileException {
        ClassPool pool = ClassPool.getDefault();
        CtClass cl = null;
        try {
            cl = pool.makeClass((InputStream)new ByteArrayInputStream(bytes));
            if (cl.isInterface()) {
                throw new IllegalArgumentException("Cannot instrument interfaces");
            }
            this.getMethodName = cl.makeUniqueName(GET_METHOD);
            this.methodTableName = cl.makeUniqueName(METHOD_TABLE);
            this.loggerName = cl.makeUniqueName(LOGGER);
            this.addDeclaration(cl);
            this.addGetMethod(cl);
            for (CtConstructor constructor : cl.getDeclaredConstructors()) {
                this.processConstructor(constructor);
            }
            MethodMap methodMap = new MethodMap();
            for (CtMethod method : cl.getDeclaredMethods()) {
                this.processMethod(cl, method, methodMap);
            }
            this.addGetInstrumentedMethods(cl, methodMap);
            this.addMethodTableInitializer(cl, methodMap);
            bytes = cl.toBytecode();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot process class data", e);
        }
        finally {
            if (cl != null) {
                cl.detach();
            }
        }
        return bytes;
    }

    private void addDeclaration(CtClass cl) throws CannotCompileException {
        String loggerDeclaration = "private " + LOGGER_CLASS + " " + this.loggerName + ";";
        CtField field = CtField.make((String)loggerDeclaration, (CtClass)cl);
        cl.addField(field);
    }

    private void addGetMethod(CtClass cl) throws CannotCompileException {
        CtField methodTable = CtField.make((String)("private static final java.util.HashMap " + this.methodTableName + " = new java.util.HashMap();\n"), (CtClass)cl);
        cl.addField(methodTable);
        StringBuilder code = new StringBuilder();
        code.append("  private static java.lang.reflect.Method ").append(this.getMethodName).append("(String name) {\n");
        code.append("    return (java.lang.reflect.Method)").append(this.methodTableName).append(".get(name);\n  }\n");
        TestInstrumenter.debugPrint("Adding method %s\n", code);
        CtMethod newMethod = CtMethod.make((String)code.toString(), (CtClass)cl);
        cl.addMethod(newMethod);
    }

    private String addSyncPrefix(CtClass clss, String name) {
        return clss.makeUniqueName(SYNC_PREFIX + name);
    }

    private void addMethodTableInitializer(CtClass cl, MethodMap methodMap) throws CannotCompileException {
        CtConstructor initializer = cl.makeClassInitializer();
        StringBuilder code = new StringBuilder();
        code.append("  {\n");
        for (CtMethod methodDescriptor : methodMap.getMethods()) {
            String methodName = methodMap.getOriginalName(methodDescriptor);
            CtClass definingClass = methodDescriptor.getDeclaringClass();
            String methodId = methodMap.getMethodId(methodDescriptor);
            List<Class<?>> paramClasses = this.getParameterClasses((CtBehavior)methodDescriptor);
            String paramArgs = this.getParameterArg(paramClasses);
            code.append("    ").append(this.methodTableName).append(".put(\"");
            code.append(methodId).append("\", ");
            code.append(definingClass.getName()).append(".class.");
            code.append("getDeclaredMethod(\"").append(methodName).append("\", ");
            code.append(paramArgs).append("));\n");
        }
        code.append("  }\n");
        TestInstrumenter.debugPrint("Adding method table %s\n", code);
        initializer.insertBefore(code.toString());
    }

    private void addGetInstrumentedMethods(CtClass cl, MethodMap methodMap) throws CannotCompileException {
        StringBuilder code = new StringBuilder();
        code.append("  public static java.util.List ").append(GET_INSTRUMENTATION).append("() {\n");
        code.append("    java.util.List methods = new java.util.ArrayList();\n");
        for (CtMethod methodDescriptor : methodMap.getMethods()) {
            List<Integer> lines = methodMap.getLines(methodDescriptor);
            if (lines == null) {
                TestInstrumenter.debugPrint("No lines for %s\n", methodDescriptor);
                continue;
            }
            code.append("    {\n      java.util.List lines = new java.util.ArrayList(");
            code.append(lines.size()).append(");\n");
            for (Integer line : lines) {
                code.append("      lines.add(new ").append(INSTRUMENTED_LINE);
                code.append("(").append(line).append("));\n");
            }
            String methodId = methodMap.getMethodId(methodDescriptor);
            code.append("      ").append(INSTRUMENTED_METHOD).append(" method = new ");
            code.append(INSTRUMENTED_METHOD);
            code.append("(").append(this.getMethodName).append("(\"");
            code.append(methodId).append("\"), lines);\n").append("      methods.add(method);\n    }\n");
        }
        code.append("    return methods;\n  }\n");
        TestInstrumenter.debugPrint("Adding method \n%s\n", code);
        CtMethod newMethod = CtMethod.make((String)code.toString(), (CtClass)cl);
        cl.addMethod(newMethod);
    }

    static Class<?> getClass(CtClass clss) {
        String name = clss.getName();
        Class<?> result = primitives.get(name);
        if (result == null) {
            int end;
            int dimension = 0;
            for (end = name.length() - 1; end > 0 && name.charAt(end) == ']'; end -= 2) {
                ++dimension;
            }
            if (dimension > 0) {
                String baseType = name.substring(0, end + 1);
                String arrayType = primitiveArrayTypes.get(baseType);
                if (arrayType == null) {
                    arrayType = "L" + baseType + ";";
                }
                String prefix = "[";
                for (int i = 1; i < dimension; ++i) {
                    prefix = prefix + "[";
                }
                name = prefix + arrayType;
                TestInstrumenter.debugPrint("Looking up array type %s\n", name);
            }
            try {
                result = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private List<Class<?>> getParameterClasses(CtBehavior method) {
        try {
            CtClass[] params = method.getParameterTypes();
            ArrayList result = new ArrayList(params.length);
            for (CtClass paramClass : params) {
                result.add(TestInstrumenter.getClass(paramClass));
            }
            return result;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String getParameterArg(List<Class<?>> paramClasses) {
        if (paramClasses.size() == 0) {
            return "new Class[0]";
        }
        StringBuilder result = new StringBuilder();
        result.append("new Class[] {");
        int len = paramClasses.size();
        for (int i = 0; i < len; ++i) {
            Class<?> paramClass = paramClasses.get(i);
            if (paramClass.isArray()) {
                result.append("Class.forName(\"").append(paramClass.getName()).append("\")");
            } else {
                result.append(paramClass.getName()).append(".class");
            }
            if (i >= len - 1) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }

    private void processConstructor(CtConstructor constructor) throws CannotCompileException {
        StringBuilder before = new StringBuilder();
        before.append(this.loggerName).append(" = ").append(FACTORY_CLASS).append(".").append(GET_LOGGER).append("($0);");
        TestInstrumenter.debugPrint("    For construtor, Before = %s\n", before);
        constructor.insertBeforeBody(before.toString());
    }

    private String getBeforeLogging(String methodId) {
        StringBuilder before = new StringBuilder();
        before.append(this.loggerName).append(".").append(START_METHOD).append("(");
        before.append(this.getMethodName).append("(\"").append(methodId).append("\"));");
        TestInstrumenter.debugPrint("    Before = %s\n", before);
        return before.toString();
    }

    private String getAfterLogging(String methodId) {
        StringBuilder after = new StringBuilder();
        after.append(this.loggerName).append(".").append(END_METHOD).append("(");
        after.append(this.getMethodName).append("(\"").append(methodId).append("\"));\n");
        TestInstrumenter.debugPrint("    After = %s\n", after);
        return after.toString();
    }

    private void processMethod(CtClass clss, CtMethod method, final MethodMap methodMap) throws CannotCompileException {
        int byteCodeLength;
        TestInstrumenter.debugPrint("   Processing %s\n", method.getName());
        MethodInfo methodInfo = method.getMethodInfo();
        if (methodInfo.isStaticInitializer()) {
            return;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic((int)modifiers)) {
            return;
        }
        boolean isSynchronized = Modifier.isSynchronized((int)modifiers);
        String name = method.getName();
        if (name.equals(this.getMethodName)) {
            return;
        }
        CodeAttribute codeAttr = methodInfo.getCodeAttribute();
        int n = byteCodeLength = codeAttr == null ? 0 : codeAttr.getCode().length;
        if (byteCodeLength == 0) {
            TestInstrumenter.debugPrint("    No byteCode in method???\n", new Object[0]);
            return;
        }
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        Integer prevLine = methodInfo.getLineNumber(0);
        lineNumbers.add(prevLine);
        for (int i = 0; i < byteCodeLength; ++i) {
            int line = methodInfo.getLineNumber(i);
            if (line <= prevLine) continue;
            prevLine = line;
            lineNumbers.add(line);
        }
        final String thisMethodId = methodMap.registerMethodId(method, lineNumbers);
        method.instrument(new ExprEditor(){

            public void edit(MethodCall called) throws CannotCompileException {
                try {
                    CtMethod calledMethod = called.getMethod();
                    String calledMethodId = methodMap.registerMethodId(calledMethod);
                    CtClass returnType = calledMethod.getReturnType();
                    boolean isVoid = returnType == CtClass.voidType;
                    String methodReplacement = isVoid ? "{$proceed($$);}" : "{$_ = $proceed($$);}";
                    StringBuilder loggerArgs = new StringBuilder();
                    loggerArgs.append(TestInstrumenter.this.getMethodName).append("(\"").append(thisMethodId).append("\"), ");
                    loggerArgs.append(called.getLineNumber()).append(", ");
                    loggerArgs.append(TestInstrumenter.this.getMethodName).append("(\"").append(calledMethodId).append("\")");
                    StringBuilder replacement = new StringBuilder();
                    replacement.append("{").append(TestInstrumenter.this.loggerName).append(".").append(TestInstrumenter.BEGIN_CALL).append("(");
                    replacement.append((CharSequence)loggerArgs).append(");} ");
                    replacement.append(methodReplacement);
                    replacement.append("{").append(TestInstrumenter.this.loggerName).append(".").append(TestInstrumenter.END_CALL).append("(");
                    replacement.append((CharSequence)loggerArgs).append(");} ");
                    TestInstrumenter.debugPrint("    Replacing with \"%s\"\n", new Object[]{replacement});
                    called.replace(replacement.toString());
                }
                catch (NotFoundException e) {
                    throw new CannotCompileException(e);
                }
            }
        });
        if (!isSynchronized) {
            method.insertBefore(this.getBeforeLogging(thisMethodId));
            method.insertAfter(this.getAfterLogging(thisMethodId), true);
        } else {
            this.addSynchronizedWrapper(clss, method, thisMethodId, methodMap);
        }
        for (Integer line : lineNumbers) {
            StringBuilder atLine = new StringBuilder();
            atLine.append("{").append(this.loggerName).append(".").append(AT_LINE);
            atLine.append("(").append(line).append(");}");
            TestInstrumenter.debugPrint("   Inserting %s at %d\n", atLine, line);
            int inserted = method.insertAt(line.intValue(), atLine.toString());
            if (inserted == line) continue;
            throw new IllegalStateException("Tried to insert at " + line + ", got " + atLine);
        }
    }

    private void addSynchronizedWrapper(CtClass clss, CtMethod originalMethod, String thisMethodId, MethodMap methodMap) throws CannotCompileException {
        StringBuilder wrapper = new StringBuilder();
        try {
            int originalModifiers;
            CtClass returnType = originalMethod.getReturnType();
            boolean isVoid = returnType == CtClass.voidType;
            int wrapperModifiers = originalModifiers = originalMethod.getModifiers();
            originalModifiers = Modifier.setPrivate((int)originalModifiers);
            originalMethod.setModifiers(originalModifiers);
            wrapperModifiers &= 0xFFFFFFDF;
            String name = originalMethod.getName();
            String privateName = this.addSyncPrefix(clss, name);
            originalMethod.setName(privateName);
            methodMap.logRenamedMethod(originalMethod, name);
            originalMethod.setModifiers(originalModifiers);
            CtMethod wrapperMethod = CtNewMethod.copy((CtMethod)originalMethod, (String)name, (CtClass)clss, null);
            wrapper.append(" {\n");
            wrapper.append(this.getBeforeLogging(thisMethodId));
            wrapper.append("\n  try {\n    ");
            if (!isVoid) {
                wrapper.append("return ");
            }
            wrapper.append(privateName).append("($$);\n");
            wrapper.append("  } finally {\n    ");
            wrapper.append(this.getAfterLogging(thisMethodId));
            wrapper.append("  }\n}\n");
            TestInstrumenter.debugPrint("Wrapper = \n%s\n", wrapper);
            wrapperMethod.setBody(wrapper.toString());
            wrapperMethod.setModifiers(wrapperModifiers);
            clss.addMethod(wrapperMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    private static void debugPrint(String format, Object ... args) {
    }

    static {
        primitives.put("byte", Byte.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("char", Character.TYPE);
        primitiveArrayTypes = new HashMap<String, String>();
        primitiveArrayTypes.put("byte", "B");
        primitiveArrayTypes.put("short", "S");
        primitiveArrayTypes.put("int", "I");
        primitiveArrayTypes.put("long", "J");
        primitiveArrayTypes.put("float", "F");
        primitiveArrayTypes.put("double", "D");
        primitiveArrayTypes.put("boolean", "Z");
        primitiveArrayTypes.put("char", "C");
    }

    private static class MethodMap {
        private Map<MethodReference, String> map = new HashMap<MethodReference, String>();
        private Map<MethodReference, String> renameMap = new HashMap<MethodReference, String>();
        private Map<MethodReference, List<Integer>> lineMap = new HashMap<MethodReference, List<Integer>>();
        private Map<String, Integer> suffixMap = new HashMap<String, Integer>();

        private MethodMap() {
        }

        String registerMethodId(CtMethod newMethod, List<Integer> lines) {
            MethodReference reference = new MethodReference(newMethod);
            String uniqueName = this.map.get(reference);
            if (uniqueName == null) {
                String methodName = newMethod.getName();
                Integer suffix = this.suffixMap.get(methodName);
                suffix = suffix == null ? Integer.valueOf(0) : Integer.valueOf(suffix + 1);
                uniqueName = methodName + suffix;
                this.suffixMap.put(methodName, suffix);
                this.map.put(reference, uniqueName);
            }
            if (lines != null) {
                this.lineMap.put(reference, lines);
            }
            return uniqueName;
        }

        String registerMethodId(CtMethod newMethod) {
            return this.registerMethodId(newMethod, null);
        }

        List<CtMethod> getMethods() {
            Set<MethodReference> refs = this.map.keySet();
            ArrayList<CtMethod> methods = new ArrayList<CtMethod>(refs.size());
            for (MethodReference ref : refs) {
                methods.add(ref.method);
            }
            return methods;
        }

        String getMethodId(CtMethod method) {
            return this.map.get(new MethodReference(method));
        }

        void logRenamedMethod(CtMethod method, String originalName) {
            this.renameMap.put(new MethodReference(method), originalName);
        }

        String getOriginalName(CtMethod method) {
            String result = this.renameMap.get(new MethodReference(method));
            if (result == null) {
                result = method.getName();
            }
            return result;
        }

        List<Integer> getLines(CtMethod method) {
            return this.lineMap.get(new MethodReference(method));
        }

        private static class MethodReference {
            final CtMethod method;

            MethodReference(CtMethod method) {
                this.method = method;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof MethodReference)) {
                    return false;
                }
                MethodReference other = (MethodReference)obj;
                return this.method.equals((Object)other.method) && this.method.getDeclaringClass().equals(other.method.getDeclaringClass());
            }

            public int hashCode() {
                int result = 17;
                result += 37 * this.method.hashCode();
                return result += 37 * this.method.getDeclaringClass().hashCode();
            }
        }
    }
}

