/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.threadtester;

import com.google.testing.threadtester.Options;
import com.google.testing.threadtester.TestTimeoutException;
import com.google.testing.threadtester.ThrowingRunnable;

public class TestThread
extends Thread {
    private volatile Throwable threadException;

    public TestThread(Runnable target, String name) {
        super(target, name);
        this.setHandler();
    }

    public TestThread(ThrowingRunnable target, String name) {
        super((Runnable)new TestRunnableWrapper(target), name);
        this.setHandler();
    }

    public TestThread(String name) {
        super(name);
        this.setHandler();
    }

    private void setHandler() {
        this.setUncaughtExceptionHandler(new ExceptionHandler());
    }

    public void finish() throws InterruptedException, TestTimeoutException {
        this.join(Options.timeout());
        if (this.getState() != Thread.State.TERMINATED) {
            throw new TestTimeoutException("State = " + (Object)((Object)this.getState()), this);
        }
    }

    public Throwable getException() {
        return this.threadException;
    }

    public void throwExceptionsIfAny() {
        if (this.threadException != null) {
            if (this.threadException instanceof RuntimeException) {
                throw (RuntimeException)this.threadException;
            }
            if (this.threadException instanceof Error) {
                throw (Error)this.threadException;
            }
            throw new RuntimeException(this.threadException);
        }
    }

    private static class TestRunnableWrapper
    implements Runnable {
        private ThrowingRunnable target;

        public TestRunnableWrapper(ThrowingRunnable target) {
            this.target = target;
        }

        @Override
        public void run() {
            try {
                this.target.run();
            }
            catch (Exception e) {
                ((TestThread)Thread.currentThread()).threadException = e;
            }
        }
    }

    private class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            TestThread.this.threadException = e;
        }
    }
}

