/*
 * Decompiled with CFR 0.152.
 */
package org.todomap.tools.jettygzip;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyGzipMojo
extends AbstractMojo {
    private File webappDirectory;
    private File outputDirectory;
    private List<String> extensions = this.getDefaultExtensions();

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Compressing static resources with gzip...");
        try {
            if (!ObjectUtils.equals((Object)this.webappDirectory, (Object)this.outputDirectory)) {
                FileUtils.copyDirectory((File)this.webappDirectory, (File)this.outputDirectory, (FileFilter)new DotNotFilter());
            }
            this.seekAndGzip(this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO exception when gzipping files", (Exception)e);
        }
    }

    List<String> getDefaultExtensions() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(".css");
        ret.add(".txt");
        ret.add(".html");
        ret.add(".htm");
        ret.add(".js");
        ret.add(".xml");
        ret.add(".xls");
        ret.add(".ico");
        ret.add(".pdf");
        ret.add(".doc");
        return ret;
    }

    void seekAndGzip(File directory) throws IOException {
        String[] subDirs;
        String[] fileNames = directory.list(new FilesToGzipFilter());
        if (fileNames == null) {
            this.getLog().error((CharSequence)("Directory does not exist: " + directory.getAbsolutePath()));
            return;
        }
        for (String fileName : fileNames) {
            File gzippedFile = new File(directory, fileName.concat(".gz"));
            if (gzippedFile.exists()) continue;
            File sourceFile = new File(directory, fileName);
            FileInputStream inputStream = new FileInputStream(sourceFile);
            FileOutputStream fileStream = new FileOutputStream(gzippedFile);
            GZIPOutputStream gzipStream = new GZIPOutputStream(fileStream);
            IOUtils.copy((InputStream)inputStream, (OutputStream)gzipStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)gzipStream);
            IOUtils.closeQuietly((OutputStream)fileStream);
            this.getLog().info((CharSequence)("Compressed file " + sourceFile.getName() + ". " + sourceFile.length() + " -> " + gzippedFile.length()));
        }
        for (String subDir : subDirs = directory.list(new SubdirsFilter())) {
            this.seekAndGzip(new File(directory, subDir));
        }
    }

    private final class SubdirsFilter
    implements FilenameFilter {
        private SubdirsFilter() {
        }

        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory() && !"WEB-INF".equals(name);
        }
    }

    private final class FilesToGzipFilter
    implements FilenameFilter {
        private FilesToGzipFilter() {
        }

        public boolean accept(File dir, String name) {
            return this.matchesAny(name) && new File(dir, name).isFile();
        }

        private boolean matchesAny(String fileName) {
            for (String pattern : JettyGzipMojo.this.extensions) {
                if (!fileName.endsWith(pattern)) continue;
                return true;
            }
            return false;
        }
    }

    private final class DotNotFilter
    implements FileFilter {
        private DotNotFilter() {
        }

        public boolean accept(File pathname) {
            return !pathname.getName().startsWith(".");
        }
    }
}

