/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.usc.folder.compression;

import com.googlecode.usc.folder.compression.CompressionType;
import com.googlecode.usc.folder.compression.Context;
import com.googlecode.usc.folder.compression.StrategyFactory;
import com.googlecode.usc.folder.compression.utils.CompressionUtil;
import com.googlecode.usc.folder.compression.utils.PrintTimerTask;
import java.io.File;
import java.util.List;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;

public class App1 {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        System.out.print("\u8bf7\u8f93\u5165\u6587\u4ef6\u5939\u8def\u5f84\uff1a");
        String folderPath = scanner.next();
        CompressionType[] compressionTypes = CompressionType.values();
        System.out.print("\u8bf7\u9009\u62e9\u538b\u7f29\u7c7b\u578b");
        for (int i = 0; i < compressionTypes.length; ++i) {
            System.out.print("\n" + (i + 1) + "). " + (Object)((Object)compressionTypes[i]));
            if (i != 0) continue;
            System.out.print("(\u9ed8\u8ba4)");
        }
        System.out.print("\n(\u9009\u62e9\u6570\u5b57)\uff1a");
        int choose = scanner.nextInt();
        choose = choose < 1 || choose > compressionTypes.length ? 0 : --choose;
        CompressionType compressionType = compressionTypes[choose];
        System.out.print("\u662f\u5426\u6309\u7167\u9ed8\u8ba4\u7684\u8fc7\u6ee4\u89c4\u5219(.svn | target | .classpath | .project | .settings)\u6765\u538b\u7f29\uff1f(Y/N)\uff1a");
        boolean isUseDefault = CompressionUtil.isYes(scanner.next());
        String excludedWords = "";
        String isAgain = null;
        if (isUseDefault) {
            excludedWords = ".svn | target | .classpath | .project | .settings";
            System.out.print("\u662f\u5426\u8fd8\u6dfb\u52a0\u8fc7\u6ee4\u89c4\u5219\uff1f(Y/N)\uff1a");
            isAgain = scanner.next();
        }
        if (!isUseDefault || CompressionUtil.isYes(isAgain)) {
            System.out.print("\u8bf7\u6dfb\u52a0\u8fc7\u6ee4\u89c4\u5219\uff0c\u591a\u4e2a\u8fc7\u6ee4\u8bcd\u4ee5\" | \"\u5206\u5272\uff1a");
            scanner.nextLine();
            excludedWords = excludedWords + (!"".equals(excludedWords) ? " | " : "") + scanner.nextLine();
        }
        List<String> excludedKeys = CompressionUtil.initExcludedKeys(excludedWords);
        File file = new File(folderPath);
        File[] files = file.listFiles();
        if (files != null) {
            File out = new File(file.getAbsolutePath() + compressionType.getSuffix());
            StrategyFactory sf = new StrategyFactory();
            sf.createStrategy(compressionType);
            Timer timer = new Timer();
            timer.schedule((TimerTask)new PrintTimerTask(), 0L, 1000L);
            System.out.println("\u538b\u7f29\u5f00\u59cb\uff0c\u8bf7\u7b49\u5f85");
            new Context(sf.createStrategy(compressionType)).doCompress(files, out, excludedKeys);
            timer.cancel();
            System.out.println("\n\u538b\u7f29\u6210\u529f\uff0c\u8bf7\u67e5\u770b " + out);
        } else {
            System.err.println("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u8005\u8f93\u5165\u7684\u662f\u6587\u4ef6!");
            System.exit(1);
        }
    }
}

