/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.usc.folder.compression;

import com.googlecode.usc.folder.compression.utils.CompressionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Strategy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCompress(File[] files, File out, List<String> excludedKeys) {
        HashMap<String, File> map = new HashMap<String, File>();
        String parent = FilenameUtils.getBaseName(out.getName());
        for (File f : files) {
            CompressionUtil.list(f, parent, map, excludedKeys);
        }
        if (!map.isEmpty()) {
            FileOutputStream fos = null;
            ArchiveOutputStream aos = null;
            FileInputStream is = null;
            try {
                fos = new FileOutputStream(out);
                aos = this.getArchiveOutputStream(fos);
                for (Map.Entry entry : map.entrySet()) {
                    File file = (File)entry.getValue();
                    ArchiveEntry ae = this.getArchiveEntry(file, (String)entry.getKey());
                    aos.putArchiveEntry(ae);
                    if (file.isFile()) {
                        is = new FileInputStream(file);
                        IOUtils.copy((InputStream)is, (OutputStream)aos);
                        IOUtils.closeQuietly(is);
                        is = null;
                    }
                    aos.closeArchiveEntry();
                }
                aos.finish();
            }
            catch (IOException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(aos);
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(aos);
                IOUtils.closeQuietly(fos);
            }
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(aos);
            IOUtils.closeQuietly(fos);
        }
    }

    public abstract ArchiveOutputStream getArchiveOutputStream(FileOutputStream var1) throws IOException;

    public abstract ArchiveEntry getArchiveEntry(File var1, String var2);
}

