/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.usc.folder.compression.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompressionUtil {
    public static final List<String> YES_LIST = Arrays.asList("Y", "y", "true", "TRUE", "\u662f");
    public static final String SPILT_CHAR = " | ";
    public static final String DEFAULT_EXCLUDED_WORDS = ".svn | target | .classpath | .project | .settings";

    public static boolean isYes(String next) {
        return YES_LIST.contains(next);
    }

    public static List<String> initExcludedKeys(String excludedWords) {
        ArrayList<String> excludedKeys = new ArrayList<String>();
        if (StringUtils.isNotBlank(excludedWords)) {
            excludedKeys.addAll(Arrays.asList(excludedWords.split("\\s" + SPILT_CHAR.trim() + "\\s")));
        }
        return excludedKeys;
    }

    public static void list(File f, String parent, Map<String, File> map, List<String> excludedKeys) {
        String name = f.getName();
        if (parent != null) {
            name = parent + "/" + name;
        }
        if (!CompressionUtil.isExcluded(f, excludedKeys)) {
            map.put(name, f);
            if (f.isDirectory()) {
                for (File file : f.listFiles()) {
                    CompressionUtil.list(file, name, map, excludedKeys);
                }
            }
        }
    }

    protected static boolean isExcluded(File f, List<String> excludedKeys) {
        for (String key : excludedKeys) {
            if (!key.equalsIgnoreCase(f.getName())) continue;
            return true;
        }
        return false;
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        if (c != null && string != null) {
            try {
                return Enum.valueOf(c, string.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

