/**
 *   Copyright 2012-2013 Wicked Charts (http://wicked-charts.googlecode.com)
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.googlecode.wickedcharts.highcharts.options;

import com.googlecode.wickedcharts.highcharts.json.LowercaseEnum;

/**
 * Enumeration of the possible types of charts. The data contained in a series
 * will be displayed as one of these types-
 *
 * @author Tom Hombergs (tom.hombergs@gmail.com)
 * @see <a
 * href="http://api.highcharts.com/highcharts#series.type">http://api.highcharts.com/highcharts#series.type</a>
 */
public enum SeriesType implements LowercaseEnum {

    AREA(ChartType.BASIC),

    AREASPLINE(ChartType.BASIC),

    BAR(ChartType.BASIC),

    COLUMN(ChartType.BASIC),

    LINE(ChartType.BASIC),

    PIE(ChartType.BASIC),

    SCATTER(ChartType.BASIC),

    SPLINE(ChartType.BASIC),

    GAUGE(ChartType.ADVANCED),

    COLUMNRANGE(ChartType.ADVANCED),

    AREASPLINERANGE(ChartType.ADVANCED),

    AREARANGE(ChartType.ADVANCED),

    BUBBLE(ChartType.ADVANCED),

    BOXPLOT(ChartType.ADVANCED),

    ERRORBAR(ChartType.ADVANCED),

    FUNNEL(ChartType.BASIC),

    PYRAMID(ChartType.BASIC),

    HEATMAP(ChartType.BASIC);

    private ChartType chartType;

    private SeriesType(ChartType chartType) {
        this.setChartType(chartType);
    }

    public void setChartType(ChartType chartType) {
        this.chartType = chartType;
    }

    public ChartType getChartType() {
        return chartType;
    }

}
