/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.googlecode.wickedcharts.highcharts.options.CssStyle;
import java.io.IOException;
import java.util.Map;

public class CssStyleSerializer
extends JsonSerializer<CssStyle> {
    public void serialize(CssStyle value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        StringBuilder cssStyleBuilder = new StringBuilder();
        cssStyleBuilder.append("{");
        for (Map.Entry<String, String> property : value.getProperties().entrySet()) {
            cssStyleBuilder.append("\"" + property.getKey() + "\": \"" + property.getValue() + "\",");
        }
        int lastCommaPosition = cssStyleBuilder.lastIndexOf(",");
        if (lastCommaPosition != -1) {
            cssStyleBuilder.deleteCharAt(lastCommaPosition);
        }
        cssStyleBuilder.append(" }");
        jgen.writeRawValue(cssStyleBuilder.toString());
    }
}

