/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.googlecode.wickedcharts.highcharts.jackson.ColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.options.color.HexColor;
import java.io.IOException;

public class HexColorReferenceSerializer
extends ColorReferenceSerializer<HexColor> {
    @Override
    protected void serializeIfNotNull(HexColor color, JsonGenerator jgen, SerializerProvider provider) throws JsonGenerationException, IOException {
        if (color.getBrightness() == null) {
            jgen.writeString(color.getHexColor());
        } else {
            String colorString = this.brighten("\"" + color.getHexColor() + "\"", color.getBrightness().floatValue());
            jgen.writeRawValue(colorString);
        }
    }
}

