/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.googlecode.wickedcharts.highcharts.jackson.BubbleSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.CenterSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.CoordinateSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.CrosshairSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.CssStyleSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.DateTimeLabelFormatSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.FunctionSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.HexColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.HighchartsColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.LowercaseEnumSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.MinorTickIntervalSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.NullColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.PixelOrPercentSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.RangeCoordinateSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.RgbaColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.SimpleColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.SymbolSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.ThreeDimensionalCoordinateSerializer;
import com.googlecode.wickedcharts.highcharts.jackson.WickedChartsJacksonModule;
import com.googlecode.wickedcharts.highcharts.json.LowercaseEnum;
import com.googlecode.wickedcharts.highcharts.options.Center;
import com.googlecode.wickedcharts.highcharts.options.Crosshair;
import com.googlecode.wickedcharts.highcharts.options.CssStyle;
import com.googlecode.wickedcharts.highcharts.options.DateTimeLabelFormat;
import com.googlecode.wickedcharts.highcharts.options.Function;
import com.googlecode.wickedcharts.highcharts.options.MinorTickInterval;
import com.googlecode.wickedcharts.highcharts.options.PixelOrPercent;
import com.googlecode.wickedcharts.highcharts.options.Symbol;
import com.googlecode.wickedcharts.highcharts.options.color.HexColor;
import com.googlecode.wickedcharts.highcharts.options.color.HighchartsColor;
import com.googlecode.wickedcharts.highcharts.options.color.NullColor;
import com.googlecode.wickedcharts.highcharts.options.color.RgbaColor;
import com.googlecode.wickedcharts.highcharts.options.color.SimpleColor;
import com.googlecode.wickedcharts.highcharts.options.series.Bubble;
import com.googlecode.wickedcharts.highcharts.options.series.Coordinate;
import com.googlecode.wickedcharts.highcharts.options.series.RangeCoordinate;
import com.googlecode.wickedcharts.highcharts.options.series.ThreeDCoordinate;
import java.util.Locale;

public class JsonRenderer {
    private final ObjectMapper jacksonMapper;
    private final WickedChartsJacksonModule jacksonModule = new WickedChartsJacksonModule();
    public static final ObjectMapper DEFAULT_MAPPER = JsonRenderer.createDefaultObjectMapper();

    public JsonRenderer() {
        this.jacksonMapper = this.createJacksonMapper();
    }

    public <T> void addSerializer(Class<T> clazz, JsonSerializer<T> serializer) {
        this.jacksonModule.addSerializer(clazz, serializer);
    }

    private ObjectMapper createJacksonMapper() {
        this.jacksonModule.addSerializer(Center.class, new CenterSerializer());
        this.jacksonModule.addSerializer(SimpleColor.class, new SimpleColorReferenceSerializer());
        this.jacksonModule.addSerializer(HighchartsColor.class, new HighchartsColorReferenceSerializer());
        this.jacksonModule.addSerializer(HexColor.class, new HexColorReferenceSerializer());
        this.jacksonModule.addSerializer(LowercaseEnum.class, new LowercaseEnumSerializer());
        this.jacksonModule.addSerializer(PixelOrPercent.class, new PixelOrPercentSerializer());
        this.jacksonModule.addSerializer(Symbol.class, new SymbolSerializer());
        this.jacksonModule.addSerializer(RgbaColor.class, new RgbaColorReferenceSerializer());
        this.jacksonModule.addSerializer(NullColor.class, new NullColorReferenceSerializer());
        this.jacksonModule.addSerializer(MinorTickInterval.class, new MinorTickIntervalSerializer());
        this.jacksonModule.addSerializer(Function.class, new FunctionSerializer());
        this.jacksonModule.addSerializer(CssStyle.class, new CssStyleSerializer());
        this.jacksonModule.addSerializer(DateTimeLabelFormat.class, new DateTimeLabelFormatSerializer());
        this.jacksonModule.addSerializer(Coordinate.class, new CoordinateSerializer());
        this.jacksonModule.addSerializer(Crosshair.class, new CrosshairSerializer());
        this.jacksonModule.addSerializer(RangeCoordinate.class, new RangeCoordinateSerializer());
        this.jacksonModule.addSerializer(Bubble.class, new BubbleSerializer());
        this.jacksonModule.addSerializer(ThreeDCoordinate.class, new ThreeDimensionalCoordinateSerializer());
        ObjectMapper mapper = JsonRenderer.createDefaultObjectMapper();
        mapper.setLocale(Locale.ENGLISH);
        mapper.registerModule((Module)this.jacksonModule);
        return mapper;
    }

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public String toJson(Object object) {
        try {
            return this.jacksonMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to serialize object of type " + object.getClass().getName() + " into JSON!", e);
        }
    }

    public <T> T fromJson(String json, Class<T> targetClazz) {
        try {
            return (T)this.jacksonMapper.readValue(json, targetClazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to deserialize object of type " + targetClazz.getName() + " into JSON!", e);
        }
    }
}

