/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LanguageOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String decimalPoint;
    private String downloadPNG;
    private String downloadJPEG;
    private String downloadPDF;
    private String downloadSVG;
    private String loading;
    private List<String> months;
    private List<String> shortMonths;
    private String resetZoom;
    private String resetZoomTitle;
    private String thousandsSep;
    private List<String> weekdays;
    private String contextButtonTitle;
    private List<String> numericSymbols;
    private String printChart;
    private String rangeSelectorFrom;
    private String rangeSelectorTo;
    private String rangeSelectorZoom;

    public static LanguageOptions forLocale(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(LanguageOptions.class.getName(), locale);
            LanguageOptions options = new LanguageOptions();
            options.setDecimalPoint(bundle.getString("decimalPoint"));
            options.setDownloadPNG(bundle.getString("downloadPNG"));
            options.setDownloadJPEG(bundle.getString("downloadJPEG"));
            options.setDownloadPDF(bundle.getString("downloadPDF"));
            options.setDownloadSVG(bundle.getString("downloadSVG"));
            options.setLoading(bundle.getString("loading"));
            options.setMonths(Arrays.asList(bundle.getString("months").split(",")));
            options.setShortMonths(Arrays.asList(bundle.getString("shortMonths").split(",")));
            options.setResetZoom(bundle.getString("resetZoom"));
            options.setResetZoomTitle(bundle.getString("resetZoomTitle"));
            options.setThousandsSep(bundle.getString("thousandsSep"));
            options.setWeekdays(Arrays.asList(bundle.getString("weekdays").split(",")));
            options.setContextButtonTitle(bundle.getString("contextButtonTitle"));
            options.setNumericSymbols(Arrays.asList(bundle.getString("numericSymbols").split(",")));
            options.setPrintChart(bundle.getString("printChart"));
            options.setRangeSelectorFrom(bundle.getString("rangeSelectorFrom"));
            options.setRangeSelectorTo(bundle.getString("rangeSelectorTo"));
            options.setRangeSelectorZoom(bundle.getString("rangeSelectorZoom"));
            return options;
        }
        catch (MissingResourceException e) {
            return new LanguageOptions();
        }
    }

    public String getDecimalPoint() {
        return this.decimalPoint;
    }

    public String getDownloadJPEG() {
        return this.downloadJPEG;
    }

    public String getDownloadPDF() {
        return this.downloadPDF;
    }

    public String getDownloadPNG() {
        return this.downloadPNG;
    }

    public String getDownloadSVG() {
        return this.downloadSVG;
    }

    public String getLoading() {
        return this.loading;
    }

    public List<String> getMonths() {
        return this.months;
    }

    public String getResetZoom() {
        return this.resetZoom;
    }

    public String getResetZoomTitle() {
        return this.resetZoomTitle;
    }

    public List<String> getShortMonths() {
        return this.shortMonths;
    }

    public String getThousandsSep() {
        return this.thousandsSep;
    }

    public List<String> getWeekdays() {
        return this.weekdays;
    }

    public LanguageOptions setDecimalPoint(String decimalPoint) {
        this.decimalPoint = decimalPoint;
        return this;
    }

    public LanguageOptions setDownloadJPEG(String downloadJPEG) {
        this.downloadJPEG = downloadJPEG;
        return this;
    }

    public LanguageOptions setDownloadPDF(String downloadPDF) {
        this.downloadPDF = downloadPDF;
        return this;
    }

    public LanguageOptions setDownloadPNG(String downloadPNG) {
        this.downloadPNG = downloadPNG;
        return this;
    }

    public LanguageOptions setDownloadSVG(String downloadSVG) {
        this.downloadSVG = downloadSVG;
        return this;
    }

    public LanguageOptions setLoading(String loading) {
        this.loading = loading;
        return this;
    }

    public LanguageOptions setMonths(List<String> months) {
        this.months = months;
        return this;
    }

    public LanguageOptions setResetZoom(String resetZoom) {
        this.resetZoom = resetZoom;
        return this;
    }

    public LanguageOptions setResetZoomTitle(String resetZoomTitle) {
        this.resetZoomTitle = resetZoomTitle;
        return this;
    }

    public LanguageOptions setShortMonths(List<String> shortMonths) {
        this.shortMonths = shortMonths;
        return this;
    }

    public LanguageOptions setThousandsSep(String thousandsSep) {
        this.thousandsSep = thousandsSep;
        return this;
    }

    public LanguageOptions setWeekdays(List<String> weekdays) {
        this.weekdays = weekdays;
        return this;
    }

    public String getContextButtonTitle() {
        return this.contextButtonTitle;
    }

    public LanguageOptions setContextButtonTitle(String contextButtonTitle) {
        this.contextButtonTitle = contextButtonTitle;
        return this;
    }

    public List<String> getNumericSymbols() {
        return this.numericSymbols;
    }

    public LanguageOptions setNumericSymbols(List<String> numericSymbols) {
        this.numericSymbols = numericSymbols;
        return this;
    }

    public String getPrintChart() {
        return this.printChart;
    }

    public LanguageOptions setPrintChart(String printChart) {
        this.printChart = printChart;
        return this;
    }

    public String getRangeSelectorFrom() {
        return this.rangeSelectorFrom;
    }

    public LanguageOptions setRangeSelectorFrom(String rangeSelectorFrom) {
        this.rangeSelectorFrom = rangeSelectorFrom;
        return this;
    }

    public String getRangeSelectorTo() {
        return this.rangeSelectorTo;
    }

    public LanguageOptions setRangeSelectorTo(String rangeSelectorTo) {
        this.rangeSelectorTo = rangeSelectorTo;
        return this;
    }

    public String getRangeSelectorZoom() {
        return this.rangeSelectorZoom;
    }

    public LanguageOptions setRangeSelectorZoom(String rangeSelectorZoom) {
        this.rangeSelectorZoom = rangeSelectorZoom;
        return this;
    }
}

