/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.googlecode.wickedcharts.highcharts.options.Axis;
import com.googlecode.wickedcharts.highcharts.options.ChartOptions;
import com.googlecode.wickedcharts.highcharts.options.CreditOptions;
import com.googlecode.wickedcharts.highcharts.options.ExportingOptions;
import com.googlecode.wickedcharts.highcharts.options.Global;
import com.googlecode.wickedcharts.highcharts.options.IProcessableOption;
import com.googlecode.wickedcharts.highcharts.options.Labels;
import com.googlecode.wickedcharts.highcharts.options.Legend;
import com.googlecode.wickedcharts.highcharts.options.Loading;
import com.googlecode.wickedcharts.highcharts.options.Navigation;
import com.googlecode.wickedcharts.highcharts.options.Pane;
import com.googlecode.wickedcharts.highcharts.options.PlotOptionsChoice;
import com.googlecode.wickedcharts.highcharts.options.Title;
import com.googlecode.wickedcharts.highcharts.options.Tooltip;
import com.googlecode.wickedcharts.highcharts.options.color.ColorReference;
import com.googlecode.wickedcharts.highcharts.options.heatmap.ColorAxis;
import com.googlecode.wickedcharts.highcharts.options.series.Series;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Options
implements Serializable {
    @JsonIgnore
    private Map<String, List<IProcessableOption>> processingRegistry = new HashMap<String, List<IProcessableOption>>();
    private static final long serialVersionUID = 1L;
    private ColorAxis colorAxis;
    private ChartOptions chart;
    private List<Series<?>> series;
    private List<ColorReference> colors;
    private Title title;
    private Title subtitle;
    private List<Axis> xAxis;
    private List<Axis> yAxis;
    private Legend legend;
    private ExportingOptions exporting;
    private CreditOptions credits;
    private PlotOptionsChoice plotOptions;
    private Tooltip tooltip;
    private Global global;
    private Pane pane;
    @JsonIgnore
    private Labels labels;
    private Loading loading;
    private Navigation navigation;

    public Options() {
    }

    public Options(Options template) {
        this.copyFrom(template);
    }

    public Options addColor(ColorReference color) {
        if (this.colors == null) {
            this.colors = new ArrayList<ColorReference>();
        }
        this.colors.add(color);
        return this;
    }

    public Options addSeries(Series<?> series) {
        if (this.series == null) {
            this.series = new ArrayList();
        }
        this.series.add(series);
        return this;
    }

    public Options addxAxis(Axis xAxis) {
        if (this.getxAxis() == null) {
            this.setxAxis(new ArrayList<Axis>());
        }
        this.getxAxis().add(xAxis);
        return this;
    }

    public Options addyAxis(Axis yAxis) {
        if (this.getyAxis() == null) {
            this.setyAxis(new ArrayList<Axis>());
        }
        this.getyAxis().add(yAxis);
        return this;
    }

    public void clearSeries() {
        this.series = new ArrayList();
    }

    public void copyFrom(Options template) {
        this.chart = template.chart;
        this.colors = template.colors;
        this.credits = template.credits;
        this.exporting = template.exporting;
        this.global = template.global;
        this.labels = template.labels;
        this.legend = template.legend;
        this.loading = template.loading;
        this.navigation = template.navigation;
        this.pane = template.pane;
        this.plotOptions = template.plotOptions;
        this.processingRegistry = template.processingRegistry;
        this.series = template.series;
        this.subtitle = template.subtitle;
        this.title = template.title;
        this.tooltip = template.tooltip;
        this.setxAxis(template.getxAxis());
        this.setyAxis(template.getyAxis());
    }

    public ChartOptions getChart() {
        return this.chart;
    }

    public ColorAxis getColorAxis() {
        return this.colorAxis;
    }

    @JsonIgnore
    public ChartOptions getChartOptions() {
        return this.chart;
    }

    public List<? extends ColorReference> getColors() {
        return this.colors;
    }

    public CreditOptions getCreditOptions() {
        return this.credits;
    }

    public CreditOptions getCredits() {
        return this.credits;
    }

    public ExportingOptions getExporting() {
        return this.exporting;
    }

    public Global getGlobal() {
        return this.global;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public Loading getLoading() {
        return this.loading;
    }

    public List<IProcessableOption> getMarkedForProcessing(String processingKey) {
        List<IProcessableOption> result = this.processingRegistry.get(processingKey);
        if (result == null) {
            return new ArrayList<IProcessableOption>();
        }
        return result;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public Pane getPane() {
        return this.pane;
    }

    public PlotOptionsChoice getPlotOptions() {
        return this.plotOptions;
    }

    public List<? extends Series> getSeries() {
        return this.series;
    }

    @JsonIgnore
    public Axis getSingleXAxis() {
        if (this.getxAxis() == null) {
            return null;
        }
        return this.getxAxis().get(0);
    }

    @JsonIgnore
    public Axis getSingleYAxis() {
        if (this.getyAxis() == null) {
            return null;
        }
        return this.getyAxis().get(0);
    }

    public Title getSubtitle() {
        return this.subtitle;
    }

    public Title getTitle() {
        return this.title;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public List<Axis> getxAxis() {
        return this.xAxis;
    }

    public List<Axis> getyAxis() {
        return this.yAxis;
    }

    public void markForProcessing(IProcessableOption option) {
        List<IProcessableOption> list = this.processingRegistry.get(option.getProcessingKey());
        if (list == null) {
            list = new ArrayList<IProcessableOption>();
            this.processingRegistry.put(option.getProcessingKey(), list);
        }
        list.add(option);
    }

    public Options setChart(ChartOptions chart) {
        this.chart = chart;
        return this;
    }

    public Options setChartOptions(ChartOptions chart) {
        this.chart = chart;
        return this;
    }

    public Options setColors(ColorReference ... colors) {
        this.colors = Arrays.asList(colors);
        return this;
    }

    public Options setColors(List<ColorReference> colors) {
        this.colors = colors;
        return this;
    }

    public Options setCreditOptions(CreditOptions credits) {
        this.credits = credits;
        return this;
    }

    public Options setCredits(CreditOptions credits) {
        this.credits = credits;
        return this;
    }

    public Options setExporting(ExportingOptions exporting) {
        this.exporting = exporting;
        return this;
    }

    public Options setGlobal(Global global) {
        this.global = global;
        this.markForProcessing(global);
        return this;
    }

    public Options setLabels(Labels labels) {
        this.labels = labels;
        return this;
    }

    public Options setLegend(Legend legend) {
        this.legend = legend;
        return this;
    }

    public Options setLoading(Loading loading) {
        this.loading = loading;
        return this;
    }

    public Options setNavigation(Navigation navigation) {
        this.navigation = navigation;
        return this;
    }

    public Options setPane(Pane pane) {
        this.pane = pane;
        return this;
    }

    public Options setPlotOptions(PlotOptionsChoice plotOptions) {
        this.plotOptions = plotOptions;
        return this;
    }

    public Options setSeries(List<Series<?>> series) {
        this.series = series;
        return this;
    }

    public Options setSubtitle(Title subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public Options setTitle(Title title) {
        this.title = title;
        return this;
    }

    public Options setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public Options setxAxis(Axis xAxis) {
        this.xAxis = new ArrayList<Axis>();
        this.xAxis.add(xAxis);
        return this;
    }

    public Options setxAxis(List<Axis> xAxis) {
        this.xAxis = xAxis;
        return this;
    }

    public Options setyAxis(Axis yAxis) {
        this.yAxis = new ArrayList<Axis>();
        this.yAxis.add(yAxis);
        return this;
    }

    public Options setyAxis(List<Axis> yAxis) {
        this.yAxis = yAxis;
        return this;
    }

    public Options setColorAxis(ColorAxis colorAxis) {
        this.colorAxis = colorAxis;
        return this;
    }
}

