/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options.processing;

import com.googlecode.wickedcharts.highcharts.options.Global;
import com.googlecode.wickedcharts.highcharts.options.IProcessableOption;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.drilldown.DrilldownPoint;
import com.googlecode.wickedcharts.highcharts.options.interaction.InteractionFunction;
import com.googlecode.wickedcharts.highcharts.options.interaction.SelectionFunction;
import com.googlecode.wickedcharts.highcharts.options.livedata.LiveDataSeries;
import com.googlecode.wickedcharts.highcharts.options.processing.Feature;
import com.googlecode.wickedcharts.highcharts.options.processing.UnsupportedFeatureException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OptionsProcessorContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Options> drilldownOptions = new ArrayList<Options>();
    private final List<LiveDataSeries> liveDataSeries = new ArrayList<LiveDataSeries>();
    private final Global global;
    private final List<InteractionFunction> interactionFunctions = new ArrayList<InteractionFunction>();
    private final List<SelectionFunction> selectionFunctions = new ArrayList<SelectionFunction>();

    public OptionsProcessorContext(Options options) {
        this.collectDrilldownOptions(options);
        this.collectLiveDataSeries(options);
        this.collectInteractionFunctions(options);
        this.collectSelectionFunctions(options);
        this.global = options.getGlobal();
    }

    private void collectLiveDataSeries(Options options) {
        List<IProcessableOption> series = options.getMarkedForProcessing("LIVEUPDATE");
        this.liveDataSeries.addAll(series);
    }

    private void collectInteractionFunctions(Options options) {
        List<IProcessableOption> functions = options.getMarkedForProcessing("INTERACTION");
        this.interactionFunctions.addAll(functions);
    }

    private void collectSelectionFunctions(Options options) {
        List<IProcessableOption> functions = options.getMarkedForProcessing("SELECTION");
        this.selectionFunctions.addAll(functions);
    }

    private void collectDrilldownOptions(Options options) {
        List<IProcessableOption> drilldownPoints = options.getMarkedForProcessing("DRILLDOWN");
        for (DrilldownPoint drilldownPoint : drilldownPoints) {
            Options drilldownOptions = drilldownPoint.getDrilldownOptions();
            if (!this.getDrilldownOptions().contains(drilldownOptions)) {
                this.getDrilldownOptions().add(drilldownOptions);
                this.collectDrilldownOptions(drilldownOptions);
            }
            drilldownPoint.setDrilldownOptionsIndex(this.getDrilldownOptions().indexOf(drilldownOptions));
        }
    }

    public List<Options> getDrilldownOptions() {
        return this.drilldownOptions;
    }

    public List<LiveDataSeries> getLiveDataSeries() {
        return this.liveDataSeries;
    }

    public Global getGlobal() {
        return this.global;
    }

    public List<InteractionFunction> getInteractionFunctions() {
        return this.interactionFunctions;
    }

    public List<SelectionFunction> getSelectionFunctions() {
        return this.selectionFunctions;
    }

    public boolean containsFeature(Feature feature) {
        switch (feature) {
            case DRILLDOWN: {
                return !this.getDrilldownOptions().isEmpty();
            }
            case GLOBAL: {
                return this.getGlobal() != null;
            }
            case INTERACTION: {
                return !this.getInteractionFunctions().isEmpty();
            }
            case LIVEDATA: {
                return !this.getLiveDataSeries().isEmpty();
            }
            case SELECTION: {
                return !this.getSelectionFunctions().isEmpty();
            }
        }
        throw new UnsupportedFeatureException(feature);
    }
}

