/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6.highcharts.features.interaction;

import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.interaction.InteractionEvent;
import com.googlecode.wickedcharts.highcharts.options.interaction.InteractionFunction;
import com.googlecode.wickedcharts.highcharts.options.processing.IOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.wicket6.highcharts.Chart;
import com.googlecode.wickedcharts.wicket6.highcharts.features.interaction.InteractionBehavior;
import com.googlecode.wickedcharts.wicket6.highcharts.features.interaction.WicketInteractionEvent;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;

public class InteractionProcessor
implements IOptionsProcessor,
Serializable {
    private final Chart chart;

    public InteractionProcessor(Chart chart) {
        this.chart = chart;
    }

    public void processOptions(Options options, OptionsProcessorContext context) {
        List functions = context.getInteractionFunctions();
        for (final InteractionFunction function : functions) {
            InteractionBehavior interactionBehavior = new InteractionBehavior(){

                @Override
                public void onEvent(InteractionEvent event, AjaxRequestTarget target) {
                    WicketInteractionEvent wicketEvent = new WicketInteractionEvent(target, event);
                    function.onInteraction((InteractionEvent)wicketEvent);
                }
            };
            this.chart.add(new Behavior[]{interactionBehavior});
            String functionBody = interactionBehavior.getCallbackScript().toString();
            function.setFunction(functionBody);
        }
    }
}

