/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.kendo.datetime;

import com.googlecode.wicket.jquery.ui.kendo.datetime.DatePicker;
import com.googlecode.wicket.jquery.ui.kendo.datetime.TimePicker;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;

public class DateTimePicker
extends FormComponentPanel<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private DatePicker datePicker;
    private TimePicker timePicker;
    private final String datePattern;
    private final String timePattern;
    private IConverter<Date> converter;

    public DateTimePicker(String id) {
        this(id, "MM/dd/yyyy", "hh:mm aaa");
    }

    public DateTimePicker(String id, String datePattern, String timePattern) {
        super(id);
        this.datePattern = datePattern;
        this.timePattern = timePattern;
    }

    public DateTimePicker(String id, IModel<Date> date) {
        this(id, date, "MM/dd/yyyy", "hh:mm aaa");
    }

    public DateTimePicker(String id, IModel<Date> date, String datePattern, String timePattern) {
        super(id, date);
        this.datePattern = datePattern;
        this.timePattern = timePattern;
    }

    protected void convertInput() {
        IConverter<Date> converter = this.getConverter(Date.class);
        String dateInput = this.datePicker.getInput();
        String timeInput = this.timePicker.getInput();
        try {
            Date date = (Date)converter.convertToObject(String.format("%s %s", dateInput, timeInput), this.getLocale());
            this.setConvertedInput(date);
        }
        catch (ConversionException e) {
            ValidationError error = new ValidationError();
            error.addMessageKey("DateTimePicker.ConversionError");
            error.setVariable("date", (Object)dateInput);
            error.setVariable("time", (Object)timeInput);
            this.error((IValidationError)error);
        }
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (Date.class.isAssignableFrom(type)) {
            if (this.converter == null) {
                this.converter = this.newDateConverter();
            }
            return this.converter;
        }
        return super.getConverter(type);
    }

    private IConverter<Date> newDateConverter() {
        return new DateConverter(){
            private static final long serialVersionUID = 1L;

            public DateFormat getDateFormat(Locale locale) {
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                return new SimpleDateFormat(DateTimePicker.this.getTextFormat(), locale);
            }
        };
    }

    protected DatePicker newDatePicker(String id, IModel<Date> model, String datePattern) {
        return new DatePicker(id, model, datePattern);
    }

    protected TimePicker newTimePicker(String id, IModel<Date> model, String timePattern) {
        return new TimePicker(id, model, timePattern);
    }

    public final String getDatePattern() {
        return this.datePattern;
    }

    public final String getTimePattern() {
        return this.timePattern;
    }

    public final String getTextFormat() {
        return String.format("%s %s", this.getDatePattern(), this.getTimePattern());
    }

    public String getModelObjectAsString() {
        Date date = (Date)this.getModelObject();
        if (date != null) {
            return new SimpleDateFormat(this.getTextFormat()).format(date);
        }
        return "";
    }

    protected void onInitialize() {
        super.onInitialize();
        this.datePicker = this.newDatePicker("datepicker", (IModel<Date>)this.getModel(), this.getDatePattern());
        this.timePicker = this.newTimePicker("timepicker", (IModel<Date>)this.getModel(), this.getTimePattern());
        this.add(new Component[]{this.datePicker});
        this.add(new Component[]{this.timePicker});
    }
}

