/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.calendar;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.calendar.CalendarBehavior;
import com.googlecode.wicket.jquery.ui.calendar.CalendarModel;
import com.googlecode.wicket.jquery.ui.calendar.CalendarModelBehavior;
import com.googlecode.wicket.jquery.ui.calendar.CalendarView;
import com.googlecode.wicket.jquery.ui.calendar.ICalendarListener;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;

public class Calendar
extends JQueryContainer
implements ICalendarListener {
    private static final long serialVersionUID = 1L;
    private final Options options;
    private Map<CharSequence, String> gcals;
    private CalendarModelBehavior modelBehavior;

    public Calendar(String id, Options options) {
        super(id);
        this.options = options;
    }

    public Calendar(String id, CalendarModel model) {
        this(id, model, new Options());
    }

    public Calendar(String id, CalendarModel model, Options options) {
        super(id, (IModel)model);
        this.options = options;
    }

    public CalendarModel getModel() {
        return (CalendarModel)this.getDefaultModel();
    }

    public void addFeed(CharSequence gcal) {
        this.addFeed(gcal, "");
    }

    public void addFeed(CharSequence gcal, String className) {
        if (this.gcals == null) {
            this.gcals = new HashMap<CharSequence, String>();
        }
        this.gcals.put(gcal, className);
    }

    public void refresh(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("jQuery('%s').fullCalendar('refetchEvents');", IJQueryWidget.JQueryWidget.getSelector((Component)this)));
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isEventDropEnabled() {
        return false;
    }

    @Override
    public boolean isEventResizeEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.modelBehavior = new CalendarModelBehavior(this.getModel());
        behaviorArray[0] = this.modelBehavior;
        this.add(behaviorArray);
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    @Override
    public void onSelect(AjaxRequestTarget target, CalendarView view, Date start, Date end, boolean allDay) {
    }

    @Override
    public void onDayClick(AjaxRequestTarget target, CalendarView view, Date date) {
    }

    @Override
    public void onEventClick(AjaxRequestTarget target, CalendarView view, int eventId) {
    }

    @Override
    public void onEventDrop(AjaxRequestTarget target, int eventId, long delta, boolean allDay) {
    }

    @Override
    public void onEventResize(AjaxRequestTarget target, int eventId, long delta) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new CalendarBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isEditable() {
                return Calendar.this.isEditable();
            }

            @Override
            public boolean isSelectable() {
                return Calendar.this.isSelectable();
            }

            @Override
            public boolean isEventDropEnabled() {
                return Calendar.this.isEventDropEnabled();
            }

            @Override
            public boolean isEventResizeEnabled() {
                return Calendar.this.isEventResizeEnabled();
            }

            @Override
            public void onConfigure(Component component) {
                super.onConfigure(component);
                Calendar.this.onConfigure(this);
                StringBuilder sourceBuilder = new StringBuilder();
                sourceBuilder.append("'").append(Calendar.this.modelBehavior.getCallbackUrl()).append("'");
                if (Calendar.this.gcals != null) {
                    for (Map.Entry gcal : Calendar.this.gcals.entrySet()) {
                        sourceBuilder.append(", ");
                        sourceBuilder.append("jQuery.fullCalendar.gcalFeed('").append((CharSequence)gcal.getKey()).append("', { className: '").append((String)gcal.getValue()).append("' })");
                    }
                }
                this.setOption("eventSources", (Serializable)((Object)String.format("[%s]", sourceBuilder.toString())));
            }

            @Override
            public void onSelect(AjaxRequestTarget target, CalendarView view, Date start, Date end, boolean allDay) {
                Calendar.this.onSelect(target, view, start, end, allDay);
            }

            @Override
            public void onDayClick(AjaxRequestTarget target, CalendarView view, Date date) {
                Calendar.this.onDayClick(target, view, date);
            }

            @Override
            public void onEventClick(AjaxRequestTarget target, CalendarView view, int eventId) {
                Calendar.this.onEventClick(target, view, eventId);
            }

            @Override
            public void onEventDrop(AjaxRequestTarget target, int eventId, long delta, boolean allDay) {
                Calendar.this.onEventDrop(target, eventId, delta, allDay);
            }

            @Override
            public void onEventResize(AjaxRequestTarget target, int eventId, long delta) {
                Calendar.this.onEventResize(target, eventId, delta);
            }
        };
    }
}

