/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.calendar;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.calendar.CalendarView;
import com.googlecode.wicket.jquery.ui.calendar.ICalendarListener;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.time.Duration;

public abstract class CalendarBehavior
extends JQueryBehavior
implements IJQueryAjaxAware,
ICalendarListener {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "fullCalendar";
    private JQueryAjaxBehavior onDayClickBehavior;
    private JQueryAjaxBehavior onSelectBehavior = null;
    private JQueryAjaxBehavior onEventClickBehavior;
    private JQueryAjaxBehavior onEventDropBehavior = null;
    private JQueryAjaxBehavior onEventResizeBehavior = null;

    public CalendarBehavior(String selector) {
        this(selector, new Options());
    }

    public CalendarBehavior(String selector, Options options) {
        super(selector, METHOD, options);
        this.add((ResourceReference)new CssResourceReference(CalendarBehavior.class, "fullcalendar.css"));
        this.add((ResourceReference)new JavaScriptResourceReference(CalendarBehavior.class, "fullcalendar.min.js"));
        this.add((ResourceReference)new JavaScriptResourceReference(CalendarBehavior.class, "gcal.js"));
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.isEditable()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.onDayClickBehavior = this.newOnDayClickBehavior();
            behaviorArray[0] = this.onDayClickBehavior;
            component.add(behaviorArray);
            Behavior[] behaviorArray2 = new Behavior[1];
            this.onEventClickBehavior = this.newOnEventClickBehavior();
            behaviorArray2[0] = this.onEventClickBehavior;
            component.add(behaviorArray2);
        }
        if (this.isSelectable()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.onSelectBehavior = this.newOnSelectBehavior();
            behaviorArray[0] = this.onSelectBehavior;
            component.add(behaviorArray);
        }
        if (this.isEventDropEnabled()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.onEventDropBehavior = this.newOnEventDropBehavior();
            behaviorArray[0] = this.onEventDropBehavior;
            component.add(behaviorArray);
        }
        if (this.isEventResizeEnabled()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.onEventResizeBehavior = this.newOnEventResizeBehavior();
            behaviorArray[0] = this.onEventResizeBehavior;
            component.add(behaviorArray);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
        response.renderJavaScript((CharSequence)("jQuery(function(){ jQuery('<img />').attr('src', '" + ((Object)RequestCycle.get().urlFor((IRequestHandler)handler)).toString() + "')" + ".ajaxStart(function() { jQuery(this).show(); })" + ".ajaxStop(function() { jQuery(this).hide(); })" + ".appendTo('.fc-header-center');" + " });"), this.getClass().getName());
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.options.set("editable", (Serializable)Boolean.valueOf(this.isEditable()));
        this.options.set("selectable", (Serializable)Boolean.valueOf(this.isSelectable()));
        this.options.set("selectHelper", (Serializable)Boolean.valueOf(this.isSelectable()));
        this.options.set("disableDragging", (Serializable)Boolean.valueOf(!this.isEventDropEnabled()));
        this.options.set("disableResizing", (Serializable)Boolean.valueOf(!this.isEventResizeEnabled()));
        if (this.isEditable()) {
            this.setOption("dayClick", (Serializable)((Object)this.onDayClickBehavior.getCallbackFunction()));
            this.setOption("eventClick", (Serializable)((Object)this.onEventClickBehavior.getCallbackFunction()));
        }
        if (this.onSelectBehavior != null) {
            this.setOption("select", (Serializable)((Object)this.onSelectBehavior.getCallbackFunction()));
        }
        if (this.onEventDropBehavior != null) {
            this.setOption("eventDrop", (Serializable)((Object)this.onEventDropBehavior.getCallbackFunction()));
        }
        if (this.onEventResizeBehavior != null) {
            this.setOption("eventResize", (Serializable)((Object)this.onEventResizeBehavior.getCallbackFunction()));
        }
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DayClickEvent) {
            DayClickEvent dayClickEvent = (DayClickEvent)event;
            this.onDayClick(target, dayClickEvent.getView(), dayClickEvent.getDate());
        } else if (event instanceof SelectEvent) {
            SelectEvent selectEvent = (SelectEvent)event;
            this.onSelect(target, selectEvent.getView(), selectEvent.getStart(), selectEvent.getEnd(), selectEvent.isAllDay());
        } else if (event instanceof ClickEvent) {
            ClickEvent clickEvent = (ClickEvent)event;
            this.onEventClick(target, clickEvent.getView(), clickEvent.getEventId());
        } else if (event instanceof DropEvent) {
            DropEvent dropEvent = (DropEvent)event;
            this.onEventDrop(target, dropEvent.getEventId(), dropEvent.getDelta(), dropEvent.isAllDay());
        } else if (event instanceof ResizeEvent) {
            ResizeEvent resizeEvent = (ResizeEvent)event;
            this.onEventResize(target, resizeEvent.getEventId(), resizeEvent.getDelta());
        }
    }

    protected JQueryAjaxBehavior newOnDayClickBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            public String getCallbackFunction() {
                return "function(date, allDay, jsEvent, view) { " + this.getCallbackScript() + " }";
            }

            public CharSequence getCallbackScript() {
                return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&date=' + date.getTime() + '&viewName=' + view.name");
            }

            protected JQueryEvent newEvent() {
                return new DayClickEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnSelectBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            public String getCallbackFunction() {
                return "function(startDate, endDate, allDay, jsEvent, view) { " + this.getCallbackScript() + " }";
            }

            public CharSequence getCallbackScript() {
                return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&start=' + startDate.getTime() + '&end=' + endDate.getTime() + '&allDay=' + allDay + '&viewName=' + view.name");
            }

            protected JQueryEvent newEvent() {
                return new SelectEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnEventClickBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            public String getCallbackFunction() {
                return "function(event, jsEvent, view) { " + this.getCallbackScript() + " }";
            }

            public CharSequence getCallbackScript() {
                return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&eventId=' + event.id + '&viewName=' + view.name");
            }

            protected JQueryEvent newEvent() {
                return new ClickEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnEventDropBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            public String getCallbackFunction() {
                return "function(event, dayDelta, minuteDelta, allDay, revertFunc, jsEvent, ui, view) { " + this.getCallbackScript() + " }";
            }

            public CharSequence getCallbackScript() {
                return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&eventId=' + event.id + '&dayDelta=' + dayDelta + '&minuteDelta=' + minuteDelta + '&allDay=' + allDay");
            }

            protected JQueryEvent newEvent() {
                return new DropEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnEventResizeBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            public String getCallbackFunction() {
                return "function(event, dayDelta, minuteDelta, revertFunc, jsEvent, ui, view) { " + this.getCallbackScript() + " }";
            }

            public CharSequence getCallbackScript() {
                return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&eventId=' + event.id + '&dayDelta=' + dayDelta + '&minuteDelta=' + minuteDelta");
            }

            protected JQueryEvent newEvent() {
                return new ResizeEvent();
            }
        };
    }

    protected static class ResizeEvent
    extends DeltaEvent {
        protected ResizeEvent() {
        }
    }

    protected static class DropEvent
    extends DeltaEvent {
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();

        public boolean isAllDay() {
            return this.isAllDay;
        }
    }

    protected static abstract class DeltaEvent
    extends JQueryEvent {
        private final int eventId = RequestCycleUtils.getQueryParameterValue((String)"eventId").toInt();
        private long delta;

        public DeltaEvent() {
            int dayDelta = RequestCycleUtils.getQueryParameterValue((String)"dayDelta").toInt();
            int minuteDelta = RequestCycleUtils.getQueryParameterValue((String)"minuteDelta").toInt();
            this.delta = (long)dayDelta * Duration.ONE_DAY.getMilliseconds() + (long)minuteDelta * Duration.ONE_MINUTE.getMilliseconds();
        }

        public int getEventId() {
            return this.eventId;
        }

        public long getDelta() {
            return this.delta;
        }
    }

    protected static class ClickEvent
    extends JQueryEvent {
        private final int eventId = RequestCycleUtils.getQueryParameterValue((String)"eventId").toInt();
        private final String viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();

        public int getEventId() {
            return this.eventId;
        }

        public CalendarView getView() {
            return CalendarView.valueOf(this.viewName);
        }
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final Date start;
        private final Date end;
        private final boolean isAllDay;
        private final String viewName;

        public SelectEvent() {
            long start = RequestCycleUtils.getQueryParameterValue((String)"start").toLong();
            this.start = new Date(start);
            long end = RequestCycleUtils.getQueryParameterValue((String)"end").toLong();
            this.end = new Date(end);
            this.isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();
            this.viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();
        }

        public Date getStart() {
            return this.start;
        }

        public Date getEnd() {
            return this.end;
        }

        public boolean isAllDay() {
            return this.isAllDay;
        }

        public CalendarView getView() {
            return CalendarView.valueOf(this.viewName);
        }
    }

    protected static class DayClickEvent
    extends JQueryEvent {
        private final Date day;
        private final String viewName;

        public DayClickEvent() {
            long date = RequestCycleUtils.getQueryParameterValue((String)"date").toLong();
            this.day = new Date(date);
            this.viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();
        }

        public Date getDate() {
            return this.day;
        }

        public CalendarView getView() {
            return CalendarView.valueOf(this.viewName);
        }
    }
}

