/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.calendar;

import com.googlecode.wicket.jquery.ui.calendar.CalendarEvent;
import com.googlecode.wicket.jquery.ui.calendar.CalendarModel;
import com.googlecode.wicket.jquery.ui.calendar.ICalendarVisitor;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CalendarModelBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CalendarModelBehavior.class);
    private CalendarModel model;

    public CalendarModelBehavior(CalendarModel model) {
        this.model = model;
    }

    public void onRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        long start = parameters.getParameterValue("start").toLong(0L);
        long end = parameters.getParameterValue("end").toLong(0L);
        if (this.model != null) {
            this.model.setStart(new Date(start * 1000L));
            this.model.setEnd(new Date(end * 1000L));
        }
        IRequestHandler handler = this.newRequestHandler();
        requestCycle.scheduleRequestHandlerAfterCurrent(handler);
    }

    private IRequestHandler newRequestHandler() {
        return new IRequestHandler(){

            public void respond(IRequestCycle requestCycle) {
                List list;
                WebResponse response = (WebResponse)requestCycle.getResponse();
                String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
                response.setContentType("text/json; charset=" + encoding);
                response.disableCaching();
                if (CalendarModelBehavior.this.model != null && (list = (List)CalendarModelBehavior.this.model.getObject()) != null) {
                    StringBuilder builder = new StringBuilder("[ ");
                    int count = 0;
                    for (CalendarEvent event : list) {
                        if (CalendarModelBehavior.this.model instanceof ICalendarVisitor) {
                            event.accept((ICalendarVisitor)((Object)CalendarModelBehavior.this.model));
                        }
                        if (count++ > 0) {
                            builder.append(", ");
                        }
                        builder.append(event.toString());
                    }
                    builder.append(" ]");
                    LOG.debug(builder.toString());
                    response.write((CharSequence)builder);
                }
            }

            public void detach(IRequestCycle requestCycle) {
            }
        };
    }
}

