/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.googlecode.wicket.kendo.ui;

import java.util.Locale;

/**
 * Provides all Kendo UI supported culture identifiers
 * 
 * @author Sebastien Briquet - sebfz1
 */
public enum KendoCulture
{
	AA_DJ("aa-DJ"), // lf
	AA_ER("aa-ER"), // lf
	AA_ET("aa-ET"), // lf
	AA("aa"), // lf
	AF_NA("af-NA"), // lf
	AF_ZA("af-ZA"), // lf
	AF("af"), // lf
	AGQ_CM("agq-CM"), // lf
	AGQ("agq"), // lf
	AK_GH("ak-GH"), // lf
	AK("ak"), // lf
	AM_ET("am-ET"), // lf
	AM("am"), // lf
	AR_001("ar-001"), // lf
	AR_AE("ar-AE"), // lf
	AR_BH("ar-BH"), // lf
	AR_DJ("ar-DJ"), // lf
	AR_DZ("ar-DZ"), // lf
	AR_EG("ar-EG"), // lf
	AR_ER("ar-ER"), // lf
	AR_IL("ar-IL"), // lf
	AR_IQ("ar-IQ"), // lf
	AR_JO("ar-JO"), // lf
	AR_KM("ar-KM"), // lf
	AR_KW("ar-KW"), // lf
	AR_LB("ar-LB"), // lf
	AR_LY("ar-LY"), // lf
	AR_MA("ar-MA"), // lf
	AR_MR("ar-MR"), // lf
	AR_OM("ar-OM"), // lf
	AR_PS("ar-PS"), // lf
	AR_QA("ar-QA"), // lf
	AR_SA("ar-SA"), // lf
	AR_SD("ar-SD"), // lf
	AR_SO("ar-SO"), // lf
	AR_SS("ar-SS"), // lf
	AR_SY("ar-SY"), // lf
	AR_TD("ar-TD"), // lf
	AR_TN("ar-TN"), // lf
	AR_YE("ar-YE"), // lf
	AR("ar"), // lf
	ARN_CL("arn-CL"), // lf
	ARN("arn"), // lf
	AS_IN("as-IN"), // lf
	AS("as"), // lf
	ASA_TZ("asa-TZ"), // lf
	ASA("asa"), // lf
	AST_ES("ast-ES"), // lf
	AST("ast"), // lf
	AZ_CYRL_AZ("az-Cyrl-AZ"), // lf
	AZ_CYRL("az-Cyrl"), // lf
	AZ_LATN_AZ("az-Latn-AZ"), // lf
	AZ_LATN("az-Latn"), // lf
	AZ("az"), // lf
	BA_RU("ba-RU"), // lf
	BA("ba"), // lf
	BAS_CM("bas-CM"), // lf
	BAS("bas"), // lf
	BE_BY("be-BY"), // lf
	BE("be"), // lf
	BEM_ZM("bem-ZM"), // lf
	BEM("bem"), // lf
	BEZ_TZ("bez-TZ"), // lf
	BEZ("bez"), // lf
	BG_BG("bg-BG"), // lf
	BG("bg"), // lf
	BIN_NG("bin-NG"), // lf
	BIN("bin"), // lf
	BM_LATN_ML("bm-Latn-ML"), // lf
	BM_LATN("bm-Latn"), // lf
	BM("bm"), // lf
	BN_BD("bn-BD"), // lf
	BN_IN("bn-IN"), // lf
	BN("bn"), // lf
	BO_CN("bo-CN"), // lf
	BO_IN("bo-IN"), // lf
	BO("bo"), // lf
	BR_FR("br-FR"), // lf
	BR("br"), // lf
	BRX_IN("brx-IN"), // lf
	BRX("brx"), // lf
	BS_CYRL_BA("bs-Cyrl-BA"), // lf
	BS_CYRL("bs-Cyrl"), // lf
	BS_LATN_BA("bs-Latn-BA"), // lf
	BS_LATN("bs-Latn"), // lf
	BS("bs"), // lf
	BYN_ER("byn-ER"), // lf
	BYN("byn"), // lf
	CA_AD("ca-AD"), // lf
	CA_ES_VALENCIA("ca-ES-valencia"), // lf
	CA_ES("ca-ES"), // lf
	CA_FR("ca-FR"), // lf
	CA_IT("ca-IT"), // lf
	CA("ca"), // lf
	CE_RU("ce-RU"), // lf
	CE("ce"), // lf
	CGG_UG("cgg-UG"), // lf
	CGG("cgg"), // lf
	CHR_CHER_US("chr-Cher-US"), // lf
	CHR_CHER("chr-Cher"), // lf
	CHR("chr"), // lf
	CO_FR("co-FR"), // lf
	CO("co"), // lf
	CS_CZ("cs-CZ"), // lf
	CS("cs"), // lf
	CU_RU("cu-RU"), // lf
	CU("cu"), // lf
	CY_GB("cy-GB"), // lf
	CY("cy"), // lf
	DA_DK("da-DK"), // lf
	DA_GL("da-GL"), // lf
	DA("da"), // lf
	DAV_KE("dav-KE"), // lf
	DAV("dav"), // lf
	DE_AT("de-AT"), // lf
	DE_BE("de-BE"), // lf
	DE_CH("de-CH"), // lf
	DE_DE("de-DE"), // lf
	DE_IT("de-IT"), // lf
	DE_LI("de-LI"), // lf
	DE_LU("de-LU"), // lf
	DE("de"), // lf
	DJE_NE("dje-NE"), // lf
	DJE("dje"), // lf
	DSB_DE("dsb-DE"), // lf
	DSB("dsb"), // lf
	DUA_CM("dua-CM"), // lf
	DUA("dua"), // lf
	DV_MV("dv-MV"), // lf
	DV("dv"), // lf
	DYO_SN("dyo-SN"), // lf
	DYO("dyo"), // lf
	DZ_BT("dz-BT"), // lf
	DZ("dz"), // lf
	EBU_KE("ebu-KE"), // lf
	EBU("ebu"), // lf
	EE_GH("ee-GH"), // lf
	EE_TG("ee-TG"), // lf
	EE("ee"), // lf
	EL_CY("el-CY"), // lf
	EL_GR("el-GR"), // lf
	EL("el"), // lf
	EN_001("en-001"), // lf
	EN_029("en-029"), // lf
	EN_150("en-150"), // lf
	EN_AG("en-AG"), // lf
	EN_AI("en-AI"), // lf
	EN_AS("en-AS"), // lf
	EN_AT("en-AT"), // lf
	EN_AU("en-AU"), // lf
	EN_BB("en-BB"), // lf
	EN_BE("en-BE"), // lf
	EN_BI("en-BI"), // lf
	EN_BM("en-BM"), // lf
	EN_BS("en-BS"), // lf
	EN_BW("en-BW"), // lf
	EN_BZ("en-BZ"), // lf
	EN_CA("en-CA"), // lf
	EN_CC("en-CC"), // lf
	EN_CH("en-CH"), // lf
	EN_CK("en-CK"), // lf
	EN_CM("en-CM"), // lf
	EN_CX("en-CX"), // lf
	EN_CY("en-CY"), // lf
	EN_DE("en-DE"), // lf
	EN_DK("en-DK"), // lf
	EN_DM("en-DM"), // lf
	EN_ER("en-ER"), // lf
	EN_FI("en-FI"), // lf
	EN_FJ("en-FJ"), // lf
	EN_FK("en-FK"), // lf
	EN_FM("en-FM"), // lf
	EN_GB("en-GB"), // lf
	EN_GD("en-GD"), // lf
	EN_GG("en-GG"), // lf
	EN_GH("en-GH"), // lf
	EN_GI("en-GI"), // lf
	EN_GM("en-GM"), // lf
	EN_GU("en-GU"), // lf
	EN_GY("en-GY"), // lf
	EN_HK("en-HK"), // lf
	EN_ID("en-ID"), // lf
	EN_IE("en-IE"), // lf
	EN_IL("en-IL"), // lf
	EN_IM("en-IM"), // lf
	EN_IN("en-IN"), // lf
	EN_IO("en-IO"), // lf
	EN_JE("en-JE"), // lf
	EN_JM("en-JM"), // lf
	EN_KE("en-KE"), // lf
	EN_KI("en-KI"), // lf
	EN_KN("en-KN"), // lf
	EN_KY("en-KY"), // lf
	EN_LC("en-LC"), // lf
	EN_LR("en-LR"), // lf
	EN_LS("en-LS"), // lf
	EN_MG("en-MG"), // lf
	EN_MH("en-MH"), // lf
	EN_MO("en-MO"), // lf
	EN_MP("en-MP"), // lf
	EN_MS("en-MS"), // lf
	EN_MT("en-MT"), // lf
	EN_MU("en-MU"), // lf
	EN_MW("en-MW"), // lf
	EN_MY("en-MY"), // lf
	EN_NA("en-NA"), // lf
	EN_NF("en-NF"), // lf
	EN_NG("en-NG"), // lf
	EN_NL("en-NL"), // lf
	EN_NR("en-NR"), // lf
	EN_NU("en-NU"), // lf
	EN_NZ("en-NZ"), // lf
	EN_PG("en-PG"), // lf
	EN_PH("en-PH"), // lf
	EN_PK("en-PK"), // lf
	EN_PN("en-PN"), // lf
	EN_PR("en-PR"), // lf
	EN_PW("en-PW"), // lf
	EN_RW("en-RW"), // lf
	EN_SB("en-SB"), // lf
	EN_SC("en-SC"), // lf
	EN_SD("en-SD"), // lf
	EN_SE("en-SE"), // lf
	EN_SG("en-SG"), // lf
	EN_SH("en-SH"), // lf
	EN_SI("en-SI"), // lf
	EN_SL("en-SL"), // lf
	EN_SS("en-SS"), // lf
	EN_SX("en-SX"), // lf
	EN_SZ("en-SZ"), // lf
	EN_TC("en-TC"), // lf
	EN_TK("en-TK"), // lf
	EN_TO("en-TO"), // lf
	EN_TT("en-TT"), // lf
	EN_TV("en-TV"), // lf
	EN_TZ("en-TZ"), // lf
	EN_UG("en-UG"), // lf
	EN_UM("en-UM"), // lf
	EN_US("en-US"), // lf
	EN_VC("en-VC"), // lf
	EN_VG("en-VG"), // lf
	EN_VI("en-VI"), // lf
	EN_VU("en-VU"), // lf
	EN_WS("en-WS"), // lf
	EN_ZA("en-ZA"), // lf
	EN_ZM("en-ZM"), // lf
	EN_ZW("en-ZW"), // lf
	EN("en"), // lf
	EO_001("eo-001"), // lf
	EO("eo"), // lf
	ES_419("es-419"), // lf
	ES_AR("es-AR"), // lf
	ES_BO("es-BO"), // lf
	ES_BR("es-BR"), // lf
	ES_BZ("es-BZ"), // lf
	ES_CL("es-CL"), // lf
	ES_CO("es-CO"), // lf
	ES_CR("es-CR"), // lf
	ES_CU("es-CU"), // lf
	ES_DO("es-DO"), // lf
	ES_EC("es-EC"), // lf
	ES_ES("es-ES"), // lf
	ES_GQ("es-GQ"), // lf
	ES_GT("es-GT"), // lf
	ES_HN("es-HN"), // lf
	ES_MX("es-MX"), // lf
	ES_NI("es-NI"), // lf
	ES_PA("es-PA"), // lf
	ES_PE("es-PE"), // lf
	ES_PH("es-PH"), // lf
	ES_PR("es-PR"), // lf
	ES_PY("es-PY"), // lf
	ES_SV("es-SV"), // lf
	ES_US("es-US"), // lf
	ES_UY("es-UY"), // lf
	ES_VE("es-VE"), // lf
	ES("es"), // lf
	ET_EE("et-EE"), // lf
	ET("et"), // lf
	EU_ES("eu-ES"), // lf
	EU("eu"), // lf
	EWO_CM("ewo-CM"), // lf
	EWO("ewo"), // lf
	FA_IR("fa-IR"), // lf
	FA("fa"), // lf
	FF_CM("ff-CM"), // lf
	FF_GN("ff-GN"), // lf
	FF_LATN_BF("ff-Latn-BF"), // lf
	FF_LATN_CM("ff-Latn-CM"), // lf
	FF_LATN_GH("ff-Latn-GH"), // lf
	FF_LATN_GM("ff-Latn-GM"), // lf
	FF_LATN_GN("ff-Latn-GN"), // lf
	FF_LATN_GW("ff-Latn-GW"), // lf
	FF_LATN_LR("ff-Latn-LR"), // lf
	FF_LATN_MR("ff-Latn-MR"), // lf
	FF_LATN_NE("ff-Latn-NE"), // lf
	FF_LATN_NG("ff-Latn-NG"), // lf
	FF_LATN_SL("ff-Latn-SL"), // lf
	FF_LATN_SN("ff-Latn-SN"), // lf
	FF_LATN("ff-Latn"), // lf
	FF_MR("ff-MR"), // lf
	FF_NG("ff-NG"), // lf
	FF("ff"), // lf
	FI_FI("fi-FI"), // lf
	FI("fi"), // lf
	FIL_PH("fil-PH"), // lf
	FIL("fil"), // lf
	FO_DK("fo-DK"), // lf
	FO_FO("fo-FO"), // lf
	FO("fo"), // lf
	FR_029("fr-029"), // lf
	FR_BE("fr-BE"), // lf
	FR_BF("fr-BF"), // lf
	FR_BI("fr-BI"), // lf
	FR_BJ("fr-BJ"), // lf
	FR_BL("fr-BL"), // lf
	FR_CA("fr-CA"), // lf
	FR_CD("fr-CD"), // lf
	FR_CF("fr-CF"), // lf
	FR_CG("fr-CG"), // lf
	FR_CH("fr-CH"), // lf
	FR_CI("fr-CI"), // lf
	FR_CM("fr-CM"), // lf
	FR_DJ("fr-DJ"), // lf
	FR_DZ("fr-DZ"), // lf
	FR_FR("fr-FR"), // lf
	FR_GA("fr-GA"), // lf
	FR_GF("fr-GF"), // lf
	FR_GN("fr-GN"), // lf
	FR_GP("fr-GP"), // lf
	FR_GQ("fr-GQ"), // lf
	FR_HT("fr-HT"), // lf
	FR_KM("fr-KM"), // lf
	FR_LU("fr-LU"), // lf
	FR_MA("fr-MA"), // lf
	FR_MC("fr-MC"), // lf
	FR_MF("fr-MF"), // lf
	FR_MG("fr-MG"), // lf
	FR_ML("fr-ML"), // lf
	FR_MQ("fr-MQ"), // lf
	FR_MR("fr-MR"), // lf
	FR_MU("fr-MU"), // lf
	FR_NC("fr-NC"), // lf
	FR_NE("fr-NE"), // lf
	FR_PF("fr-PF"), // lf
	FR_PM("fr-PM"), // lf
	FR_RE("fr-RE"), // lf
	FR_RW("fr-RW"), // lf
	FR_SC("fr-SC"), // lf
	FR_SN("fr-SN"), // lf
	FR_SY("fr-SY"), // lf
	FR_TD("fr-TD"), // lf
	FR_TG("fr-TG"), // lf
	FR_TN("fr-TN"), // lf
	FR_VU("fr-VU"), // lf
	FR_WF("fr-WF"), // lf
	FR_YT("fr-YT"), // lf
	FR("fr"), // lf
	FUR_IT("fur-IT"), // lf
	FUR("fur"), // lf
	FY_NL("fy-NL"), // lf
	FY("fy"), // lf
	GA_IE("ga-IE"), // lf
	GA("ga"), // lf
	GD_GB("gd-GB"), // lf
	GD("gd"), // lf
	GL_ES("gl-ES"), // lf
	GL("gl"), // lf
	GN_PY("gn-PY"), // lf
	GN("gn"), // lf
	GSW_CH("gsw-CH"), // lf
	GSW_FR("gsw-FR"), // lf
	GSW_LI("gsw-LI"), // lf
	GSW("gsw"), // lf
	GU_IN("gu-IN"), // lf
	GU("gu"), // lf
	GUZ_KE("guz-KE"), // lf
	GUZ("guz"), // lf
	GV_IM("gv-IM"), // lf
	GV("gv"), // lf
	HA_LATN_GH("ha-Latn-GH"), // lf
	HA_LATN_NE("ha-Latn-NE"), // lf
	HA_LATN_NG("ha-Latn-NG"), // lf
	HA_LATN("ha-Latn"), // lf
	HA("ha"), // lf
	HAW_US("haw-US"), // lf
	HAW("haw"), // lf
	HE_IL("he-IL"), // lf
	HE("he"), // lf
	HI_IN("hi-IN"), // lf
	HI("hi"), // lf
	HR_BA("hr-BA"), // lf
	HR_HR("hr-HR"), // lf
	HR("hr"), // lf
	HSB_DE("hsb-DE"), // lf
	HSB("hsb"), // lf
	HU_HU("hu-HU"), // lf
	HU("hu"), // lf
	HY_AM("hy-AM"), // lf
	HY("hy"), // lf
	IA_001("ia-001"), // lf
	IA_FR("ia-FR"), // lf
	IA("ia"), // lf
	IBB_NG("ibb-NG"), // lf
	IBB("ibb"), // lf
	ID_ID("id-ID"), // lf
	ID("id"), // lf
	IG_NG("ig-NG"), // lf
	IG("ig"), // lf
	II_CN("ii-CN"), // lf
	II("ii"), // lf
	IS_IS("is-IS"), // lf
	IS("is"), // lf
	IT_CH("it-CH"), // lf
	IT_IT("it-IT"), // lf
	IT_SM("it-SM"), // lf
	IT_VA("it-VA"), // lf
	IT("it"), // lf
	IU_CANS_CA("iu-Cans-CA"), // lf
	IU_CANS("iu-Cans"), // lf
	IU_LATN_CA("iu-Latn-CA"), // lf
	IU_LATN("iu-Latn"), // lf
	IU("iu"), // lf
	JA_JP("ja-JP"), // lf
	JA("ja"), // lf
	JGO_CM("jgo-CM"), // lf
	JGO("jgo"), // lf
	JMC_TZ("jmc-TZ"), // lf
	JMC("jmc"), // lf
	JV_JAVA_ID("jv-Java-ID"), // lf
	JV_JAVA("jv-Java"), // lf
	JV_LATN_ID("jv-Latn-ID"), // lf
	JV_LATN("jv-Latn"), // lf
	JV("jv"), // lf
	KA_GE("ka-GE"), // lf
	KA("ka"), // lf
	KAB_DZ("kab-DZ"), // lf
	KAB("kab"), // lf
	KAM_KE("kam-KE"), // lf
	KAM("kam"), // lf
	KDE_TZ("kde-TZ"), // lf
	KDE("kde"), // lf
	KEA_CV("kea-CV"), // lf
	KEA("kea"), // lf
	KHQ_ML("khq-ML"), // lf
	KHQ("khq"), // lf
	KI_KE("ki-KE"), // lf
	KI("ki"), // lf
	KK_KZ("kk-KZ"), // lf
	KK("kk"), // lf
	KKJ_CM("kkj-CM"), // lf
	KKJ("kkj"), // lf
	KL_GL("kl-GL"), // lf
	KL("kl"), // lf
	KLN_KE("kln-KE"), // lf
	KLN("kln"), // lf
	KM_KH("km-KH"), // lf
	KM("km"), // lf
	KN_IN("kn-IN"), // lf
	KN("kn"), // lf
	KO_KP("ko-KP"), // lf
	KO_KR("ko-KR"), // lf
	KO("ko"), // lf
	KOK_IN("kok-IN"), // lf
	KOK("kok"), // lf
	KR_LATN_NG("kr-Latn-NG"), // lf
	KR_LATN("kr-Latn"), // lf
	KR_NG("kr-NG"), // lf
	KR("kr"), // lf
	KS_ARAB_IN("ks-Arab-IN"), // lf
	KS_ARAB("ks-Arab"), // lf
	KS_DEVA_IN("ks-Deva-IN"), // lf
	KS_DEVA("ks-Deva"), // lf
	KS("ks"), // lf
	KSB_TZ("ksb-TZ"), // lf
	KSB("ksb"), // lf
	KSF_CM("ksf-CM"), // lf
	KSF("ksf"), // lf
	KSH_DE("ksh-DE"), // lf
	KSH("ksh"), // lf
	KU_ARAB_IQ("ku-Arab-IQ"), // lf
	KU_ARAB_IR("ku-Arab-IR"), // lf
	KU_ARAB("ku-Arab"), // lf
	KU("ku"), // lf
	KW_GB("kw-GB"), // lf
	KW("kw"), // lf
	KY_KG("ky-KG"), // lf
	KY("ky"), // lf
	LA_001("la-001"), // lf
	LA("la"), // lf
	LAG_TZ("lag-TZ"), // lf
	LAG("lag"), // lf
	LB_LU("lb-LU"), // lf
	LB("lb"), // lf
	LG_UG("lg-UG"), // lf
	LG("lg"), // lf
	LKT_US("lkt-US"), // lf
	LKT("lkt"), // lf
	LN_AO("ln-AO"), // lf
	LN_CD("ln-CD"), // lf
	LN_CF("ln-CF"), // lf
	LN_CG("ln-CG"), // lf
	LN("ln"), // lf
	LO_LA("lo-LA"), // lf
	LO("lo"), // lf
	LRC_IQ("lrc-IQ"), // lf
	LRC_IR("lrc-IR"), // lf
	LRC("lrc"), // lf
	LT_LT("lt-LT"), // lf
	LT("lt"), // lf
	LU_CD("lu-CD"), // lf
	LU("lu"), // lf
	LUO_KE("luo-KE"), // lf
	LUO("luo"), // lf
	LUY_KE("luy-KE"), // lf
	LUY("luy"), // lf
	LV_LV("lv-LV"), // lf
	LV("lv"), // lf
	MAS_KE("mas-KE"), // lf
	MAS_TZ("mas-TZ"), // lf
	MAS("mas"), // lf
	MER_KE("mer-KE"), // lf
	MER("mer"), // lf
	MFE_MU("mfe-MU"), // lf
	MFE("mfe"), // lf
	MG_MG("mg-MG"), // lf
	MG("mg"), // lf
	MGH_MZ("mgh-MZ"), // lf
	MGH("mgh"), // lf
	MGO_CM("mgo-CM"), // lf
	MGO("mgo"), // lf
	MI_NZ("mi-NZ"), // lf
	MI("mi"), // lf
	MK_MK("mk-MK"), // lf
	MK("mk"), // lf
	ML_IN("ml-IN"), // lf
	ML("ml"), // lf
	MN_CYRL("mn-Cyrl"), // lf
	MN_MN("mn-MN"), // lf
	MN_MONG_CN("mn-Mong-CN"), // lf
	MN_MONG_MN("mn-Mong-MN"), // lf
	MN_MONG("mn-Mong"), // lf
	MN("mn"), // lf
	MNI_IN("mni-IN"), // lf
	MNI("mni"), // lf
	MOH_CA("moh-CA"), // lf
	MOH("moh"), // lf
	MR_IN("mr-IN"), // lf
	MR("mr"), // lf
	MS_BN("ms-BN"), // lf
	MS_MY("ms-MY"), // lf
	MS_SG("ms-SG"), // lf
	MS("ms"), // lf
	MT_MT("mt-MT"), // lf
	MT("mt"), // lf
	MUA_CM("mua-CM"), // lf
	MUA("mua"), // lf
	MY_MM("my-MM"), // lf
	MY("my"), // lf
	MZN_IR("mzn-IR"), // lf
	MZN("mzn"), // lf
	NAQ_NA("naq-NA"), // lf
	NAQ("naq"), // lf
	NB_NO("nb-NO"), // lf
	NB_SJ("nb-SJ"), // lf
	NB("nb"), // lf
	ND_ZW("nd-ZW"), // lf
	ND("nd"), // lf
	NDS_DE("nds-DE"), // lf
	NDS_NL("nds-NL"), // lf
	NDS("nds"), // lf
	NE_IN("ne-IN"), // lf
	NE_NP("ne-NP"), // lf
	NE("ne"), // lf
	NL_AW("nl-AW"), // lf
	NL_BE("nl-BE"), // lf
	NL_BQ("nl-BQ"), // lf
	NL_CW("nl-CW"), // lf
	NL_NL("nl-NL"), // lf
	NL_SR("nl-SR"), // lf
	NL_SX("nl-SX"), // lf
	NL("nl"), // lf
	NMG_CM("nmg-CM"), // lf
	NMG("nmg"), // lf
	NN_NO("nn-NO"), // lf
	NN("nn"), // lf
	NNH_CM("nnh-CM"), // lf
	NNH("nnh"), // lf
	NO("no"), // lf
	NQO_GN("nqo-GN"), // lf
	NQO("nqo"), // lf
	NR_ZA("nr-ZA"), // lf
	NR("nr"), // lf
	NSO_ZA("nso-ZA"), // lf
	NSO("nso"), // lf
	NUS_SS("nus-SS"), // lf
	NUS("nus"), // lf
	NYN_UG("nyn-UG"), // lf
	NYN("nyn"), // lf
	OC_FR("oc-FR"), // lf
	OC("oc"), // lf
	OM_ET("om-ET"), // lf
	OM_KE("om-KE"), // lf
	OM("om"), // lf
	OR_IN("or-IN"), // lf
	OR("or"), // lf
	OS_GE("os-GE"), // lf
	OS_RU("os-RU"), // lf
	OS("os"), // lf
	PA_ARAB_PK("pa-Arab-PK"), // lf
	PA_ARAB("pa-Arab"), // lf
	PA_GURU("pa-Guru"), // lf
	PA_IN("pa-IN"), // lf
	PA("pa"), // lf
	PAP_029("pap-029"), // lf
	PAP("pap"), // lf
	PL_PL("pl-PL"), // lf
	PL("pl"), // lf
	PRG_001("prg-001"), // lf
	PRG("prg"), // lf
	PRS_AF("prs-AF"), // lf
	PRS("prs"), // lf
	PS_AF("ps-AF"), // lf
	PS("ps"), // lf
	PT_AO("pt-AO"), // lf
	PT_BR("pt-BR"), // lf
	PT_CH("pt-CH"), // lf
	PT_CV("pt-CV"), // lf
	PT_GQ("pt-GQ"), // lf
	PT_GW("pt-GW"), // lf
	PT_LU("pt-LU"), // lf
	PT_MO("pt-MO"), // lf
	PT_MZ("pt-MZ"), // lf
	PT_PT("pt-PT"), // lf
	PT_ST("pt-ST"), // lf
	PT_TL("pt-TL"), // lf
	PT("pt"), // lf
	QUC_LATN_GT("quc-Latn-GT"), // lf
	QUC_LATN("quc-Latn"), // lf
	QUC("quc"), // lf
	QUT_GT("qut-GT"), // lf
	QUT("qut"), // lf
	QUZ_BO("quz-BO"), // lf
	QUZ_EC("quz-EC"), // lf
	QUZ_PE("quz-PE"), // lf
	QUZ("quz"), // lf
	RM_CH("rm-CH"), // lf
	RM("rm"), // lf
	RN_BI("rn-BI"), // lf
	RN("rn"), // lf
	RO_MD("ro-MD"), // lf
	RO_RO("ro-RO"), // lf
	RO("ro"), // lf
	ROF_TZ("rof-TZ"), // lf
	ROF("rof"), // lf
	RU_BY("ru-BY"), // lf
	RU_KG("ru-KG"), // lf
	RU_KZ("ru-KZ"), // lf
	RU_MD("ru-MD"), // lf
	RU_RU("ru-RU"), // lf
	RU_UA("ru-UA"), // lf
	RU("ru"), // lf
	RW_RW("rw-RW"), // lf
	RW("rw"), // lf
	RWK_TZ("rwk-TZ"), // lf
	RWK("rwk"), // lf
	SA_IN("sa-IN"), // lf
	SA("sa"), // lf
	SAH_RU("sah-RU"), // lf
	SAH("sah"), // lf
	SAQ_KE("saq-KE"), // lf
	SAQ("saq"), // lf
	SBP_TZ("sbp-TZ"), // lf
	SBP("sbp"), // lf
	SD_ARAB_PK("sd-Arab-PK"), // lf
	SD_ARAB("sd-Arab"), // lf
	SD_DEVA_IN("sd-Deva-IN"), // lf
	SD_DEVA("sd-Deva"), // lf
	SD("sd"), // lf
	SE_FI("se-FI"), // lf
	SE_NO("se-NO"), // lf
	SE_SE("se-SE"), // lf
	SE("se"), // lf
	SEH_MZ("seh-MZ"), // lf
	SEH("seh"), // lf
	SES_ML("ses-ML"), // lf
	SES("ses"), // lf
	SG_CF("sg-CF"), // lf
	SG("sg"), // lf
	SHI_LATN_MA("shi-Latn-MA"), // lf
	SHI_LATN("shi-Latn"), // lf
	SHI_TFNG_MA("shi-Tfng-MA"), // lf
	SHI_TFNG("shi-Tfng"), // lf
	SHI("shi"), // lf
	SI_LK("si-LK"), // lf
	SI("si"), // lf
	SK_SK("sk-SK"), // lf
	SK("sk"), // lf
	SL_SI("sl-SI"), // lf
	SL("sl"), // lf
	SMA_NO("sma-NO"), // lf
	SMA_SE("sma-SE"), // lf
	SMA("sma"), // lf
	SMJ_NO("smj-NO"), // lf
	SMJ_SE("smj-SE"), // lf
	SMJ("smj"), // lf
	SMN_FI("smn-FI"), // lf
	SMN("smn"), // lf
	SMS_FI("sms-FI"), // lf
	SMS("sms"), // lf
	SN_LATN_ZW("sn-Latn-ZW"), // lf
	SN_LATN("sn-Latn"), // lf
	SN("sn"), // lf
	SO_DJ("so-DJ"), // lf
	SO_ET("so-ET"), // lf
	SO_KE("so-KE"), // lf
	SO_SO("so-SO"), // lf
	SO("so"), // lf
	SQ_AL("sq-AL"), // lf
	SQ_MK("sq-MK"), // lf
	SQ_XK("sq-XK"), // lf
	SQ("sq"), // lf
	SR_CYRL_BA("sr-Cyrl-BA"), // lf
	SR_CYRL_CS("sr-Cyrl-CS"), // lf
	SR_CYRL_ME("sr-Cyrl-ME"), // lf
	SR_CYRL_RS("sr-Cyrl-RS"), // lf
	SR_CYRL_XK("sr-Cyrl-XK"), // lf
	SR_CYRL("sr-Cyrl"), // lf
	SR_LATN_BA("sr-Latn-BA"), // lf
	SR_LATN_CS("sr-Latn-CS"), // lf
	SR_LATN_ME("sr-Latn-ME"), // lf
	SR_LATN_RS("sr-Latn-RS"), // lf
	SR_LATN_XK("sr-Latn-XK"), // lf
	SR_LATN("sr-Latn"), // lf
	SR("sr"), // lf
	SS_SZ("ss-SZ"), // lf
	SS_ZA("ss-ZA"), // lf
	SS("ss"), // lf
	SSY_ER("ssy-ER"), // lf
	SSY("ssy"), // lf
	ST_LS("st-LS"), // lf
	ST_ZA("st-ZA"), // lf
	ST("st"), // lf
	SV_AX("sv-AX"), // lf
	SV_FI("sv-FI"), // lf
	SV_SE("sv-SE"), // lf
	SV("sv"), // lf
	SW_CD("sw-CD"), // lf
	SW_KE("sw-KE"), // lf
	SW_TZ("sw-TZ"), // lf
	SW_UG("sw-UG"), // lf
	SW("sw"), // lf
	SYR_SY("syr-SY"), // lf
	SYR("syr"), // lf
	TA_IN("ta-IN"), // lf
	TA_LK("ta-LK"), // lf
	TA_MY("ta-MY"), // lf
	TA_SG("ta-SG"), // lf
	TA("ta"), // lf
	TE_IN("te-IN"), // lf
	TE("te"), // lf
	TEO_KE("teo-KE"), // lf
	TEO_UG("teo-UG"), // lf
	TEO("teo"), // lf
	TG_CYRL_TJ("tg-Cyrl-TJ"), // lf
	TG_CYRL("tg-Cyrl"), // lf
	TG("tg"), // lf
	TH_TH("th-TH"), // lf
	TH("th"), // lf
	TI_ER("ti-ER"), // lf
	TI_ET("ti-ET"), // lf
	TI("ti"), // lf
	TIG_ER("tig-ER"), // lf
	TIG("tig"), // lf
	TK_TM("tk-TM"), // lf
	TK("tk"), // lf
	TN_BW("tn-BW"), // lf
	TN_ZA("tn-ZA"), // lf
	TN("tn"), // lf
	TO_TO("to-TO"), // lf
	TO("to"), // lf
	TR_CY("tr-CY"), // lf
	TR_TR("tr-TR"), // lf
	TR("tr"), // lf
	TS_ZA("ts-ZA"), // lf
	TS("ts"), // lf
	TT_RU("tt-RU"), // lf
	TT("tt"), // lf
	TWQ_NE("twq-NE"), // lf
	TWQ("twq"), // lf
	TZM_ARAB_MA("tzm-Arab-MA"), // lf
	TZM_ARAB("tzm-Arab"), // lf
	TZM_LATN_DZ("tzm-Latn-DZ"), // lf
	TZM_LATN_MA("tzm-Latn-MA"), // lf
	TZM_LATN("tzm-Latn"), // lf
	TZM_TFNG_MA("tzm-Tfng-MA"), // lf
	TZM_TFNG("tzm-Tfng"), // lf
	TZM("tzm"), // lf
	UG_CN("ug-CN"), // lf
	UG("ug"), // lf
	UK_UA("uk-UA"), // lf
	UK("uk"), // lf
	UR_IN("ur-IN"), // lf
	UR_PK("ur-PK"), // lf
	UR("ur"), // lf
	UZ_ARAB_AF("uz-Arab-AF"), // lf
	UZ_ARAB("uz-Arab"), // lf
	UZ_CYRL_UZ("uz-Cyrl-UZ"), // lf
	UZ_CYRL("uz-Cyrl"), // lf
	UZ_LATN_UZ("uz-Latn-UZ"), // lf
	UZ_LATN("uz-Latn"), // lf
	UZ("uz"), // lf
	VAI_LATN_LR("vai-Latn-LR"), // lf
	VAI_LATN("vai-Latn"), // lf
	VAI_VAII_LR("vai-Vaii-LR"), // lf
	VAI_VAII("vai-Vaii"), // lf
	VAI("vai"), // lf
	VE_ZA("ve-ZA"), // lf
	VE("ve"), // lf
	VI_VN("vi-VN"), // lf
	VI("vi"), // lf
	VO_001("vo-001"), // lf
	VO("vo"), // lf
	VUN_TZ("vun-TZ"), // lf
	VUN("vun"), // lf
	WAE_CH("wae-CH"), // lf
	WAE("wae"), // lf
	WAL_ET("wal-ET"), // lf
	WAL("wal"), // lf
	WO_SN("wo-SN"), // lf
	WO("wo"), // lf
	XH_ZA("xh-ZA"), // lf
	XH("xh"), // lf
	XOG_UG("xog-UG"), // lf
	XOG("xog"), // lf
	YAV_CM("yav-CM"), // lf
	YAV("yav"), // lf
	YI_001("yi-001"), // lf
	YI("yi"), // lf
	YO_BJ("yo-BJ"), // lf
	YO_NG("yo-NG"), // lf
	YO("yo"), // lf
	ZGH_TFNG_MA("zgh-Tfng-MA"), // lf
	ZGH_TFNG("zgh-Tfng"), // lf
	ZGH("zgh"), // lf
	ZH_CHS("zh-CHS"), // lf
	ZH_CHT("zh-CHT"), // lf
	ZH_CN("zh-CN"), // lf
	ZH_HANS_HK("zh-Hans-HK"), // lf
	ZH_HANS_MO("zh-Hans-MO"), // lf
	ZH_HANS("zh-Hans"), // lf
	ZH_HANT("zh-Hant"), // lf
	ZH_HK("zh-HK"), // lf
	ZH_MO("zh-MO"), // lf
	ZH_SG("zh-SG"), // lf
	ZH_TW("zh-TW"), // lf
	ZH("zh"), // lf
	ZU_ZA("zu-ZA"), // lf
	ZU("zu");

	private final String culture;

	/**
	 * Constructor
	 */
	private KendoCulture(String culture)
	{
		this.culture = culture;
	}

	@Override
	public String toString()
	{
		return this.culture;
	}

	/**
	 * Indicates whether the specified {@link Locale} is currently supported
	 * 
	 * @param locale the {@code Locale}
	 * @return {@code true} or {@code false}
	 */
	public static boolean exists(Locale locale)
	{
		return KendoCulture.exists(locale.toLanguageTag());
	}

	/**
	 * Indicates whether the specified culture is currently supported
	 * 
	 * @param culture the culture
	 * @return {@code true} or {@code false}
	 */
	public static boolean exists(String culture)
	{
		if (culture != null)
		{
			for (KendoCulture c : KendoCulture.values())
			{
				if (culture.equalsIgnoreCase(c.toString()))
				{
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * Gets the first supported culture in the specified array of cultures
	 * 
	 * @param cultures the array of cultures
	 * @return the first supported culture, or {@code null}
	 */
	public static String get(String... cultures)
	{
		for (String culture : cultures)
		{
			if (KendoCulture.exists(culture))
			{
				return culture;
			}
		}

		return null;
	}
}
