/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.widget.window.IWindowListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.util.lang.Args;

public class WindowBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoWindow";
    private final IWindowListener listener;
    private JQueryAjaxBehavior onActionAjaxBehavior = null;
    private JQueryAjaxBehavior onCloseAjaxBehavior = null;

    public WindowBehavior(String selector, IWindowListener listener) {
        this(selector, new Options(), listener);
    }

    public WindowBehavior(String selector, Options options, IWindowListener listener) {
        super(selector, METHOD, options);
        this.listener = (IWindowListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isActionEventEnabled()) {
            this.onActionAjaxBehavior = this.newOnActionAjaxBehavior(this);
            component.add(new Behavior[]{this.onActionAjaxBehavior});
        }
        if (this.listener.isCloseEventEnabled()) {
            this.onCloseAjaxBehavior = this.newOnCloseAjaxBehavior(this);
            component.add(new Behavior[]{this.onCloseAjaxBehavior});
        }
    }

    public void open(IPartialPageRequestHandler handler) {
        if (this.isCentered()) {
            handler.appendJavaScript((CharSequence)(this.widget() + ".center();"));
        }
        handler.appendJavaScript((CharSequence)(this.widget() + ".open();"));
    }

    public void close(IPartialPageRequestHandler handler) {
        handler.prependJavaScript((CharSequence)(this.widget() + ".close();"));
    }

    protected boolean isCentered() {
        return false;
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onActionAjaxBehavior != null) {
            this.register(String.format("%s.wrapper.find('a.k-window-action').click(%s);", this.widget(), this.onActionAjaxBehavior.getCallbackFunction()));
        }
        if (this.onCloseAjaxBehavior != null) {
            this.setOption("close", this.onCloseAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ActionEvent) {
            this.listener.onAction(target, ((ActionEvent)event).getAction());
        }
        if (event instanceof CloseEvent) {
            this.listener.onClose((IPartialPageRequestHandler)target);
        }
    }

    protected JQueryAjaxBehavior newOnActionAjaxBehavior(IJQueryAjaxAware source) {
        return new OnActionAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnCloseAjaxBehavior(IJQueryAjaxAware source) {
        return new OnCloseAjaxBehavior(source);
    }

    protected static class ActionEvent
    extends JQueryEvent {
        private final String action = RequestCycleUtils.getQueryParameterValue((String)"action").toString();

        public String getAction() {
            return this.action;
        }
    }

    protected static class CloseEvent
    extends JQueryEvent {
        protected CloseEvent() {
        }
    }

    protected static class OnActionAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnActionAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"action", (String)"jQuery(e.target).find('span').attr('class').match(/k-i-(\\w+)/)[1]")};
        }

        protected JQueryEvent newEvent() {
            return new ActionEvent();
        }
    }

    protected static class OnCloseAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnCloseAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        public String getCallbackFunction() {
            return "function(e) { if (e.userTriggered) { " + this.getCallbackScript() + " } }";
        }

        protected JQueryEvent newEvent() {
            return new CloseEvent();
        }
    }
}

