/*
 * Decompiled with CFR 0.152.
 */
package com.gordonwong.materialsheetfab;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.gordonwong.materialsheetfab.AnimatedFab;
import com.gordonwong.materialsheetfab.MaterialSheetFabEventListener;
import com.gordonwong.materialsheetfab.R;
import com.gordonwong.materialsheetfab.animations.AnimationListener;
import com.gordonwong.materialsheetfab.animations.FabAnimation;
import com.gordonwong.materialsheetfab.animations.MaterialSheetAnimation;
import com.gordonwong.materialsheetfab.animations.OverlayAnimation;
import io.codetail.animation.arcanimator.Side;

public class MaterialSheetFab<FAB extends View> {
    private static final boolean IS_LOLLIPOP = Build.VERSION.SDK_INT >= 21;
    private static final int ANIMATION_SPEED = 1;
    private static final int SHEET_ANIM_DURATION = (IS_LOLLIPOP ? 600 : 300) * 1;
    private static final int SHOW_SHEET_COLOR_ANIM_DURATION = (int)((double)SHEET_ANIM_DURATION * 0.75);
    private static final int HIDE_SHEET_COLOR_ANIM_DURATION = IS_LOLLIPOP ? (int)((double)SHEET_ANIM_DURATION * 1.5) : SHEET_ANIM_DURATION * 2;
    private static final int FAB_ANIM_DURATION = 300;
    private static final int SHOW_OVERLAY_ANIM_DURATION = 150 + SHEET_ANIM_DURATION;
    private static final int HIDE_OVERLAY_ANIM_DURATION = SHEET_ANIM_DURATION;
    private static final int SHOW_SHEET_ANIM_DELAY = 150;
    private static final int MOVE_FAB_ANIM_DELAY = IS_LOLLIPOP ? (int)((double)SHEET_ANIM_DURATION * 0.3) : (int)((double)SHEET_ANIM_DURATION * 0.6);
    private static final float FAB_SCALE_FACTOR = 0.6f;
    private static final int FAB_ARC_DEGREES = 0;
    protected FAB fab;
    protected FabAnimation fabAnimation;
    protected MaterialSheetAnimation sheetAnimation;
    protected OverlayAnimation overlayAnimation;
    protected int anchorX;
    protected int anchorY;
    private boolean isShowing;
    private boolean isHiding;
    private boolean hideSheetAfterSheetIsShown;
    private MaterialSheetFabEventListener eventListener;

    public MaterialSheetFab(FAB fab, View sheet, View overlay, int sheetColor, int fabColor) {
        Interpolator interpolator2 = AnimationUtils.loadInterpolator((Context)sheet.getContext(), (int)R.interpolator.msf_interpolator);
        this.fab = fab;
        this.fabAnimation = new FabAnimation((View)fab, interpolator2);
        this.sheetAnimation = new MaterialSheetAnimation(sheet, sheetColor, fabColor, interpolator2);
        this.overlayAnimation = new OverlayAnimation(overlay, interpolator2);
        sheet.setVisibility(4);
        overlay.setVisibility(8);
        fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialSheetFab.this.showSheet();
            }
        });
        overlay.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (MaterialSheetFab.this.isSheetVisible() && motionEvent.getAction() == 0) {
                    MaterialSheetFab.this.hideSheet();
                }
                return true;
            }
        });
        fab.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MaterialSheetFab.this.fab.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                MaterialSheetFab.this.updateFabAnchor();
            }
        });
    }

    public void showFab() {
        this.showFab(0.0f, 0.0f);
    }

    public void showFab(float translationX, float translationY) {
        this.setFabAnchor(translationX, translationY);
        if (!this.isSheetVisible()) {
            ((AnimatedFab)this.fab).show(translationX, translationY);
        }
    }

    public void showSheet() {
        if (this.isAnimating()) {
            return;
        }
        this.isShowing = true;
        this.overlayAnimation.show(SHOW_OVERLAY_ANIM_DURATION, null);
        this.morphIntoSheet(new AnimationListener(){

            @Override
            public void onEnd() {
                if (MaterialSheetFab.this.eventListener != null) {
                    MaterialSheetFab.this.eventListener.onSheetShown();
                }
                MaterialSheetFab.this.isShowing = false;
                if (MaterialSheetFab.this.hideSheetAfterSheetIsShown) {
                    MaterialSheetFab.this.hideSheet();
                    MaterialSheetFab.this.hideSheetAfterSheetIsShown = false;
                }
            }
        });
        if (this.eventListener != null) {
            this.eventListener.onShowSheet();
        }
    }

    public void hideSheet() {
        this.hideSheet(null);
    }

    protected void hideSheet(final AnimationListener endListener) {
        if (this.isAnimating()) {
            if (this.isShowing) {
                this.hideSheetAfterSheetIsShown = true;
            }
            return;
        }
        this.isHiding = true;
        this.overlayAnimation.hide(HIDE_OVERLAY_ANIM_DURATION, null);
        this.morphFromSheet(new AnimationListener(){

            @Override
            public void onEnd() {
                if (endListener != null) {
                    endListener.onEnd();
                }
                if (MaterialSheetFab.this.eventListener != null) {
                    MaterialSheetFab.this.eventListener.onSheetHidden();
                }
                MaterialSheetFab.this.isHiding = false;
            }
        });
        if (this.eventListener != null) {
            this.eventListener.onHideSheet();
        }
    }

    public void hideSheetThenFab() {
        AnimationListener listener = new AnimationListener(){

            @Override
            public void onEnd() {
                ((AnimatedFab)MaterialSheetFab.this.fab).hide();
            }
        };
        if (this.isSheetVisible()) {
            this.hideSheet(listener);
        } else {
            listener.onEnd();
        }
    }

    protected void morphIntoSheet(final AnimationListener endListener) {
        this.updateFabAnchor();
        this.sheetAnimation.alignSheetWithFab((View)this.fab);
        this.fabAnimation.morphIntoSheet(this.sheetAnimation.getSheetRevealCenterX(), this.sheetAnimation.getSheetRevealCenterY((View)this.fab), this.getFabArcSide(this.sheetAnimation.getRevealXDirection()), 0, 0.6f, 300L, null);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                MaterialSheetFab.this.fab.setVisibility(4);
                MaterialSheetFab.this.sheetAnimation.morphFromFab((View)MaterialSheetFab.this.fab, SHEET_ANIM_DURATION, SHOW_SHEET_COLOR_ANIM_DURATION, endListener);
            }
        }, 150L);
    }

    protected void morphFromSheet(final AnimationListener endListener) {
        this.sheetAnimation.morphIntoFab((View)this.fab, SHEET_ANIM_DURATION, HIDE_SHEET_COLOR_ANIM_DURATION, null);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                MaterialSheetFab.this.sheetAnimation.setSheetVisibility(4);
                MaterialSheetFab.this.fabAnimation.morphFromSheet(MaterialSheetFab.this.anchorX, MaterialSheetFab.this.anchorY, MaterialSheetFab.this.getFabArcSide(MaterialSheetFab.this.sheetAnimation.getRevealXDirection()), 0, -0.6f, 300L, endListener);
            }
        }, (long)MOVE_FAB_ANIM_DELAY);
    }

    protected void updateFabAnchor() {
        this.setFabAnchor(this.fab.getTranslationX(), this.fab.getTranslationY());
    }

    protected void setFabAnchor(float translationX, float translationY) {
        this.anchorX = Math.round(this.fab.getX() + (float)(this.fab.getWidth() / 2) + (translationX - this.fab.getTranslationX()));
        this.anchorY = Math.round(this.fab.getY() + (float)(this.fab.getHeight() / 2) + (translationY - this.fab.getTranslationY()));
    }

    private Side getFabArcSide(RevealXDirection revealXDirection) {
        if (revealXDirection == RevealXDirection.LEFT) {
            return Side.LEFT;
        }
        return Side.RIGHT;
    }

    private boolean isAnimating() {
        return this.isShowing || this.isHiding;
    }

    public boolean isSheetVisible() {
        return this.sheetAnimation.isSheetVisible();
    }

    public void setEventListener(MaterialSheetFabEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public static enum RevealYDirection {
        UP,
        DOWN;

    }

    public static enum RevealXDirection {
        LEFT,
        RIGHT;

    }
}

