/*
 * Decompiled with CFR 0.152.
 */
package com.gordonwong.materialsheetfab.animations;

import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.Interpolator;
import com.gordonwong.materialsheetfab.animations.AnimationListener;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import io.codetail.animation.arcanimator.ArcAnimator;
import io.codetail.animation.arcanimator.Side;

public class FabAnimation {
    protected View fab;
    protected Interpolator interpolator;

    public FabAnimation(View fab, Interpolator interpolator2) {
        this.fab = fab;
        this.interpolator = interpolator2;
    }

    public void morphIntoSheet(int endX, int endY, Side side, int arcDegrees, float scaleFactor, long duration, AnimationListener listener) {
        this.morph(endX, endY, side, arcDegrees, scaleFactor, duration, listener);
    }

    public void morphFromSheet(int endX, int endY, Side side, int arcDegrees, float scaleFactor, long duration, AnimationListener listener) {
        this.fab.setVisibility(0);
        this.morph(endX, endY, side, arcDegrees, scaleFactor, duration, listener);
    }

    protected void morph(float endX, float endY, Side side, float arcDegrees, float scaleFactor, long duration, AnimationListener listener) {
        this.startArcAnim(this.fab, endX, endY, arcDegrees, side, duration, this.interpolator, listener);
        this.fab.animate().scaleXBy(scaleFactor).scaleYBy(scaleFactor).setDuration(duration).setInterpolator((TimeInterpolator)this.interpolator).start();
    }

    protected void startArcAnim(View view, float endX, float endY, float degrees, Side side, long duration, Interpolator interpolator2, final AnimationListener listener) {
        ArcAnimator anim = ArcAnimator.createArcAnimator((View)view, (float)((int)endX), (float)((int)endY), (float)degrees, (Side)side);
        anim.setDuration(duration);
        anim.setInterpolator(interpolator2);
        anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onEnd();
                }
            }
        });
        anim.start();
    }
}

