/*
 * Decompiled with CFR 0.152.
 */
package com.gordonwong.materialsheetfab.animations;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.os.Build;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.gordonwong.materialsheetfab.MaterialSheetFab;
import com.gordonwong.materialsheetfab.animations.AnimationListener;
import io.codetail.animation.SupportAnimator;
import java.lang.reflect.Method;

public class MaterialSheetAnimation {
    private static final String SUPPORT_CARDVIEW_CLASSNAME = "android.support.v7.widget.CardView";
    private static final int SHEET_REVEAL_OFFSET_Y = 5;
    private View sheet;
    private int sheetColor;
    private int fabColor;
    private Interpolator interpolator;
    private MaterialSheetFab.RevealXDirection revealXDirection;
    private MaterialSheetFab.RevealYDirection revealYDirection;
    private Method setCardBackgroundColor;
    private boolean isSupportCardView;

    public MaterialSheetAnimation(View sheet, int sheetColor, int fabColor, Interpolator interpolator2) {
        this.sheet = sheet;
        this.sheetColor = sheetColor;
        this.fabColor = fabColor;
        this.interpolator = interpolator2;
        this.revealXDirection = MaterialSheetFab.RevealXDirection.LEFT;
        this.revealYDirection = MaterialSheetFab.RevealYDirection.UP;
        this.isSupportCardView = sheet.getClass().getName().equals(SUPPORT_CARDVIEW_CLASSNAME);
        if (this.isSupportCardView) {
            try {
                this.setCardBackgroundColor = sheet.getClass().getDeclaredMethod("setCardBackgroundColor", Integer.TYPE);
            }
            catch (Exception e) {
                this.setCardBackgroundColor = null;
            }
        }
    }

    public void alignSheetWithFab(View fab) {
        int[] fabCoords = new int[2];
        fab.getLocationOnScreen(fabCoords);
        int[] sheetCoords = new int[2];
        this.sheet.getLocationOnScreen(sheetCoords);
        int leftDiff = sheetCoords[0] - fabCoords[0];
        int rightDiff = sheetCoords[0] + this.sheet.getWidth() - (fabCoords[0] + fab.getWidth());
        int topDiff = sheetCoords[1] - fabCoords[1];
        int bottomDiff = sheetCoords[1] + this.sheet.getHeight() - (fabCoords[1] + fab.getHeight());
        ViewGroup.MarginLayoutParams sheetLayoutParams = (ViewGroup.MarginLayoutParams)this.sheet.getLayoutParams();
        if (rightDiff != 0) {
            float sheetX = this.sheet.getX();
            if ((float)rightDiff <= sheetX) {
                this.sheet.setX(sheetX - (float)rightDiff - (float)sheetLayoutParams.rightMargin);
                this.revealXDirection = MaterialSheetFab.RevealXDirection.LEFT;
            } else if (leftDiff != 0 && (float)leftDiff <= sheetX) {
                this.sheet.setX(sheetX - (float)leftDiff + (float)sheetLayoutParams.leftMargin);
                this.revealXDirection = MaterialSheetFab.RevealXDirection.RIGHT;
            }
        }
        if (bottomDiff != 0) {
            float sheetY = this.sheet.getY();
            if ((float)bottomDiff <= sheetY) {
                this.sheet.setY(sheetY - (float)bottomDiff - (float)sheetLayoutParams.bottomMargin);
                this.revealYDirection = MaterialSheetFab.RevealYDirection.UP;
            } else if (topDiff != 0 && (float)topDiff <= sheetY) {
                this.sheet.setY(sheetY - (float)topDiff + (float)sheetLayoutParams.topMargin);
                this.revealYDirection = MaterialSheetFab.RevealYDirection.DOWN;
            }
        }
    }

    public void morphFromFab(View fab, long showSheetDuration, long showSheetColorDuration, AnimationListener listener) {
        this.sheet.setVisibility(0);
        this.revealSheetWithFab(fab, this.getFabRevealRadius(fab), this.getSheetRevealRadius(), showSheetDuration, this.fabColor, this.sheetColor, showSheetColorDuration, listener);
    }

    public void morphIntoFab(View fab, long hideSheetDuration, long hideSheetColorDuration, AnimationListener listener) {
        this.revealSheetWithFab(fab, this.getSheetRevealRadius(), this.getFabRevealRadius(fab), hideSheetDuration, this.sheetColor, this.fabColor, hideSheetColorDuration, listener);
    }

    protected void revealSheetWithFab(View fab, float startRadius, float endRadius, long sheetDuration, int startColor, int endColor, long sheetColorDuration, AnimationListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        AnimationListener revealListener = sheetDuration >= sheetColorDuration ? listener : null;
        AnimationListener colorListener = sheetColorDuration > sheetDuration ? listener : null;
        this.startCircularRevealAnim(this.sheet, this.getSheetRevealCenterX(), this.getSheetRevealCenterY(fab), startRadius, endRadius, sheetDuration, this.interpolator, revealListener);
        this.startColorAnim(this.sheet, startColor, endColor, sheetColorDuration, this.interpolator, colorListener);
    }

    protected void startCircularRevealAnim(View view, int centerX, int centerY, float startRadius, float endRadius, long duration, Interpolator interpolator2, final AnimationListener listener) {
        if (Build.VERSION.SDK_INT >= 21) {
            int relativeCenterX = (int)((float)centerX - view.getX());
            int relativeCenterY = (int)((float)centerY - view.getY());
            Animator anim = ViewAnimationUtils.createCircularReveal((View)view, (int)relativeCenterX, (int)relativeCenterY, (float)startRadius, (float)endRadius);
            anim.setDuration(duration);
            anim.setInterpolator((TimeInterpolator)interpolator2);
            anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    if (listener != null) {
                        listener.onStart();
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (listener != null) {
                        listener.onEnd();
                    }
                }
            });
            anim.start();
        } else {
            SupportAnimator anim = io.codetail.animation.ViewAnimationUtils.createCircularReveal(view, centerX, centerY, startRadius, endRadius);
            anim.setDuration((int)duration);
            anim.setInterpolator(interpolator2);
            anim.addListener(new SupportAnimator.SimpleAnimatorListener(){

                @Override
                public void onAnimationStart() {
                    if (listener != null) {
                        listener.onStart();
                    }
                }

                @Override
                public void onAnimationEnd() {
                    if (listener != null) {
                        listener.onEnd();
                    }
                }
            });
            anim.start();
        }
    }

    protected void startColorAnim(final View view, int startColor, int endColor, long duration, Interpolator interpolator2, final AnimationListener listener) {
        ValueAnimator anim = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{startColor, endColor});
        anim.setDuration(duration);
        anim.setInterpolator((TimeInterpolator)interpolator2);
        anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onEnd();
                }
            }
        });
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                Integer color = (Integer)animator.getAnimatedValue();
                if (MaterialSheetAnimation.this.isSupportCardView) {
                    if (MaterialSheetAnimation.this.setCardBackgroundColor != null) {
                        try {
                            MaterialSheetAnimation.this.setCardBackgroundColor.invoke((Object)MaterialSheetAnimation.this.sheet, color);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    view.setBackgroundColor(color.intValue());
                }
            }
        });
        anim.start();
    }

    public void setSheetVisibility(int visibility) {
        this.sheet.setVisibility(visibility);
    }

    public boolean isSheetVisible() {
        return this.sheet.getVisibility() == 0;
    }

    public int getSheetRevealCenterX() {
        return (int)(this.sheet.getX() + (float)(this.sheet.getWidth() / 2));
    }

    public int getSheetRevealCenterY(View fab) {
        if (this.revealYDirection == MaterialSheetFab.RevealYDirection.UP) {
            return (int)(this.sheet.getY() + (float)(this.sheet.getHeight() * 4 / 5) - (float)(fab.getHeight() / 2));
        }
        return (int)(this.sheet.getY() + (float)(this.sheet.getHeight() / 5) + (float)(fab.getHeight() / 2));
    }

    protected float getSheetRevealRadius() {
        return Math.max(this.sheet.getWidth(), this.sheet.getHeight());
    }

    protected float getFabRevealRadius(View fab) {
        return Math.max(fab.getWidth(), fab.getHeight()) / 2;
    }

    public MaterialSheetFab.RevealXDirection getRevealXDirection() {
        return this.revealXDirection;
    }

    public MaterialSheetFab.RevealYDirection getRevealYDirection() {
        return this.revealYDirection;
    }
}

