/*
 * Decompiled with CFR 0.152.
 */
package com.gordonwong.materialsheetfab.animations;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.Interpolator;
import com.gordonwong.materialsheetfab.animations.AnimationListener;

public class OverlayAnimation {
    protected View overlay;
    protected Interpolator interpolator;

    public OverlayAnimation(View overlay, Interpolator interpolator2) {
        this.overlay = overlay;
        this.interpolator = interpolator2;
    }

    public void show(long duration, final AnimationListener listener) {
        this.overlay.animate().alpha(1.0f).setDuration(duration).setInterpolator((TimeInterpolator)this.interpolator).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                OverlayAnimation.this.overlay.setVisibility(0);
                if (listener != null) {
                    listener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onEnd();
                }
            }
        }).start();
    }

    public void hide(long duration, final AnimationListener listener) {
        this.overlay.animate().alpha(0.0f).setDuration(duration).setInterpolator((TimeInterpolator)this.interpolator).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                OverlayAnimation.this.overlay.setVisibility(8);
                if (listener != null) {
                    listener.onEnd();
                }
            }
        }).start();
    }
}

